/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.vectorization;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.VectorSpecies;
import org.apache.lucene.internal.vectorization.PanamaVectorUtilSupport;
import org.apache.lucene.internal.vectorization.VectorUtilSupport;
import org.apache.lucene.internal.vectorization.VectorizationProvider;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.SuppressForbidden;

final class PanamaVectorizationProvider
extends VectorizationProvider {
    private final VectorUtilSupport vectorUtilSupport;
    private final boolean hasFastIntegerVectors;

    @SuppressForbidden(reason="security manager")
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    PanamaVectorizationProvider(boolean testMode) {
        int intPreferredBitSize = IntVector.SPECIES_PREFERRED.vectorBitSize();
        if (!testMode && intPreferredBitSize < 128) {
            throw new UnsupportedOperationException("Vector bit size is less than 128: " + intPreferredBitSize);
        }
        try {
            PanamaVectorizationProvider.doPrivileged(() -> FloatVector.fromArray((VectorSpecies)FloatVector.SPECIES_PREFERRED, (float[])new float[FloatVector.SPECIES_PREFERRED.length()], (int)0));
        }
        catch (SecurityException se) {
            throw new UnsupportedOperationException("We hit initialization failure described in JDK-8309727: " + se);
        }
        boolean isAMD64withoutAVX2 = Constants.OS_ARCH.equals("amd64") && intPreferredBitSize < 256;
        this.hasFastIntegerVectors = testMode || false == isAMD64withoutAVX2;
        this.vectorUtilSupport = new PanamaVectorUtilSupport(this.hasFastIntegerVectors);
        Logger log = Logger.getLogger(this.getClass().getName());
        log.info("Java vector incubator API enabled" + (testMode ? " (test mode)" : "") + "; uses preferredBitSize=" + intPreferredBitSize);
    }

    @Override
    public VectorUtilSupport getVectorUtilSupport() {
        return this.vectorUtilSupport;
    }
}

