/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.identity.model.User;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListUsersRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String page;
    private Integer limit;
    private String identityProviderId;
    private String externalIdentifier;
    private String name;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private User.LifecycleState lifecycleState;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public String getName() {
        return this.name;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public User.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).page(this.page).limit(this.limit).identityProviderId(this.identityProviderId).externalIdentifier(this.externalIdentifier).name(this.name).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",identityProviderId=").append(String.valueOf(this.identityProviderId));
        sb.append(",externalIdentifier=").append(String.valueOf(this.externalIdentifier));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListUsersRequest)) {
            return false;
        }
        ListUsersRequest other = (ListUsersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals(this.identityProviderId, other.identityProviderId) && Objects.equals(this.externalIdentifier, other.externalIdentifier) && Objects.equals(this.name, other.name) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.identityProviderId == null ? 43 : this.identityProviderId.hashCode());
        result = result * 59 + (this.externalIdentifier == null ? 43 : this.externalIdentifier.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListUsersRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String page = null;
        private Integer limit = null;
        private String identityProviderId = null;
        private String externalIdentifier = null;
        private String name = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private User.LifecycleState lifecycleState = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(User.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListUsersRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.identityProviderId(o.getIdentityProviderId());
            this.externalIdentifier(o.getExternalIdentifier());
            this.name(o.getName());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListUsersRequest build() {
            ListUsersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListUsersRequest buildWithoutInvocationCallback() {
            ListUsersRequest request = new ListUsersRequest();
            request.compartmentId = this.compartmentId;
            request.page = this.page;
            request.limit = this.limit;
            request.identityProviderId = this.identityProviderId;
            request.externalIdentifier = this.externalIdentifier;
            request.name = this.name;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.lifecycleState = this.lifecycleState;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Timecreated("TIMECREATED"),
        Name("NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

