/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.ibm.icu.text.DisplayContext;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RelativeDateTimeFormatter;
import com.ibm.icu.util.ULocale;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.intl.RelativeTimeFormatFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.RelativeTimeFormatPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSRelativeTimeFormatObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.LazyValue;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Locale;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class JSRelativeTimeFormat
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "RelativeTimeFormat";
    public static final String PROTOTYPE_NAME = "RelativeTimeFormat.prototype";
    public static final JSRelativeTimeFormat INSTANCE = new JSRelativeTimeFormat();
    private static final LazyValue<UnmodifiableEconomicMap<String, RelativeDateTimeFormatter.RelativeDateTimeUnit>> timeUnitMap = new LazyValue<UnmodifiableEconomicMap>(JSRelativeTimeFormat::initTimeUnitMap);

    private JSRelativeTimeFormat() {
    }

    public static boolean isJSRelativeTimeFormat(Object obj) {
        return obj instanceof JSRelativeTimeFormatObject;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject relativeTimeFormatPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, relativeTimeFormatPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, relativeTimeFormatPrototype, RelativeTimeFormatPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(relativeTimeFormatPrototype, "Intl.RelativeTimeFormat");
        return relativeTimeFormatPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, RelativeTimeFormatFunctionBuiltins.BUILTINS);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getRelativeTimeFormatFactory();
        JSRelativeTimeFormatObject obj = new JSRelativeTimeFormatObject(factory.getShape(realm), state);
        factory.initProto(obj, realm);
        assert (JSRelativeTimeFormat.isJSRelativeTimeFormat((Object)obj));
        return context.trackAllocation(obj);
    }

    public static RelativeDateTimeFormatter getRelativeDateTimeFormatterProperty(DynamicObject obj) {
        return JSRelativeTimeFormat.getInternalState(obj).getRelativeDateTimeFormatter();
    }

    private static void ensureFiniteNumber(double d) {
        if (!Double.isFinite(d)) {
            throw Errors.createRangeError("Value need to be finite number for Intl.RelativeTimeFormat operation");
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static String format(DynamicObject relativeTimeFormatObj, double amount, String unit) {
        JSRelativeTimeFormat.ensureFiniteNumber(amount);
        InternalState state = JSRelativeTimeFormat.getInternalState(relativeTimeFormatObj);
        RelativeDateTimeFormatter.RelativeDateTimeUnit icuUnit = JSRelativeTimeFormat.singularRelativeTimeUnit("format", unit);
        return JSRelativeTimeFormat.innerFormat(amount, state, state.getRelativeDateTimeFormatter(), icuUnit);
    }

    private static String innerFormat(double amount, InternalState state, RelativeDateTimeFormatter relativeDateTimeFormatter, RelativeDateTimeFormatter.RelativeDateTimeUnit icuUnit) {
        if (state.getNumeric().equals("always")) {
            return relativeDateTimeFormatter.formatNumeric(amount, icuUnit);
        }
        return relativeDateTimeFormatter.format(amount, icuUnit);
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject formatToParts(JSContext context, DynamicObject relativeTimeFormatObj, double amount, String unit) {
        JSRelativeTimeFormat.ensureFiniteNumber(amount);
        InternalState state = JSRelativeTimeFormat.getInternalState(relativeTimeFormatObj);
        RelativeDateTimeFormatter relativeDateTimeFormatter = state.getRelativeDateTimeFormatter();
        NumberFormat numberFormat = relativeDateTimeFormatter.getNumberFormat();
        RelativeDateTimeFormatter.RelativeDateTimeUnit icuUnit = JSRelativeTimeFormat.singularRelativeTimeUnit("formatToParts", unit);
        String formattedText = JSRelativeTimeFormat.innerFormat(amount, state, relativeDateTimeFormatter, icuUnit);
        double positiveAmount = Math.abs(amount);
        String formattedNumber = numberFormat.format(positiveAmount);
        int numberIndex = formattedText.indexOf(formattedNumber);
        boolean numberPresentInFormattedText = numberIndex > -1;
        ArrayList<DynamicObject> resultParts = new ArrayList<DynamicObject>();
        if (numberPresentInFormattedText) {
            if (numberIndex > 0) {
                resultParts.add(IntlUtil.makePart(context, "literal", formattedText.substring(0, numberIndex)));
            }
            String esUnit = icuUnit.toString().toLowerCase();
            AttributedCharacterIterator iterator = numberFormat.formatToCharacterIterator((Object)positiveAmount);
            String formatted = numberFormat.format(positiveAmount);
            resultParts.addAll(JSNumberFormat.innerFormatToParts(context, iterator, positiveAmount, formatted, esUnit, false));
            if (numberIndex + formattedNumber.length() < formattedText.length()) {
                resultParts.add(IntlUtil.makePart(context, "literal", formattedText.substring(numberIndex + formattedNumber.length(), formattedText.length())));
            }
        } else {
            resultParts.add(IntlUtil.makePart(context, "literal", formattedText));
        }
        return JSArray.createConstant(context, resultParts.toArray());
    }

    private static RelativeDateTimeFormatter createFormatter(Locale locale, String style) {
        ULocale ulocale = ULocale.forLocale((Locale)locale);
        return RelativeDateTimeFormatter.getInstance((ULocale)ulocale, null, (RelativeDateTimeFormatter.Style)RelativeDateTimeFormatter.Style.valueOf((String)style.toUpperCase()), (DisplayContext)DisplayContext.CAPITALIZATION_NONE);
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, DynamicObject relativeTimeFormatObj) {
        InternalState state = JSRelativeTimeFormat.getInternalState(relativeTimeFormatObj);
        return state.toResolvedOptionsObject(context);
    }

    public static InternalState getInternalState(DynamicObject obj) {
        assert (JSRelativeTimeFormat.isJSRelativeTimeFormat(obj));
        return ((JSRelativeTimeFormatObject)obj).getInternalState();
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getRelativeTimeFormatPrototype();
    }

    private static RelativeDateTimeFormatter.RelativeDateTimeUnit toRelTimeUnit(String unit) {
        return (RelativeDateTimeFormatter.RelativeDateTimeUnit)timeUnitMap.get().get((Object)unit);
    }

    private static UnmodifiableEconomicMap<String, RelativeDateTimeFormatter.RelativeDateTimeUnit> initTimeUnitMap() {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap map = EconomicMap.create((int)16);
        map.put((Object)"second", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.SECOND);
        map.put((Object)"seconds", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.SECOND);
        map.put((Object)"minute", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.MINUTE);
        map.put((Object)"minutes", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.MINUTE);
        map.put((Object)"hour", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.HOUR);
        map.put((Object)"hours", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.HOUR);
        map.put((Object)"day", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.DAY);
        map.put((Object)"days", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.DAY);
        map.put((Object)"week", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.WEEK);
        map.put((Object)"weeks", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.WEEK);
        map.put((Object)"month", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.MONTH);
        map.put((Object)"months", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.MONTH);
        map.put((Object)"quarter", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.QUARTER);
        map.put((Object)"quarters", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.QUARTER);
        map.put((Object)"year", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.YEAR);
        map.put((Object)"years", (Object)RelativeDateTimeFormatter.RelativeDateTimeUnit.YEAR);
        return map;
    }

    private static RelativeDateTimeFormatter.RelativeDateTimeUnit singularRelativeTimeUnit(String functionName, String unit) {
        RelativeDateTimeFormatter.RelativeDateTimeUnit result = JSRelativeTimeFormat.toRelTimeUnit(unit);
        if (result != null) {
            return result;
        }
        throw Errors.createRangeErrorInvalidUnitArgument(functionName, unit);
    }

    public static class InternalState
    extends JSNumberFormat.BasicInternalState {
        private RelativeDateTimeFormatter relativeDateTimeFormatter;
        private String style;
        private String numeric;

        @Override
        DynamicObject toResolvedOptionsObject(JSContext context) {
            DynamicObject result = JSOrdinary.create(context);
            JSObjectUtil.defineDataProperty(result, "locale", this.getLocale(), JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "style", this.style, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "numeric", this.numeric, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "numberingSystem", this.getNumberingSystem(), JSAttributes.getDefault());
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        public void initializeRelativeTimeFormatter() {
            this.relativeDateTimeFormatter = JSRelativeTimeFormat.createFormatter(this.getJavaLocale(), this.style);
        }

        public RelativeDateTimeFormatter getRelativeDateTimeFormatter() {
            return this.relativeDateTimeFormatter;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        public void setNumeric(String numeric) {
            this.numeric = numeric;
        }

        public String getNumeric() {
            return this.numeric;
        }
    }
}

