/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.introduce;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.java.hints.introduce.MemberSearchResult;
import org.netbeans.modules.java.hints.introduce.MemberValidator;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;

final class FieldValidator
implements MemberValidator {
    private final Source theSource;
    private final TypeMirrorHandle fieldTypeHandle;
    private final TreePathHandle srcHandle;
    private String name;
    private ElementHandle<Element> target;
    private MemberSearchResult lastResult;

    public FieldValidator(Source theSource, TypeMirrorHandle fieldTypeHandle, TreePathHandle srcHandle) {
        this.theSource = theSource;
        this.fieldTypeHandle = fieldTypeHandle;
        this.srcHandle = srcHandle;
    }

    MemberSearchResult getLastResult() {
        return this.lastResult;
    }

    @Override
    public synchronized MemberSearchResult validateName(TreePathHandle target, String n) {
        if ((target == target || target.equals((Object)target)) && n.equals(this.name)) {
            return this.lastResult;
        }
        SearchImpl impl = new SearchImpl(target, n);
        try {
            ParserManager.parse(Collections.singleton(this.theSource), (UserTask)impl);
        }
        catch (ParseException ex) {
            return null;
        }
        return this.lastResult;
    }

    private class SearchImpl
    extends UserTask
    implements ElementUtilities.ElementAcceptor {
        private final TreePathHandle targetHandle;
        private final String name;
        private CompilationInfo cinfo;
        private Element target;
        private Scope initialScope;

        public SearchImpl(TreePathHandle targetHandle, String name) {
            this.targetHandle = targetHandle;
            this.name = name;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            CompilationController cc = CompilationController.get((Parser.Result)resultIterator.getParserResult());
            cc.toPhase(JavaSource.Phase.RESOLVED);
            this.cinfo = cc;
            if (this.targetHandle == null || FieldValidator.this.srcHandle == null) {
                return;
            }
            TreePath srcPath = FieldValidator.this.srcHandle.resolve(this.cinfo);
            if (srcPath == null) {
                return;
            }
            TreePath targetPath = this.targetHandle.resolve(this.cinfo);
            if (targetPath == null) {
                return;
            }
            this.initialScope = this.cinfo.getTrees().getScope(srcPath);
            Scope targetScope = this.cinfo.getTrees().getScope(targetPath);
            Map visibleVariables = this.cinfo.getElementUtilities().findElementsAndOrigins(this.initialScope, (ElementUtilities.ElementAcceptor)this);
            FieldValidator.this.lastResult = null;
            Element target = this.cinfo.getTrees().getElement(targetPath);
            block4: for (Element e : visibleVariables.keySet()) {
                switch (e.getKind()) {
                    case FIELD: 
                    case ENUM_CONSTANT: 
                    case PARAMETER: {
                        TypeElement owner;
                        Scope def = (Scope)visibleVariables.get(e);
                        if (def != targetScope) {
                            Scope s = def;
                            while (s.getEnclosingClass() != null) {
                                if (s == target) {
                                    FieldValidator.this.lastResult = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)e));
                                    return;
                                }
                                s = s.getEnclosingScope();
                            }
                        }
                        if ((owner = def.getEnclosingClass()) == null) {
                            FieldValidator.this.lastResult = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)e), (ElementHandle<? extends TypeElement>)ElementHandle.create((Element)((TypeElement)e.getEnclosingElement())));
                            continue block4;
                        }
                        if (owner == e.getEnclosingElement()) {
                            if (owner == target) {
                                FieldValidator.this.lastResult = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)e));
                                return;
                            }
                            FieldValidator.this.lastResult = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)e), (ElementHandle<? extends TypeElement>)ElementHandle.create((Element)owner));
                            continue block4;
                        }
                        FieldValidator.this.lastResult = new MemberSearchResult((ElementHandle<? extends Element>)ElementHandle.create((Element)e), (ElementHandle<? extends TypeElement>)ElementHandle.create((Element)owner), null);
                        continue block4;
                    }
                    case EXCEPTION_PARAMETER: 
                    case LOCAL_VARIABLE: 
                    case RESOURCE_VARIABLE: {
                        TreePath locPath = this.findLocalPathWorkaround(this.cinfo, e, srcPath);
                        if (locPath == null) {
                            FieldValidator.this.lastResult = new MemberSearchResult(e.getKind());
                        } else {
                            FieldValidator.this.lastResult = new MemberSearchResult(TreePathHandle.create((TreePath)locPath, (CompilationInfo)this.cinfo), e.getKind());
                        }
                        return;
                    }
                }
                return;
            }
        }

        private TreePath findLocalPathWorkaround(CompilationInfo cinfo, Element e, TreePath srcPath) {
            TreePath p = cinfo.getTrees().getPath(e);
            if (p != null) {
                return p;
            }
            switch (e.getKind()) {
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: {
                    break;
                }
                default: {
                    return null;
                }
            }
            while (srcPath != null) {
                Tree t = srcPath.getLeaf();
                switch (t.getKind()) {
                    case METHOD: 
                    case CLASS: {
                        return null;
                    }
                    case VARIABLE: {
                        if (!e.getSimpleName().contentEquals(((VariableTree)t).getName())) break;
                        return srcPath;
                    }
                    case BLOCK: {
                        for (Tree tree : ((BlockTree)t).getStatements()) {
                            if (tree.getKind() != Tree.Kind.VARIABLE || !e.getSimpleName().contentEquals(((VariableTree)tree).getName())) continue;
                            return srcPath;
                        }
                        break;
                    }
                    case TRY: {
                        TryTree tt = (TryTree)t;
                        if (tt.getResources() == null) break;
                        for (Tree tree : tt.getResources()) {
                            if (tree.getKind() != Tree.Kind.VARIABLE || !e.getSimpleName().contentEquals(((VariableTree)tree).getName())) continue;
                            return srcPath;
                        }
                        break;
                    }
                    case CATCH: {
                        CatchTree ct = (CatchTree)t;
                        if (ct.getParameter() == null || !ct.getParameter().getName().contentEquals(e.getSimpleName())) break;
                        return srcPath;
                    }
                }
                srcPath = srcPath.getParentPath();
            }
            return null;
        }

        public boolean accept(Element e, TypeMirror type) {
            boolean checkAccessible = false;
            switch (e.getKind()) {
                case FIELD: 
                case ENUM_CONSTANT: {
                    checkAccessible = true;
                    break;
                }
                case PARAMETER: 
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case RESOURCE_VARIABLE: 
                case TYPE_PARAMETER: {
                    break;
                }
                default: {
                    return false;
                }
            }
            if (!e.getSimpleName().contentEquals(this.name)) {
                return false;
            }
            return !checkAccessible || type == null || this.cinfo.getTrees().isAccessible(this.initialScope, e, (DeclaredType)type);
        }
    }
}

