/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatureKey;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.row.Row;
import org.primefaces.context.RequestContext;
import org.primefaces.model.filter.ContainsFilterConstraint;
import org.primefaces.model.filter.EndsWithFilterConstraint;
import org.primefaces.model.filter.EqualsFilterConstraint;
import org.primefaces.model.filter.ExactFilterConstraint;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.GlobalFilterConstraint;
import org.primefaces.model.filter.GreaterThanEqualsFilterConstraint;
import org.primefaces.model.filter.GreaterThanFilterConstraint;
import org.primefaces.model.filter.InFilterConstraint;
import org.primefaces.model.filter.LessThanEqualsFilterConstraint;
import org.primefaces.model.filter.LessThanFilterConstraint;
import org.primefaces.model.filter.StartsWithFilterConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFeature
implements DataTableFeature {
    private static final Logger logger = Logger.getLogger(DataTable.class.getName());
    private static final String STARTS_WITH_MATCH_MODE = "startsWith";
    private static final String ENDS_WITH_MATCH_MODE = "endsWith";
    private static final String CONTAINS_MATCH_MODE = "contains";
    private static final String EXACT_MATCH_MODE = "exact";
    private static final String LESS_THAN_MODE = "lt";
    private static final String LESS_THAN_EQUALS_MODE = "lte";
    private static final String GREATER_THAN_MODE = "gt";
    private static final String GREATER_THAN_EQUALS_MODE = "gte";
    private static final String EQUALS_MODE = "equals";
    private static final String IN_MODE = "in";
    private static final String GLOBAL_MODE = "global";
    static final Map<String, FilterConstraint> FILTER_CONSTRAINTS = new HashMap<String, FilterConstraint>();

    private boolean isFilterRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_filtering");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isFilterRequest(context, table);
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        String globalFilterParam = table.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter";
        List<FilterMeta> filterMetadata = this.populateFilterMetaData(context, table);
        Map<String, Object> filterParameterMap = this.populateFilterParameterMap(context, table, filterMetadata, globalFilterParam);
        table.setFilters(filterParameterMap);
        table.setFilterMetadata(filterMetadata);
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        this.updateFilteredValue(context, table, null);
        table.setFirst(0);
        table.setRowIndex(-1);
        if (table.isLazy()) {
            table.loadLazyData();
        } else {
            boolean sorted;
            String globalFilterParam = table.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter";
            this.filter(context, table, table.getFilterMetadata(), globalFilterParam);
            boolean bl = sorted = table.getValueExpression("sortBy") != null || table.getSortBy() != null;
            if (sorted) {
                SortFeature sortFeature = (SortFeature)table.getFeature(DataTableFeatureKey.SORT);
                if (table.isMultiSort()) {
                    sortFeature.multiSort(context, table);
                } else {
                    sortFeature.singleSort(context, table);
                }
            }
        }
        renderer.encodeTbody(context, table, true);
    }

    private void filter(FacesContext context, DataTable table, List<FilterMeta> filterMetadata, String globalFilterParam) {
        RequestContext requestContext;
        Map params = context.getExternalContext().getRequestParameterMap();
        ArrayList<Object> filteredData = new ArrayList<Object>();
        Locale filterLocale = table.resolveDataLocale();
        boolean hasGlobalFilter = params.containsKey(globalFilterParam);
        String globalFilterValue = hasGlobalFilter ? (String)params.get(globalFilterParam) : null;
        GlobalFilterConstraint globalFilterConstraint = (GlobalFilterConstraint)FILTER_CONSTRAINTS.get(GLOBAL_MODE);
        ELContext elContext = context.getELContext();
        for (int i = 0; i < table.getRowCount(); ++i) {
            table.setRowIndex(i);
            boolean localMatch = true;
            boolean globalMatch = false;
            for (FilterMeta filterMeta : filterMetadata) {
                Object filterValue = filterMeta.getFilterValue();
                UIColumn column = filterMeta.getColumn();
                MethodExpression filterFunction = column.getFilterFunction();
                ValueExpression filterByVE = filterMeta.getFilterByVE();
                if (column instanceof DynamicColumn) {
                    ((DynamicColumn)column).applyStatelessModel();
                }
                Object columnValue = filterByVE.getValue(elContext);
                FilterConstraint filterConstraint = this.getFilterConstraint(column);
                if (hasGlobalFilter && !globalMatch) {
                    globalMatch = globalFilterConstraint.applies(columnValue, globalFilterValue, filterLocale);
                }
                if (filterFunction != null) {
                    localMatch = (Boolean)filterFunction.invoke(elContext, new Object[]{columnValue, filterValue, filterLocale});
                } else if (!filterConstraint.applies(columnValue, filterValue, filterLocale)) {
                    localMatch = false;
                }
                if (localMatch) continue;
                break;
            }
            boolean matches = localMatch;
            if (hasGlobalFilter) {
                boolean bl = matches = localMatch && globalMatch;
            }
            if (!matches) continue;
            filteredData.add(table.getRowData());
        }
        if (table.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
            requestContext.addCallbackParam("totalRecords", filteredData.size());
        }
        this.updateFilteredValue(context, table, filteredData);
        table.setRowIndex(-1);
    }

    public void updateFilteredValue(FacesContext context, DataTable table, List<?> value) {
        table.setSelectableDataModelWrapper(null);
        ValueExpression ve = table.getValueExpression("filteredValue");
        if (ve != null) {
            ve.setValue(context.getELContext(), value);
        } else {
            if (value != null) {
                logger.log(Level.WARNING, "DataTable {0} has filtering enabled but no filteredValue model reference is defined, for backward compatibility falling back to page viewstate method to keep filteredValue. It is highly suggested to use filtering with a filteredValue model reference as viewstate method is deprecated and will be removed in future.", new Object[]{table.getClientId(context)});
            }
            table.setFilteredValue(value);
        }
    }

    private Map<String, Object> populateFilterParameterMap(FacesContext context, DataTable table, List<FilterMeta> filterMetadata, String globalFilterParam) {
        Map params = context.getExternalContext().getRequestParameterMap();
        HashMap<String, Object> filterParameterMap = new HashMap<String, Object>();
        for (FilterMeta filterMeta : filterMetadata) {
            Object filterValue = filterMeta.getFilterValue();
            UIColumn column = filterMeta.getColumn();
            if (filterValue == null || filterValue.toString().trim().equals("")) continue;
            String filterField = null;
            ValueExpression filterByVE = column.getValueExpression("filterBy");
            if (column.isDynamic()) {
                ((DynamicColumn)column).applyStatelessModel();
                Object filterByProperty = column.getFilterBy();
                String field = column.getField();
                filterField = field == null ? (filterByProperty == null ? table.resolveDynamicField(filterByVE) : filterByProperty.toString()) : field;
            } else {
                String field = column.getField();
                filterField = field == null ? (filterByVE == null ? (String)column.getFilterBy() : table.resolveStaticField(filterByVE)) : field;
            }
            filterParameterMap.put(filterField, filterValue);
        }
        if (params.containsKey(globalFilterParam)) {
            filterParameterMap.put("globalFilter", params.get(globalFilterParam));
        }
        return filterParameterMap;
    }

    private List<FilterMeta> populateFilterMetaData(FacesContext context, DataTable table) {
        ArrayList<FilterMeta> filterMetadata = new ArrayList<FilterMeta>();
        String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
        String var = table.getVar();
        Map params = context.getExternalContext().getRequestParameterMap();
        ColumnGroup group = this.getColumnGroup(table, "header");
        if (group != null) {
            for (UIComponent child : group.getChildren()) {
                Row headerRow = (Row)child;
                if (!headerRow.isRendered()) continue;
                for (UIComponent headerRowChild : headerRow.getChildren()) {
                    Column column = (Column)headerRowChild;
                    if (!column.isRendered()) continue;
                    ValueExpression columnFilterByVE = column.getValueExpression("filterBy");
                    Object filterByProperty = column.getFilterBy();
                    if (columnFilterByVE == null && filterByProperty == null) continue;
                    ValueExpression filterByVE = columnFilterByVE != null ? columnFilterByVE : this.createFilterByVE(context, var, filterByProperty);
                    UIComponent filterFacet = column.getFacet("filter");
                    Object filterValue = filterFacet == null ? params.get(column.getClientId(context) + separator + "filter") : ((ValueHolder)filterFacet).getLocalValue();
                    filterMetadata.add(new FilterMeta(column, filterByVE, filterValue));
                }
            }
        } else {
            for (UIColumn column : table.getColumns()) {
                ValueExpression columnFilterByVE = column.getValueExpression("filterBy");
                Object filterByProperty = column.getFilterBy();
                if (columnFilterByVE == null && filterByProperty == null) continue;
                UIComponent filterFacet = column.getFacet("filter");
                Object filterValue = null;
                ValueExpression filterByVE = null;
                String filterId = null;
                if (column instanceof Column) {
                    filterByVE = columnFilterByVE != null ? columnFilterByVE : this.createFilterByVE(context, var, filterByProperty);
                    filterId = column.getClientId(context) + separator + "filter";
                } else if (column instanceof DynamicColumn) {
                    DynamicColumn dynamicColumn = (DynamicColumn)column;
                    dynamicColumn.applyStatelessModel();
                    filterByProperty = column.getFilterBy();
                    filterByVE = filterByProperty == null ? columnFilterByVE : this.createFilterByVE(context, var, filterByProperty);
                    filterId = dynamicColumn.getContainerClientId(context) + separator + "filter";
                    dynamicColumn.cleanStatelessModel();
                }
                filterValue = filterFacet == null ? (Object)params.get(filterId) : ((ValueHolder)filterFacet).getLocalValue();
                filterMetadata.add(new FilterMeta(column, filterByVE, filterValue));
            }
        }
        return filterMetadata;
    }

    private ColumnGroup getColumnGroup(DataTable table, String target) {
        for (UIComponent child : table.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public FilterConstraint getFilterConstraint(UIColumn column) {
        String filterMatchMode = column.getFilterMatchMode();
        FilterConstraint filterConstraint = FILTER_CONSTRAINTS.get(filterMatchMode);
        if (filterConstraint == null) {
            throw new FacesException("Illegal filter match mode:" + filterMatchMode);
        }
        return filterConstraint;
    }

    private ValueExpression createFilterByVE(FacesContext context, String var, Object filterBy) {
        ELContext elContext = context.getELContext();
        return context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + var + "." + filterBy + "}", Object.class);
    }

    static {
        FILTER_CONSTRAINTS.put(STARTS_WITH_MATCH_MODE, new StartsWithFilterConstraint());
        FILTER_CONSTRAINTS.put(ENDS_WITH_MATCH_MODE, new EndsWithFilterConstraint());
        FILTER_CONSTRAINTS.put(CONTAINS_MATCH_MODE, new ContainsFilterConstraint());
        FILTER_CONSTRAINTS.put(EXACT_MATCH_MODE, new ExactFilterConstraint());
        FILTER_CONSTRAINTS.put(LESS_THAN_MODE, new LessThanFilterConstraint());
        FILTER_CONSTRAINTS.put(LESS_THAN_EQUALS_MODE, new LessThanEqualsFilterConstraint());
        FILTER_CONSTRAINTS.put(GREATER_THAN_MODE, new GreaterThanFilterConstraint());
        FILTER_CONSTRAINTS.put(GREATER_THAN_EQUALS_MODE, new GreaterThanEqualsFilterConstraint());
        FILTER_CONSTRAINTS.put(EQUALS_MODE, new EqualsFilterConstraint());
        FILTER_CONSTRAINTS.put(IN_MODE, new InFilterConstraint());
        FILTER_CONSTRAINTS.put(GLOBAL_MODE, new GlobalFilterConstraint());
    }

    private class FilterMeta {
        private UIColumn column;
        private ValueExpression filterByVE;
        private Object filterValue;

        public FilterMeta(UIColumn column, ValueExpression filterByVE, Object filterValue) {
            this.column = column;
            this.filterByVE = filterByVE;
            this.filterValue = filterValue;
        }

        public UIColumn getColumn() {
            return this.column;
        }

        public ValueExpression getFilterByVE() {
            return this.filterByVE;
        }

        public Object getFilterValue() {
            return this.filterValue;
        }
    }
}

