/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class JaxRsFilterVisual
extends JPanel {
    private static final long serialVersionUID = -3816981483676324257L;
    private JCheckBox clientFilter;
    private JCheckBox containerFilter;
    private JPanel filterPanel;
    private JLabel filterTypeLbl;
    private JCheckBox preMatching;
    private JCheckBox provider;
    private JCheckBox requestFilter;
    private JCheckBox responseFilter;
    private List<ChangeListener> listeners;

    JaxRsFilterVisual(WizardDescriptor descriptor) {
        this.initComponents();
        this.listeners = new CopyOnWriteArrayList<ChangeListener>();
        Project project = Templates.getProject((WizardDescriptor)descriptor);
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule == null) {
            this.containerFilter.setSelected(false);
            this.provider.setVisible(false);
            this.preMatching.setVisible(false);
        } else {
            this.containerFilter.setSelected(true);
            this.provider.setSelected(true);
        }
        this.requestFilter.setSelected(true);
        this.responseFilter.setSelected(true);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JaxRsFilterVisual.this.fireChangeEvent();
            }
        };
        this.containerFilter.addActionListener(listener);
        this.clientFilter.addActionListener(listener);
        this.requestFilter.addActionListener(listener);
        this.responseFilter.addActionListener(listener);
        this.provider.addActionListener(listener);
    }

    String getError() {
        if (this.clientFilter.isSelected() && !this.containerFilter.isSelected() && this.provider.isSelected()) {
            return NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ERR_ClientProvider");
        }
        if (!this.clientFilter.isSelected() && !this.containerFilter.isSelected()) {
            return NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ERR_NoFilterRoleType");
        }
        if (!this.requestFilter.isSelected() && !this.responseFilter.isSelected()) {
            return NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ERR_NoFilterType");
        }
        return null;
    }

    void readSettings(WizardDescriptor descriptor) {
    }

    void storeSettings(WizardDescriptor descriptor) {
        descriptor.putProperty("client.filter", (Object)this.clientFilter.isSelected());
        descriptor.putProperty("server.filter", (Object)this.containerFilter.isSelected());
        descriptor.putProperty("request.filter", (Object)this.requestFilter.isSelected());
        descriptor.putProperty("response.filter", (Object)this.responseFilter.isSelected());
        descriptor.putProperty("prematching.filter", (Object)this.preMatching.isSelected());
        descriptor.putProperty("provider.filter", (Object)this.provider.isSelected());
    }

    void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void initComponents() {
        this.filterTypeLbl = new JLabel();
        this.filterPanel = new JPanel();
        this.requestFilter = new JCheckBox();
        this.responseFilter = new JCheckBox();
        this.clientFilter = new JCheckBox();
        this.containerFilter = new JCheckBox();
        this.provider = new JCheckBox();
        this.preMatching = new JCheckBox();
        this.filterTypeLbl.setLabelFor(this.filterPanel);
        Mnemonics.setLocalizedText((JLabel)this.filterTypeLbl, (String)NbBundle.getMessage(JaxRsFilterVisual.class, (String)"LBL_FilterType"));
        this.filterPanel.setBorder(BorderFactory.createEtchedBorder());
        Mnemonics.setLocalizedText((AbstractButton)this.requestFilter, (String)NbBundle.getMessage(JaxRsFilterVisual.class, (String)"LBL_RequestFilter"));
        Mnemonics.setLocalizedText((AbstractButton)this.responseFilter, (String)NbBundle.getMessage(JaxRsFilterVisual.class, (String)"LBL_ResponseFilter"));
        Mnemonics.setLocalizedText((AbstractButton)this.clientFilter, (String)NbBundle.getMessage(JaxRsFilterVisual.class, (String)"LBL_ClientFilter"));
        Mnemonics.setLocalizedText((AbstractButton)this.containerFilter, (String)NbBundle.getMessage(JaxRsFilterVisual.class, (String)"LBL_ContainerFilter"));
        GroupLayout filterPanelLayout = new GroupLayout(this.filterPanel);
        this.filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.requestFilter).addComponent(this.responseFilter)).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addGap(143, 143, 143).addComponent(this.clientFilter, -2, 141, -2)).addGroup(GroupLayout.Alignment.TRAILING, filterPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.containerFilter, -2, 141, -2))).addContainerGap()));
        filterPanelLayout.setVerticalGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(filterPanelLayout.createSequentialGroup().addContainerGap().addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.requestFilter).addComponent(this.containerFilter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(filterPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.responseFilter).addComponent(this.clientFilter)).addContainerGap(-1, Short.MAX_VALUE)));
        this.requestFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSN_RequestFilter"));
        this.requestFilter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSD_RequestFilter"));
        this.responseFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSN_ResponseFilter"));
        this.responseFilter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSD_ResponseFilter"));
        this.clientFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSN_ClientFilter"));
        this.clientFilter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSD_ClientFilter"));
        this.containerFilter.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSN_ContainerFilter"));
        this.containerFilter.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSD_ContainerFilter"));
        Mnemonics.setLocalizedText((AbstractButton)this.provider, (String)NbBundle.getMessage(JaxRsFilterVisual.class, (String)"LBL_Provider"));
        Mnemonics.setLocalizedText((AbstractButton)this.preMatching, (String)NbBundle.getMessage(JaxRsFilterVisual.class, (String)"LBL_PreMatching"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.filterPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.preMatching).addComponent(this.provider).addComponent(this.filterTypeLbl)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.filterTypeLbl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.provider).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preMatching).addContainerGap(-1, Short.MAX_VALUE)));
        this.filterTypeLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSN_FilterType"));
        this.filterTypeLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSD_FilterType"));
        this.filterPanel.getAccessibleContext().setAccessibleName(this.filterTypeLbl.getAccessibleContext().getAccessibleName());
        this.filterPanel.getAccessibleContext().setAccessibleDescription(this.filterTypeLbl.getAccessibleContext().getAccessibleDescription());
        this.provider.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSN_Provider"));
        this.provider.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSD_Provider"));
        this.preMatching.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSN_PreMatching"));
        this.preMatching.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxRsFilterVisual.class, (String)"ACSD_PreMatching"));
    }
}

