/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.openide.filesystems.FileUtil;

public final class RepositoryUtil {
    private RepositoryUtil() {
    }

    @NonNull
    public static Artifact createArtifact(@NonNull NBVersionInfo info) {
        return RepositoryUtil.createArtifact(info, null);
    }

    @NonNull
    public static Artifact createJavadocArtifact(@NonNull NBVersionInfo info) {
        return RepositoryUtil.createArtifact(info, "javadoc");
    }

    @NonNull
    private static Artifact createArtifact(@NonNull NBVersionInfo info, @NullAllowed String classifier) {
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        Artifact art = info.getClassifier() != null || classifier != null ? online.createArtifactWithClassifier(info.getGroupId(), info.getArtifactId(), info.getVersion(), info.getType() != null ? info.getType() : "jar", classifier == null ? info.getClassifier() : classifier) : online.createArtifact(info.getGroupId(), info.getArtifactId(), info.getVersion(), null, info.getType() != null ? info.getType() : "jar");
        ArtifactRepository repo = online.getLocalRepository();
        String localPath = repo.pathOf(art);
        art.setFile(FileUtil.normalizeFile((File)new File(online.getLocalRepositoryFile(), localPath)));
        return art;
    }

    public static File downloadArtifact(NBVersionInfo info) throws Exception {
        Artifact a = RepositoryUtil.createArtifact(info);
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        RepositoryInfo repo = RepositoryPreferences.getInstance().getRepositoryInfoById(info.getRepoId());
        List<ArtifactRepository> remotes = repo != null && repo.isRemoteDownloadable() ? List.of(online.createRemoteRepository(repo.getRepositoryUrl(), repo.getId())) : List.of(online.createRemoteRepository("https://repo.maven.apache.org/maven2", "central"));
        online.resolve(a, remotes, online.getLocalRepository());
        return a.getFile();
    }

    public static String calculateSHA1Checksum(File file) throws IOException {
        MessageDigest digest;
        if (!file.exists() || !file.isFile()) {
            throw new IOException("file '" + file + "' does not exist or is not a valid file");
        }
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException x) {
            throw new IOException(x);
        }
        digest.update(Files.readAllBytes(file.toPath()));
        return String.format("%040x", new BigInteger(1, digest.digest()));
    }
}

