/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ApproveDeploymentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="deployStageId")
    private final String deployStageId;
    @JsonProperty(value="reason")
    private final String reason;
    @JsonProperty(value="action")
    private final Action action;

    @Deprecated
    @ConstructorProperties(value={"deployStageId", "reason", "action"})
    public ApproveDeploymentDetails(String deployStageId, String reason, Action action) {
        this.deployStageId = deployStageId;
        this.reason = reason;
        this.action = action;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDeployStageId() {
        return this.deployStageId;
    }

    public String getReason() {
        return this.reason;
    }

    public Action getAction() {
        return this.action;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApproveDeploymentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("deployStageId=").append(String.valueOf(this.deployStageId));
        sb.append(", reason=").append(String.valueOf(this.reason));
        sb.append(", action=").append(String.valueOf((Object)this.action));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApproveDeploymentDetails)) {
            return false;
        }
        ApproveDeploymentDetails other = (ApproveDeploymentDetails)((Object)o);
        return Objects.equals(this.deployStageId, other.deployStageId) && Objects.equals(this.reason, other.reason) && Objects.equals((Object)this.action, (Object)other.action) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.deployStageId == null ? 43 : this.deployStageId.hashCode());
        result = result * 59 + (this.reason == null ? 43 : this.reason.hashCode());
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        Approve("APPROVE"),
        Reject("REJECT");

        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Action: " + key);
        }

        static {
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="deployStageId")
        private String deployStageId;
        @JsonProperty(value="reason")
        private String reason;
        @JsonProperty(value="action")
        private Action action;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder deployStageId(String deployStageId) {
            this.deployStageId = deployStageId;
            this.__explicitlySet__.add("deployStageId");
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            this.__explicitlySet__.add("reason");
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public ApproveDeploymentDetails build() {
            ApproveDeploymentDetails model = new ApproveDeploymentDetails(this.deployStageId, this.reason, this.action);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApproveDeploymentDetails model) {
            if (model.wasPropertyExplicitlySet("deployStageId")) {
                this.deployStageId(model.getDeployStageId());
            }
            if (model.wasPropertyExplicitlySet("reason")) {
                this.reason(model.getReason());
            }
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            return this;
        }
    }
}

