/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.modules.web.project.classpath.JspSourcePathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private final AntProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final Map<ClassPathCache, ClassPath> cache = new HashMap<ClassPathCache, ClassPath>();
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();
    private org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl javaClassPathProvider;

    public ClassPathProviderImpl(AntProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots) {
        this.helper = helper;
        this.projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = testSourceRoots;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        this.javaClassPathProvider = new org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl(helper, evaluator, sourceRoots, testSourceRoots, "build.classes.dir", "dist.war", "build.test.classes.dir", new String[]{"javac.classpath", "j2ee.platform.classpath"}, new String[]{"javac.processorpath"}, new String[]{"javac.test.classpath", "j2ee.platform.classpath"}, new String[]{"debug.classpath", "j2ee.platform.classpath"}, new String[]{"run.test.classpath", "j2ee.platform.classpath"}, new String[]{"endorsed.classpath"});
    }

    private FileObject getDir(final String propname) {
        return (FileObject)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileObject run() {
                ClassPathProviderImpl classPathProviderImpl = ClassPathProviderImpl.this;
                synchronized (classPathProviderImpl) {
                    String prop;
                    FileObject fo = (FileObject)ClassPathProviderImpl.this.dirCache.get(propname);
                    if (!(fo != null && fo.isValid() || (prop = ClassPathProviderImpl.this.evaluator.getProperty(propname)) == null)) {
                        fo = ClassPathProviderImpl.this.helper.resolveFileObject(prop);
                        ClassPathProviderImpl.this.dirCache.put(propname, fo);
                    }
                    return fo;
                }
            }
        });
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private FileObject getBuildClassesDir() {
        return this.getDir("build.classes.dir");
    }

    private FileObject getDocumentBaseDir() {
        return this.getDir("web.docbase.dir");
    }

    private FileType getType(FileObject file) {
        FileObject[] srcPath = this.getPrimarySrcPath();
        for (int i = 0; i < srcPath.length; ++i) {
            FileObject root = srcPath[i];
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return FileType.SOURCE;
        }
        FileObject dir = this.getDocumentBaseDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return FileType.WEB_SOURCE;
        }
        dir = this.getBuildClassesDir();
        if (dir != null && (dir.equals(file) || FileUtil.isParentOf((FileObject)dir, (FileObject)file))) {
            return FileType.CLASS;
        }
        return FileType.UNKNOWN;
    }

    private synchronized ClassPath getCompileTimeClasspath(FileType type) {
        if (type == FileType.WEB_SOURCE) {
            if (this.sourceRoots.getRoots().length > 0) {
                return this.javaClassPathProvider.findClassPath(this.sourceRoots.getRoots()[0], "classpath/compile");
            }
            ClassPath cp = this.cache.get((Object)ClassPathCache.WEB_COMPILATION);
            if (cp == null) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"javac.classpath", "j2ee.platform.classpath"}));
                this.cache.put(ClassPathCache.WEB_COMPILATION, cp);
            }
            return cp;
        }
        return null;
    }

    private synchronized ClassPath getRunTimeClasspath(FileType type) {
        if (type == FileType.WEB_SOURCE) {
            if (this.sourceRoots.getRoots().length > 0) {
                return this.javaClassPathProvider.findClassPath(this.sourceRoots.getRoots()[0], "classpath/execute");
            }
            ClassPath cp = this.cache.get((Object)ClassPathCache.WEB_RUNTIME);
            if (cp == null) {
                cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)this.projectDirectory, (PropertyEvaluator)this.evaluator, (String[])new String[]{"debug.classpath", "j2ee.platform.classpath"}));
                this.cache.put(ClassPathCache.WEB_RUNTIME, cp);
            }
            return cp;
        }
        return null;
    }

    private synchronized ClassPath getSourcepath(FileType type) {
        if (type == FileType.WEB_SOURCE) {
            ClassPath cp = this.cache.get((Object)ClassPathCache.WEB_SOURCE);
            if (cp == null) {
                cp = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{ClassPathFactory.createClassPath((ClassPathImplementation)new JspSourcePathImplementation(this.helper, this.evaluator)), ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createSourcePathImplementation((SourceRoots)this.sourceRoots, (AntProjectHelper)this.helper, (PropertyEvaluator)this.evaluator))});
                this.cache.put(ClassPathCache.WEB_SOURCE, cp);
            }
            return cp;
        }
        return null;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        ClassPath cp = this.javaClassPathProvider.findClassPath(file, type);
        if (cp != null) {
            return cp;
        }
        FileType fileType = this.getType(file);
        if (type.equals("classpath/compile")) {
            cp = this.getCompileTimeClasspath(fileType);
        } else if (type.equals("classpath/execute")) {
            cp = this.getRunTimeClasspath(fileType);
        } else if (type.equals("classpath/source")) {
            cp = this.getSourcepath(fileType);
        } else if (type.equals("js/library")) {
            cp = this.getSourcepath(FileType.WEB_SOURCE);
        }
        return cp;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        if ("classpath/source".equals(type)) {
            ClassPath[] base = this.javaClassPathProvider.getProjectClassPaths(type);
            ClassPath[] l = new ClassPath[base.length + 1];
            System.arraycopy(base, 0, l, 0, base.length);
            l[l.length - 1] = this.getSourcepath(FileType.WEB_SOURCE);
            return l;
        }
        return this.javaClassPathProvider.getProjectClassPaths(type);
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        return this.javaClassPathProvider.getProjectSourcesClassPath(type);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.dirCache.remove(evt.getPropertyName());
    }

    public String[] getPropertyName(SourceGroup sg, String type) {
        return this.javaClassPathProvider.getPropertyName(sg, type);
    }

    private static enum ClassPathCache {
        WEB_SOURCE,
        WEB_COMPILATION,
        WEB_RUNTIME;

    }

    private static enum FileType {
        SOURCE,
        CLASS,
        WEB_SOURCE,
        UNKNOWN;

    }
}

