/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui.api;

import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.ui.ResultDisplayHandler;
import org.openide.util.Lookup;

public abstract class TestResultDisplayHandler {
    public static final TestResultDisplayHandler create(TestSession session) {
        Spi<?> provider = (Spi<?>)Lookup.getDefault().lookup(Spi.class);
        if (provider == null) {
            provider = ResultDisplayHandler.getProvider();
        }
        return new Impl(provider.create(session), provider);
    }

    private TestResultDisplayHandler() {
    }

    public abstract void displayOutput(String var1, boolean var2);

    public abstract void displaySuiteRunning(String var1);

    public abstract void displaySuiteRunning(TestSuite var1);

    public abstract void displayReport(Report var1);

    public abstract void displayMessage(String var1);

    public abstract void displayMessageSessionFinished(String var1);

    public abstract int getTotalTests();

    abstract Object getToken();

    private static final class Impl<T>
    extends TestResultDisplayHandler {
        private final T token;
        private final Spi<T> spi;

        private Impl(T token, Spi<T> spi) {
            this.token = token;
            this.spi = spi;
        }

        @Override
        public void displayOutput(String text, boolean error) {
            this.spi.displayOutput(this.token, text, error);
        }

        @Override
        public void displaySuiteRunning(String suiteName) {
            this.spi.displaySuiteRunning(this.token, suiteName);
        }

        @Override
        public void displaySuiteRunning(TestSuite suite) {
            this.spi.displaySuiteRunning(this.token, suite);
        }

        @Override
        public void displayReport(Report report) {
            this.spi.displayReport(this.token, report);
        }

        @Override
        public void displayMessage(String message) {
            this.spi.displayMessage(this.token, message);
        }

        @Override
        public void displayMessageSessionFinished(String message) {
            this.spi.displayMessageSessionFinished(this.token, message);
        }

        @Override
        public int getTotalTests() {
            return this.spi.getTotalTests(this.token);
        }

        T getToken() {
            return this.token;
        }
    }

    public static interface Spi<T> {
        public T create(TestSession var1);

        public void displayOutput(T var1, String var2, boolean var3);

        public void displaySuiteRunning(T var1, String var2);

        public void displaySuiteRunning(T var1, TestSuite var2);

        public void displayReport(T var1, Report var2);

        public void displayMessage(T var1, String var2);

        public void displayMessageSessionFinished(T var1, String var2);

        public int getTotalTests(T var1);
    }
}

