/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Color;
import java.awt.Font;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JTable;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.MultiRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class NormalBoldGrayRenderer
extends MultiRenderer {
    private static final Color REPLACEABLE_FOREGROUND = new JTable().getForeground();
    private final LabelRenderer normalRenderer;
    private final LabelRenderer boldRenderer;
    private final LabelRenderer grayRenderer;
    private final ProfilerRenderer[] renderers;
    private Color customForeground;
    private Color replaceableForeground = REPLACEABLE_FOREGROUND;

    public NormalBoldGrayRenderer() {
        this.normalRenderer = new LabelRenderer(true){

            @Override
            public void setForeground(Color foreground) {
                if (NormalBoldGrayRenderer.this.customForeground != null && Objects.equals(foreground, NormalBoldGrayRenderer.this.replaceableForeground)) {
                    foreground = NormalBoldGrayRenderer.this.customForeground;
                }
                super.setForeground(foreground);
            }
        };
        this.normalRenderer.setMargin(3, 3, 3, 0);
        this.boldRenderer = new LabelRenderer(true){

            @Override
            public void setForeground(Color foreground) {
                if (NormalBoldGrayRenderer.this.customForeground != null && Objects.equals(foreground, NormalBoldGrayRenderer.this.replaceableForeground)) {
                    foreground = NormalBoldGrayRenderer.this.customForeground;
                }
                super.setForeground(foreground);
            }
        };
        this.boldRenderer.setMargin(3, 0, 3, 0);
        Font font = this.boldRenderer.getFont();
        this.boldRenderer.setFont(font.deriveFont(1));
        this.grayRenderer = new LabelRenderer(true){

            @Override
            public void setForeground(Color foreground) {
                if (Objects.equals(foreground, NormalBoldGrayRenderer.this.replaceableForeground)) {
                    if (NormalBoldGrayRenderer.this.customForeground != null) {
                        super.setForeground(NormalBoldGrayRenderer.this.customForeground);
                    } else {
                        super.setForeground(UIUtils.getDisabledForeground(foreground == null ? Color.BLACK : foreground));
                    }
                } else {
                    super.setForeground(foreground);
                }
            }
        };
        this.grayRenderer.setMargin(3, 0, 3, 3);
        this.renderers = new ProfilerRenderer[]{this.normalRenderer, this.boldRenderer, this.grayRenderer};
        this.setOpaque(true);
        this.setHorizontalAlignment(10);
    }

    protected void setCustomForeground(Color foreground) {
        this.customForeground = foreground;
    }

    public void setReplaceableForeground(Color foreground) {
        this.replaceableForeground = foreground;
    }

    @Override
    protected ProfilerRenderer[] valueRenderers() {
        return this.renderers;
    }

    protected void setNormalValue(String value) {
        this.normalRenderer.setText(value);
    }

    protected final String getNormalValue() {
        return this.normalRenderer.getText();
    }

    protected void setBoldValue(String value) {
        this.boldRenderer.setText(value);
    }

    protected final String getBoldValue() {
        return this.boldRenderer.getText();
    }

    protected void setGrayValue(String value) {
        this.grayRenderer.setText(value);
    }

    protected final String getGrayValue() {
        return this.grayRenderer.getText();
    }

    protected void setIcon(Icon icon) {
        String text = this.normalRenderer.getText();
        if (text == null || text.isEmpty()) {
            this.normalRenderer.setIcon(null);
            text = this.boldRenderer.getText();
            if (text == null || text.isEmpty()) {
                this.boldRenderer.setIcon(null);
                this.grayRenderer.setIcon(icon);
            } else {
                this.boldRenderer.setIcon(icon);
                this.grayRenderer.setIcon(null);
            }
        } else {
            this.normalRenderer.setIcon(icon);
            this.boldRenderer.setIcon(null);
            this.grayRenderer.setIcon(null);
        }
    }

    public Icon getIcon() {
        Icon icon = this.normalRenderer.getIcon();
        if (icon == null) {
            icon = this.boldRenderer.getIcon();
        }
        if (icon == null) {
            icon = this.grayRenderer.getIcon();
        }
        return icon;
    }

    protected void setIconTextGap(int gap) {
        String text = this.normalRenderer.getText();
        if (text == null || text.isEmpty()) {
            text = this.boldRenderer.getText();
            if (text == null || text.isEmpty()) {
                this.grayRenderer.setIconTextGap(gap);
            } else {
                this.boldRenderer.setIconTextGap(gap);
            }
        } else {
            this.normalRenderer.setIconTextGap(gap);
        }
    }
}

