/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.ClasspathUtil;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentCustomizer;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentImplementation;
import org.netbeans.modules.web.jsf.spi.components.JsfComponentProvider;
import org.netbeans.modules.web.jsf.wizards.Bundle;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationPanel;
import org.netbeans.modules.web.jsf.wizards.JSFConfigurationWizardPanelVisual;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class JSFConfigurationPanelVisual
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private static final RequestProcessor RP = new RequestProcessor(JSFConfigurationPanelVisual.class);
    private static final Logger LOG = Logger.getLogger(JSFConfigurationPanelVisual.class.getName());
    private static final String JSF_SERVLET_NAME = "Faces Servlet";
    private String jsfServletName = null;
    private JSFConfigurationPanel panel;
    private boolean isFrameworkAddition;
    private boolean inCustomizer;
    private final List<LibraryItem> jsfLibraries = new ArrayList<LibraryItem>();
    private final Map<JSFVersion, List<JsfComponentImplementation>> componentsMap = new HashMap<JSFVersion, List<JsfComponentImplementation>>();
    private JSFVersion currentJSFVersion = null;
    private final Set<ServerLibraryItem> serverJsfLibraries = new TreeSet<ServerLibraryItem>();
    private volatile boolean libsInitialized;
    private volatile boolean jsfComponentsInitialized;
    private String serverInstanceID;
    private final List<JSFConfigurationPanel.PreferredLanguage> preferredLanguages = new ArrayList<JSFConfigurationPanel.PreferredLanguage>();
    private String currentServerInstanceID;
    private JSFComponentsTableModel jsfComponentsTableModel;
    private TreeMap<String, JsfComponentCustomizer> jsfComponentCustomizers = new TreeMap();
    private static final Collection<? extends JsfComponentProvider> jsfComponentProviders = new ArrayList<JsfComponentProvider>(Lookups.forPath((String)"j2ee/jsf/components").lookupResult(JsfComponentProvider.class).allInstances());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final Set<String> EXCLUDE_FROM_REGISTERED_LIBS = new HashSet<String>(Arrays.asList("jsp-compilation", "jsp-compilation-syscp"));
    private static volatile boolean jsfLibrariesCacheDirty = true;
    private static final List<Library> JSF_LIBRARIES_CACHE = new CopyOnWriteArrayList<Library>();
    private static final Map<Boolean, String> JSF_SEEKING_MAP = new LinkedHashMap<Boolean, String>(2);
    private ButtonGroup buttonGroup1;
    private JComboBox cbLibraries;
    private JCheckBox cbPackageJars;
    private JComboBox cbPreferredLang;
    private JPanel componentsPanel;
    private JPanel confPanel;
    private JTextField customBundleTextField;
    private JLabel jLabel1;
    private JButton jbBrowse;
    private JLabel jsfComponentsLabel;
    private JScrollPane jsfComponentsScrollPane;
    private JTable jsfComponentsTable;
    private JTabbedPane jsfTabbedPane;
    private JTextField jtNewLibraryName;
    private JLabel lDirectory;
    private JLabel lURLPattern;
    private JLabel lVersion;
    private JPanel libPanel;
    private JRadioButton rbNewLibrary;
    private JRadioButton rbRegisteredLibrary;
    private JRadioButton rbServerLibrary;
    private JComboBox serverLibraries;
    private JTextField tURLPattern;
    private static final char[] INVALID_PATTERN_CHARS;
    private static final Pattern VALID_PROPERTY_NAME;

    public JSFConfigurationPanelVisual(JSFConfigurationPanel panel, boolean isFrameworkAddition, boolean inCustomizer) {
        this.panel = panel;
        this.isFrameworkAddition = isFrameworkAddition;
        this.inCustomizer = inCustomizer;
        this.jsfComponentsTableModel = new JSFComponentsTableModel();
        this.initComponents();
        this.tURLPattern.getDocument().addDocumentListener(this);
        this.cbPackageJars.setVisible(false);
        this.jsfComponentsTable.setModel(this.jsfComponentsTableModel);
        JsfComponentsTableCellRenderer renderer = new JsfComponentsTableCellRenderer();
        renderer.setBooleanRenderer(this.jsfComponentsTable.getDefaultRenderer(Boolean.class));
        renderer.setJButtonRenderer(new JTableButtonRenderer());
        this.jsfComponentsTable.setDefaultRenderer(JsfComponentImplementation.class, renderer);
        this.jsfComponentsTable.setDefaultRenderer(Boolean.class, renderer);
        this.jsfComponentsTable.setDefaultRenderer(JButton.class, renderer);
        this.jsfComponentsTable.addMouseListener(new JsfComponentsMouseListener());
        this.jsfComponentsTableModel.addTableModelListener(new JsfComponentsTableModelListener());
        this.initJsfComponentTableVisualProperties(this.jsfComponentsTable);
        panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSFConfigurationPanelVisual.this.changeSupport.fireChange();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initLibraries();
        this.initJsfComponentsLibraries();
        if (!this.isFrameworkAddition) {
            this.preselectJsfLibrary();
            this.enableComponents(false);
        } else {
            this.updateLibrary();
        }
    }

    private void preselectJsfLibrary() {
        Runnable jsfLibararyUiSwitcher = new Runnable(){

            @Override
            public void run() {
                Project project = FileOwnerQuery.getOwner((FileObject)JSFConfigurationPanelVisual.this.panel.getWebModule().getDocumentBase());
                ClassPathProvider cpp = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
                ClassPath compileClassPath = cpp.findClassPath(JSFConfigurationPanelVisual.this.panel.getWebModule().getDocumentBase(), "classpath/compile");
                if (compileClassPath != null) {
                    for (ClassPath.Entry entry : compileClassPath.entries()) {
                        for (final LibraryItem jsfLibrary : JSFConfigurationPanelVisual.this.jsfLibraries) {
                            try {
                                List cps = jsfLibrary.getLibrary().getURIContent("classpath");
                                for (URI uri : cps) {
                                    if (entry.getRoot() == null || !entry.getRoot().equals(URLMapper.findFileObject((URL)uri.toURL()))) continue;
                                    Mutex.EVENT.readAccess(new Runnable(){

                                        @Override
                                        public void run() {
                                            JSFConfigurationPanelVisual.this.rbRegisteredLibrary.setSelected(true);
                                            JSFConfigurationPanelVisual.this.enableComponents(false);
                                            JSFConfigurationPanelVisual.this.cbLibraries.setSelectedItem(jsfLibrary.getLibrary().getDisplayName());
                                        }
                                    });
                                    return;
                                }
                            }
                            catch (MalformedURLException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
                J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
                Set deps = JSFConfigurationPanelVisual.getServerDependencies(j2eeModuleProvider);
                for (ServerLibraryDependency serverLibraryDependency : deps) {
                    if (!serverLibraryDependency.getName().startsWith("jsf")) continue;
                    ServerLibraryItem candidate = null;
                    for (ServerLibraryItem serverLibraryItem : JSFConfigurationPanelVisual.this.serverJsfLibraries) {
                        if (serverLibraryItem.getLibrary() != null) {
                            Version implVersion = serverLibraryItem.getLibrary().getImplementationVersion();
                            Version specVersion = serverLibraryItem.getLibrary().getSpecificationVersion();
                            if ((implVersion == null || !implVersion.equals((Object)serverLibraryDependency.getImplementationVersion())) && (specVersion == null || !specVersion.equals((Object)serverLibraryDependency.getSpecificationVersion()))) continue;
                            this.selectServerLibraryItem(serverLibraryItem);
                            return;
                        }
                        candidate = serverLibraryItem;
                    }
                    if (candidate == null) continue;
                    this.selectServerLibraryItem(candidate);
                }
            }

            private void selectServerLibraryItem(final ServerLibraryItem item) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        JSFConfigurationPanelVisual.this.rbServerLibrary.setSelected(true);
                        JSFConfigurationPanelVisual.this.enableComponents(false);
                        JSFConfigurationPanelVisual.this.serverLibraries.setSelectedItem(item);
                    }
                });
            }
        };
        RP.post(jsfLibararyUiSwitcher);
    }

    private static Set<ServerLibraryDependency> getServerDependencies(J2eeModuleProvider j2eeModuleProvider) {
        try {
            if (j2eeModuleProvider == null) {
                return Collections.emptySet();
            }
            return j2eeModuleProvider.getConfigSupport().getLibraries();
        }
        catch (ConfigurationException e) {
            return Collections.emptySet();
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    synchronized void initLibraries() {
        long time = System.currentTimeMillis();
        if (this.libsInitialized) {
            return;
        }
        this.serverJsfLibraries.clear();
        RP.post((Runnable)new ServerLibraryFinder());
        this.jsfLibraries.clear();
        RP.post((Runnable)new RegisteredLibraryFinder());
        this.libsInitialized = true;
        LOG.log(Level.FINEST, "Time spent in {0} initLibraries = {1} ms", new Object[]{this.getClass().getName(), System.currentTimeMillis() - time});
    }

    private void initJsfComponentsLibraries() {
        if (this.jsfComponentsInitialized) {
            return;
        }
        ArrayList<JsfComponentImplementation> jsfComponentDescriptors = new ArrayList<JsfComponentImplementation>();
        for (JsfComponentProvider jsfComponentProvider : jsfComponentProviders) {
            jsfComponentDescriptors.addAll(jsfComponentProvider.getJsfComponents());
        }
        for (JSFVersion jsfVersion : JSFVersion.values()) {
            List<JsfComponentImplementation> list = this.componentsMap.get((Object)jsfVersion);
            if (list == null) {
                list = new ArrayList<JsfComponentImplementation>();
                this.componentsMap.put(jsfVersion, list);
            }
            for (JsfComponentImplementation jsfImplementation : jsfComponentDescriptors) {
                if (!jsfImplementation.getJsfVersion().contains((Object)jsfVersion)) continue;
                list.add(jsfImplementation);
            }
        }
        this.jsfComponentsInitialized = true;
        if (this.currentJSFVersion != null) {
            this.updateJsfComponentsModel(this.currentJSFVersion);
        }
    }

    private void removeUserDefinedLibraries() {
        Iterator<LibraryItem> iterator = this.jsfLibraries.iterator();
        while (iterator.hasNext()) {
            LibraryItem item = iterator.next();
            Map properties = item.getLibrary().getProperties();
            if (properties.containsKey("maven-dependencies") && !((String)properties.get("maven-dependencies")).trim().isEmpty()) continue;
            iterator.remove();
        }
    }

    private static boolean isServerRegistered(String serverInstanceID) {
        return serverInstanceID != null && !"".equals(serverInstanceID) && !"DEV-NULL".equals(serverInstanceID);
    }

    private void setRegisteredLibraryModel(String[] items) {
        long time = System.currentTimeMillis();
        this.cbLibraries.setModel(new DefaultComboBoxModel<String>(items));
        if (items.length == 0) {
            this.rbRegisteredLibrary.setEnabled(false);
            this.cbLibraries.setEnabled(false);
            this.rbNewLibrary.setSelected(true);
            this.panel.setLibrary(null);
        } else if (items.length != 0 && this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.USED) {
            if (this.isFrameworkAddition) {
                this.rbRegisteredLibrary.setEnabled(true);
                this.cbLibraries.setEnabled(true);
            }
            this.rbRegisteredLibrary.setSelected(true);
            if (this.jsfLibraries.size() > 0) {
                this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getLibrary());
                this.setJsfVersion(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getVersion());
            }
        }
        this.repaint();
        LOG.log(Level.FINEST, "Time spent in {0} setLibraryModel = {1} ms", new Object[]{this.getClass().getName(), System.currentTimeMillis() - time});
    }

    private void setServerLibraryModel(Collection<ServerLibraryItem> items) {
        this.serverLibraries.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
        if (items.isEmpty()) {
            this.rbServerLibrary.setEnabled(false);
            this.serverLibraries.setEnabled(false);
            this.rbRegisteredLibrary.setSelected(true);
            this.panel.setServerLibrary(null);
        } else if (!items.isEmpty() && this.panel.getLibraryType() == JSFConfigurationPanel.LibraryType.SERVER) {
            ServerLibraryItem item;
            if (this.isFrameworkAddition) {
                this.rbServerLibrary.setEnabled(true);
                this.serverLibraries.setEnabled(true);
            }
            this.rbServerLibrary.setSelected(true);
            if (!this.serverJsfLibraries.isEmpty() && (item = (ServerLibraryItem)this.serverLibraries.getSelectedItem()) != null) {
                this.panel.setServerLibrary(item.getLibrary());
                this.setJsfVersion(item.getVersion());
            }
        }
        this.repaint();
    }

    private void updatePreferredLanguages() {
        ServerLibraryItem item;
        boolean faceletsPresent = false;
        Library jsfLibrary = null;
        JSFConfigurationPanel.LibraryType libraryType = this.panel.getLibraryType();
        if (libraryType == null) {
            return;
        }
        if (libraryType == JSFConfigurationPanel.LibraryType.USED) {
            if (!this.libsInitialized) {
                this.initLibraries();
            }
            jsfLibrary = this.panel.getLibrary();
        } else if (libraryType == JSFConfigurationPanel.LibraryType.NEW) {
            if (this.panel.getNewLibraryName() != null) {
                jsfLibrary = LibraryManager.getDefault().getLibrary(this.panel.getNewLibraryName());
            }
        } else if (libraryType == JSFConfigurationPanel.LibraryType.SERVER && this.serverLibraries.getSelectedItem() instanceof ServerLibraryItem && (item = (ServerLibraryItem)this.serverLibraries.getSelectedItem()) != null && item.getVersion().isAtLeast(JSFVersion.JSF_2_0)) {
            faceletsPresent = true;
        }
        if (jsfLibrary != null) {
            if (this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getVersion().isAtLeast(JSFVersion.JSF_2_0)) {
                faceletsPresent = true;
            } else {
                List content = jsfLibrary.getContent("classpath");
                try {
                    faceletsPresent = ClasspathUtil.containsClass((List)content, (String)"com.sun.facelets.Facelet") || ClasspathUtil.containsClass((List)content, (String)"com.sun.faces.facelets.Facelet");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.preferredLanguages.clear();
        this.preferredLanguages.add(JSFConfigurationPanel.PreferredLanguage.JSP);
        if (faceletsPresent) {
            if (this.isFrameworkAddition) {
                this.panel.setEnableFacelets(true);
            }
            if (this.panel.isEnableFacelets()) {
                this.preferredLanguages.add(0, JSFConfigurationPanel.PreferredLanguage.Facelets);
            } else {
                this.preferredLanguages.add(JSFConfigurationPanel.PreferredLanguage.Facelets);
            }
        } else {
            this.panel.setEnableFacelets(false);
        }
        this.cbPreferredLang.setModel(new DefaultComboBoxModel<Object>(this.preferredLanguages.toArray()));
        this.repaint();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jsfTabbedPane = new JTabbedPane();
        this.libPanel = new JPanel();
        this.rbServerLibrary = new JRadioButton();
        this.rbRegisteredLibrary = new JRadioButton();
        this.cbLibraries = new JComboBox();
        this.rbNewLibrary = new JRadioButton();
        this.lDirectory = new JLabel();
        this.customBundleTextField = new JTextField();
        this.jbBrowse = new JButton();
        this.lVersion = new JLabel();
        this.jtNewLibraryName = new JTextField();
        this.serverLibraries = new JComboBox();
        this.cbPackageJars = new JCheckBox();
        this.confPanel = new JPanel();
        this.lURLPattern = new JLabel();
        this.tURLPattern = new JTextField();
        this.cbPreferredLang = new JComboBox();
        this.jLabel1 = new JLabel();
        this.componentsPanel = new JPanel();
        this.jsfComponentsLabel = new JLabel();
        this.jsfComponentsScrollPane = new JScrollPane();
        this.jsfComponentsTable = new JTable();
        this.setLayout(new CardLayout());
        this.jsfTabbedPane.setMinimumSize(new Dimension(106, 62));
        this.jsfTabbedPane.setPreferredSize(new Dimension(483, 210));
        this.libPanel.setAlignmentX(0.2f);
        this.libPanel.setAlignmentY(0.2f);
        this.buttonGroup1.add(this.rbServerLibrary);
        this.rbServerLibrary.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_rbNoAppend").charAt(0));
        this.rbServerLibrary.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle");
        this.rbServerLibrary.setText(bundle.getString("LBL_Any_Library"));
        this.rbServerLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSFConfigurationPanelVisual.this.rbServerLibraryItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.rbRegisteredLibrary);
        this.rbRegisteredLibrary.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_rbRegLibs").charAt(0));
        this.rbRegisteredLibrary.setText(bundle.getString("LBL_REGISTERED_LIBRARIES"));
        this.rbRegisteredLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSFConfigurationPanelVisual.this.rbRegisteredLibraryItemStateChanged(evt);
            }
        });
        this.cbLibraries.setModel(JSFConfigurationPanelVisual.getLibrariesComboBoxModel());
        this.cbLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFConfigurationPanelVisual.this.cbLibrariesActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.rbNewLibrary);
        this.rbNewLibrary.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_rbCrNewLib").charAt(0));
        this.rbNewLibrary.setText(bundle.getString("LBL_CREATE_NEW_LIBRARY"));
        this.rbNewLibrary.setToolTipText(bundle.getString("MSG_CreatingLibraries"));
        this.rbNewLibrary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JSFConfigurationPanelVisual.this.rbNewLibraryItemStateChanged(evt);
            }
        });
        this.lDirectory.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lJSFDir").charAt(0));
        this.lDirectory.setLabelFor(this.customBundleTextField);
        this.lDirectory.setText(bundle.getString("LBL_INSTALL_DIR"));
        this.lDirectory.setToolTipText(bundle.getString("HINT_JSF_Directory"));
        this.customBundleTextField.setToolTipText(bundle.getString("HINT_JSF_Directory"));
        this.customBundleTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSFConfigurationPanelVisual.this.customBundleTextFieldKeyPressed(evt);
            }
        });
        this.jbBrowse.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Browse").charAt(0));
        this.jbBrowse.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_Browse"));
        this.jbBrowse.setToolTipText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"HINT_JSF_BROWSE_BTN"));
        this.jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFConfigurationPanelVisual.this.jbBrowseActionPerformed(evt);
            }
        });
        this.lVersion.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lJSFVer").charAt(0));
        this.lVersion.setLabelFor(this.jtNewLibraryName);
        this.lVersion.setText(bundle.getString("LBL_VERSION"));
        this.lVersion.setToolTipText(bundle.getString("HINT_Version"));
        this.jtNewLibraryName.setToolTipText(bundle.getString("HINT_Version"));
        this.jtNewLibraryName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JSFConfigurationPanelVisual.this.jtNewLibraryNameKeyReleased(evt);
            }
        });
        this.serverLibraries.setModel(JSFConfigurationPanelVisual.getLibrariesComboBoxModel());
        this.serverLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFConfigurationPanelVisual.this.serverLibrariesActionPerformed(evt);
            }
        });
        this.cbPackageJars.setSelected(true);
        this.cbPackageJars.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Package_JARs"));
        GroupLayout libPanelLayout = new GroupLayout(this.libPanel);
        this.libPanel.setLayout(libPanelLayout);
        libPanelLayout.setHorizontalGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(libPanelLayout.createSequentialGroup().addContainerGap().addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbNewLibrary, GroupLayout.Alignment.TRAILING, -1, 478, Short.MAX_VALUE).addGroup(libPanelLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbPackageJars).addComponent(this.lVersion).addComponent(this.lDirectory)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 206, Short.MAX_VALUE)).addGroup(libPanelLayout.createSequentialGroup().addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.rbServerLibrary, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.rbRegisteredLibrary, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbLibraries, 0, 283, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, libPanelLayout.createSequentialGroup().addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jtNewLibraryName, -1, 204, Short.MAX_VALUE).addComponent(this.customBundleTextField, -1, 204, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jbBrowse)).addComponent(this.serverLibraries, 0, 295, Short.MAX_VALUE)))).addContainerGap()));
        libPanelLayout.setVerticalGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, libPanelLayout.createSequentialGroup().addContainerGap().addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbServerLibrary).addComponent(this.serverLibraries, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbRegisteredLibrary).addComponent(this.cbLibraries, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbNewLibrary).addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jbBrowse).addComponent(this.customBundleTextField, -2, -1, -2).addComponent(this.lDirectory)).addGroup(libPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jtNewLibraryName, -2, -1, -2).addComponent(this.lVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPackageJars).addContainerGap(28, Short.MAX_VALUE)));
        this.cbPackageJars.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_PackageJarToWar"));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Libraries"), this.libPanel);
        this.lURLPattern.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_lURLPattern").charAt(0));
        this.lURLPattern.setLabelFor(this.tURLPattern);
        this.lURLPattern.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_URL_Pattern"));
        this.tURLPattern.setText(this.panel.getFacesMapping());
        this.cbPreferredLang.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbPreferredLang.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFConfigurationPanelVisual.this.cbPreferredLangActionPerformed(evt);
            }
        });
        this.jLabel1.setLabelFor(this.cbPreferredLang);
        this.jLabel1.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_PREFERRED_LANGUAGE"));
        GroupLayout confPanelLayout = new GroupLayout(this.confPanel);
        this.confPanel.setLayout(confPanelLayout);
        confPanelLayout.setHorizontalGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(confPanelLayout.createSequentialGroup().addContainerGap().addGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(confPanelLayout.createSequentialGroup().addComponent(this.lURLPattern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tURLPattern, -1, 281, Short.MAX_VALUE)).addGroup(confPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPreferredLang, -2, -1, -2))).addContainerGap()));
        confPanelLayout.setVerticalGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(confPanelLayout.createSequentialGroup().addContainerGap().addGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lURLPattern).addComponent(this.tURLPattern, -2, -1, -2)).addGap(33, 33, 33).addGroup(confPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbPreferredLang, -2, -1, -2)).addGap(98, 98, 98)));
        this.tURLPattern.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_Mapping"));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Configuration"), this.confPanel);
        this.jsfComponentsLabel.setText(this.getJsfComponentsLabelText());
        this.jsfComponentsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jsfComponentsScrollPane.setViewportView(this.jsfComponentsTable);
        GroupLayout componentsPanelLayout = new GroupLayout(this.componentsPanel);
        this.componentsPanel.setLayout(componentsPanelLayout);
        componentsPanelLayout.setHorizontalGroup(componentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(componentsPanelLayout.createSequentialGroup().addContainerGap().addGroup(componentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jsfComponentsScrollPane, -1, 462, Short.MAX_VALUE).addComponent(this.jsfComponentsLabel)).addContainerGap()));
        componentsPanelLayout.setVerticalGroup(componentsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(componentsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jsfComponentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jsfComponentsScrollPane, -1, 143, Short.MAX_VALUE).addContainerGap()));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Components"), this.componentsPanel);
        this.add((Component)this.jsfTabbedPane, "card10");
        this.jsfTabbedPane.getAccessibleContext().setAccessibleName("");
    }

    private void rbServerLibraryItemStateChanged(ItemEvent evt) {
        this.updateLibrary();
        if (this.rbServerLibrary.isSelected()) {
            this.panel.fireChangeEvent();
        }
    }

    private void jtNewLibraryNameKeyReleased(KeyEvent evt) {
        this.panel.setNewLibraryName(this.jtNewLibraryName.getText().trim());
    }

    private void rbNewLibraryItemStateChanged(ItemEvent evt) {
        this.updateLibrary();
        if (this.rbNewLibrary.isSelected()) {
            this.panel.fireChangeEvent();
        }
    }

    private void cbLibrariesActionPerformed(ActionEvent evt) {
        this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getLibrary());
        this.setJsfVersion(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getVersion());
        this.updatePreferredLanguages();
    }

    private void rbRegisteredLibraryItemStateChanged(ItemEvent evt) {
        this.updateLibrary();
        if (this.rbRegisteredLibrary.isSelected()) {
            this.panel.fireChangeEvent();
        }
    }

    private void jbBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_SelectLibraryLocation"));
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".jar") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_FileTypeInChooser");
            }
        });
        chooser.setCurrentDirectory(new File(this.customBundleTextField.getText().trim()));
        if (0 == chooser.showOpenDialog(this)) {
            File selectedEntry = chooser.getSelectedFile();
            this.customBundleTextField.setText(selectedEntry.getAbsolutePath());
            this.setNewLibraryFolder();
        }
    }

    private void customBundleTextFieldKeyPressed(KeyEvent evt) {
        this.setNewLibraryFolder();
    }

    private void cbPreferredLangActionPerformed(ActionEvent evt) {
        if (this.isFrameworkAddition) {
            JSFConfigurationPanel.PreferredLanguage selectedLanguage = this.getPreferredLanguage();
            if (JSFConfigurationPanel.PreferredLanguage.Facelets == selectedLanguage) {
                this.panel.updateEnableFacelets(true, true);
            } else {
                this.panel.updateEnableFacelets(false, true);
            }
        }
    }

    private void serverLibrariesActionPerformed(ActionEvent evt) {
        ServerLibraryItem item = (ServerLibraryItem)this.serverLibraries.getSelectedItem();
        if (item != null) {
            this.panel.setServerLibrary(item.getLibrary());
        }
        this.updatePreferredLanguages();
    }

    void enableComponents(boolean enable) {
        int i;
        Component[] components = this.confPanel.getComponents();
        for (i = 0; i < components.length; ++i) {
            components[i].setEnabled(enable);
        }
        this.cbPreferredLang.setEnabled(true);
        this.jLabel1.setEnabled(true);
        components = this.libPanel.getComponents();
        for (i = 0; i < components.length; ++i) {
            components[i].setEnabled(enable);
        }
    }

    boolean valid() {
        ExtenderController controller = this.panel.getController();
        String urlPattern = this.tURLPattern.getText();
        if (urlPattern == null || urlPattern.trim().equals("")) {
            this.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsEmpty"));
            return false;
        }
        if (!this.isPatternValid(urlPattern)) {
            this.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsNotValid"));
            return false;
        }
        if (controller.getProperties().getProperty("NoDocBase") != null) {
            this.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_MissingDocBase"));
            return false;
        }
        controller.getProperties().setProperty("WizardPanel_infoMessage", null);
        if (this.rbRegisteredLibrary.isSelected() && (this.jsfLibraries == null || this.jsfLibraries.size() == 0)) {
            this.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_MissingJSF"));
            return false;
        }
        if (this.rbNewLibrary.isSelected()) {
            String customResource = this.customBundleTextField.getText().trim();
            String string = JSFUtils.isJSFLibraryResource(new File(customResource));
            if ("".equals(customResource)) {
                this.setInfoMessage(string);
                return false;
            }
            if (string != null) {
                this.setErrorMessage(string);
                return false;
            }
            String newLibraryName = this.jtNewLibraryName.getText().trim();
            if (newLibraryName.length() <= 0) {
                this.setInfoMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_EmptyNewLibraryName"));
                return false;
            }
            String string2 = this.checkLibraryName(newLibraryName);
            if (string2 != null) {
                this.setErrorMessage(string2);
                return false;
            }
            Library lib = LibraryManager.getDefault().getLibrary(newLibraryName);
            if (lib != null) {
                this.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_AlreadyExists"));
                return false;
            }
        }
        if (!JSFConfigurationPanelVisual.isServerRegistered(this.serverInstanceID)) {
            this.setInfoMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ERR_MissingTargetServer"));
        }
        if (!this.panel.isMaven()) {
            for (JsfComponentImplementation jsfComponentImplementation : this.getActivedJsfDescriptors()) {
                JsfComponentCustomizer componentCustomizer = jsfComponentImplementation.createJsfComponentCustomizer(null);
                if (componentCustomizer == null || componentCustomizer.isValid()) continue;
                this.setErrorMessage(this.getFormatedJsfSuiteErrorMessage(jsfComponentImplementation.getDisplayName(), componentCustomizer.getErrorMessage()));
                return false;
            }
        }
        controller.setErrorMessage(null);
        return true;
    }

    private String getFormatedJsfSuiteErrorMessage(String suiteName, String suiteErrorMessage) {
        StringBuilder errorMessage = new StringBuilder();
        String suiteError = suiteErrorMessage == null ? "" : suiteErrorMessage;
        String localizedError = NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_JsfComponentNotValid", (Object)suiteName);
        if (!this.inCustomizer) {
            errorMessage.append("<html><b>").append(localizedError).append("</b><br>").append(suiteError).append("</html>");
        } else {
            errorMessage.append(localizedError).append("\n").append(suiteError);
        }
        return errorMessage.toString();
    }

    private void setErrorMessage(String message) {
        ExtenderController controller = this.panel.getController();
        controller.setErrorMessage(message);
        if (this.isFrameworkAddition) {
            controller.getProperties().setProperty("WizardPanel_infoMessage", (Object)message);
        }
    }

    private void setInfoMessage(String message) {
        ExtenderController controller = this.panel.getController();
        ExtenderController.Properties properties = controller.getProperties();
        controller.setErrorMessage(null);
        properties.setProperty("WizardPanel_infoMessage", (Object)message);
    }

    private boolean isPatternValid(String pattern) {
        String p;
        for (char c : INVALID_PATTERN_CHARS) {
            if (pattern.indexOf(c) == -1) continue;
            return false;
        }
        if (pattern.startsWith("*.") && (p = pattern.substring(2)).indexOf(46) == -1 && p.indexOf(42) == -1 && p.indexOf(47) == -1 && !p.trim().equals("")) {
            return true;
        }
        return pattern.length() > 3 && pattern.endsWith("/*") && pattern.startsWith("/");
    }

    private boolean isWebLogic(String serverInstanceID) {
        if (!JSFConfigurationPanelVisual.isServerRegistered(serverInstanceID)) {
            return false;
        }
        try {
            String shortName = Deployment.getDefault().getServerInstance(serverInstanceID).getServerID();
            if (shortName != null && shortName.toLowerCase().startsWith("weblogic")) {
                return true;
            }
        }
        catch (InstanceRemovedException ex) {
            LOG.log(Level.INFO, "Server Instance was removed", ex);
        }
        return false;
    }

    private Profile getProfile() {
        ExtenderController.Properties properties = this.panel.getController().getProperties();
        String j2eeLevel = (String)properties.getProperty("j2eeLevel");
        return j2eeLevel == null ? Profile.JAVA_EE_8_FULL : Profile.fromPropertiesString((String)j2eeLevel);
    }

    void update() {
        ExtenderController.Properties properties = this.panel.getController().getProperties();
        this.serverInstanceID = (String)properties.getProperty("serverInstanceID");
        if (this.panel.isMaven()) {
            this.setNewLibraryOptionVisible(false);
            if (!JSFConfigurationPanelVisual.isServerRegistered(this.serverInstanceID)) {
                this.cbPackageJars.setVisible(true);
            }
        }
        this.initLibSettings();
    }

    private void initLibSettings() {
        boolean serverChanged = this.isServerInstanceChanged();
        if (serverChanged) {
            RP.post((Runnable)new ServerLibraryFinder());
        }
        if (this.panel != null && this.panel.getLibraryType() != null) {
            switch (this.panel.getLibraryType()) {
                case NEW: {
                    this.rbNewLibrary.setSelected(true);
                    break;
                }
                case USED: {
                    this.rbRegisteredLibrary.setSelected(true);
                    break;
                }
                case SERVER: {
                    this.rbServerLibrary.setSelected(true);
                    this.enableDefinedLibraryComponent(false);
                    this.enableNewLibraryComponent(false);
                }
            }
        }
    }

    void setJsfVersion(JSFVersion version) {
        if (version != this.currentJSFVersion) {
            this.currentJSFVersion = version;
            this.updateJsfComponentsModel(version);
        }
    }

    private boolean isServerInstanceChanged() {
        if (this.serverInstanceID == null && this.currentServerInstanceID != null || this.serverInstanceID != null && !this.serverInstanceID.equals(this.currentServerInstanceID)) {
            this.currentServerInstanceID = this.serverInstanceID;
            return true;
        }
        return false;
    }

    private void setNewLibraryOptionVisible(boolean visible) {
        this.rbNewLibrary.setVisible(visible);
        this.lDirectory.setVisible(visible);
        this.lVersion.setVisible(visible);
        this.customBundleTextField.setVisible(visible);
        this.jbBrowse.setVisible(visible);
        this.jtNewLibraryName.setVisible(visible);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JSFConfigurationPanelVisual.class);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    public String getServletName() {
        return this.jsfServletName == null ? JSF_SERVLET_NAME : this.jsfServletName;
    }

    protected void setServletName(String name) {
        this.jsfServletName = name;
    }

    public String getURLPattern() {
        return this.tURLPattern.getText();
    }

    protected void setURLPattern(String pattern) {
        this.tURLPattern.setText(pattern);
    }

    public TreeMap<String, JsfComponentCustomizer> getJsfComponentCustomizers() {
        return this.jsfComponentCustomizers;
    }

    public void addJsfComponentCustomizer(String jsfComponentName, JsfComponentCustomizer jsfComponentCustomizer) {
        this.jsfComponentCustomizers.remove(jsfComponentName);
        this.jsfComponentCustomizers.put(jsfComponentName, jsfComponentCustomizer);
    }

    public List<? extends JsfComponentImplementation> getActivedJsfDescriptors() {
        ArrayList<JsfComponentImplementation> activatedDescriptors = new ArrayList<JsfComponentImplementation>();
        for (int i = 0; i < this.jsfComponentsTableModel.getRowCount(); ++i) {
            if (!this.jsfComponentsTableModel.getItem(i).isSelected().booleanValue()) continue;
            activatedDescriptors.add(this.jsfComponentsTableModel.getItem(i).getJsfComponent());
        }
        return activatedDescriptors;
    }

    public List<? extends JsfComponentImplementation> getAllJsfDescriptors() {
        ArrayList<JsfComponentImplementation> allDescriptors = new ArrayList<JsfComponentImplementation>();
        for (int i = 0; i < this.jsfComponentsTableModel.getRowCount(); ++i) {
            allDescriptors.add(this.jsfComponentsTableModel.getItem(i).getJsfComponent());
        }
        return allDescriptors;
    }

    public boolean packageJars() {
        return this.cbPackageJars.isSelected();
    }

    @CheckForNull
    protected JSFConfigurationPanel.PreferredLanguage getPreferredLanguage() {
        Object selectedItem = this.cbPreferredLang.getSelectedItem();
        if (selectedItem instanceof JSFConfigurationPanel.PreferredLanguage) {
            return (JSFConfigurationPanel.PreferredLanguage)((Object)selectedItem);
        }
        return null;
    }

    private void updateLibrary() {
        if (this.cbLibraries.getItemCount() == 0) {
            this.rbRegisteredLibrary.setEnabled(false);
        }
        if (this.rbServerLibrary.isSelected()) {
            ServerLibraryItem item;
            this.enableNewLibraryComponent(false);
            this.enableDefinedLibraryComponent(false);
            this.enableServerLibraryComponent(true);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.SERVER);
            if (!this.serverJsfLibraries.isEmpty() && this.serverLibraries.getSelectedItem() instanceof ServerLibraryItem && (item = (ServerLibraryItem)this.serverLibraries.getSelectedItem()) != null) {
                this.panel.setServerLibrary(item.getLibrary());
                this.setJsfVersion(item.getVersion());
            }
            this.panel.getController().setErrorMessage(null);
        } else if (this.rbRegisteredLibrary.isSelected()) {
            this.enableNewLibraryComponent(false);
            this.enableDefinedLibraryComponent(true);
            this.enableServerLibraryComponent(false);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.USED);
            if (this.jsfLibraries.size() > 0) {
                this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getLibrary());
                this.panel.setServerLibrary(null);
                this.setJsfVersion(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()).getVersion());
            }
            this.panel.getController().setErrorMessage(null);
        } else if (this.rbNewLibrary.isSelected()) {
            this.enableNewLibraryComponent(true);
            this.enableDefinedLibraryComponent(false);
            this.enableServerLibraryComponent(false);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.NEW);
            this.panel.setServerLibrary(null);
            this.setNewLibraryFolder();
        }
        this.updatePreferredLanguages();
    }

    private void updateJsfComponentsModel(JSFVersion version) {
        List<JsfComponentImplementation> descriptors = this.componentsMap.get((Object)version);
        this.jsfComponentsTableModel.removeAllItems();
        if (descriptors != null) {
            for (JsfComponentImplementation descriptor : descriptors) {
                this.addFrameworkToModel(descriptor);
            }
        }
        this.jsfComponentsTable.setModel(this.jsfComponentsTableModel);
    }

    private void updateJsfComponents() {
        if (this.currentJSFVersion != null && !this.isFrameworkAddition) {
            this.initJsfComponentLibraries(this.currentJSFVersion);
        }
    }

    private void enableDefinedLibraryComponent(boolean enabled) {
        this.cbLibraries.setEnabled(enabled);
    }

    private void enableServerLibraryComponent(boolean enabled) {
        this.serverLibraries.setEnabled(enabled);
    }

    private void enableNewLibraryComponent(boolean enabled) {
        this.lDirectory.setEnabled(enabled);
        this.customBundleTextField.setEnabled(enabled);
        this.jbBrowse.setEnabled(enabled);
        this.lVersion.setEnabled(enabled);
        this.jtNewLibraryName.setEnabled(enabled);
    }

    private void setNewLibraryFolder() {
        String fileName = this.customBundleTextField.getText();
        if (fileName == null || "".equals(fileName)) {
            this.panel.setInstallResource(null);
        } else {
            File folder = new File(fileName);
            this.panel.setInstallResource(folder);
        }
    }

    private String checkLibraryName(String name) {
        String message = null;
        if (name.length() == 0) {
            message = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_InvalidLibraryName");
        } else if (!VALID_PROPERTY_NAME.matcher(name).matches()) {
            message = NbBundle.getMessage(JSFUtils.class, (String)"ERROR_InvalidLibraryNameCharacters");
        }
        return message;
    }

    private String getJsfComponentsLabelText() {
        if (this.isFrameworkAddition) {
            return NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_JSF_Components_Desc_New_Project");
        }
        return NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_JSF_Components_Desc_Customizer");
    }

    private static ComboBoxModel getLibrariesComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{Bundle.JSFConfigurationPanelVisual_lbl_searching_libraries()});
    }

    private void initJsfComponentLibraries(JSFVersion version) {
        List<JsfComponentImplementation> descriptors = this.componentsMap.get((Object)version);
        if (descriptors == null) {
            return;
        }
        for (int i = 0; i < descriptors.size(); ++i) {
            JsfComponentImplementation jsfComponentDescriptor = descriptors.get(i);
            if (!jsfComponentDescriptor.isInWebModule(this.panel.getWebModule())) continue;
            this.jsfComponentsTable.setValueAt(true, i, 0);
        }
    }

    private void initJsfComponentTableVisualProperties(JTable table) {
        table.setRowSelectionAllowed(true);
        table.getSelectionModel().setSelectionMode(0);
        table.setTableHeader(null);
        table.setRowHeight(this.jsfComponentsTable.getRowHeight() + 4);
        table.setIntercellSpacing(new Dimension(0, 0));
        table.getParent().setBackground(table.getBackground());
        table.setShowHorizontalLines(false);
        table.setShowVerticalLines(false);
        table.getColumnModel().getColumn(0).setMaxWidth(30);
        if (!this.panel.isMaven()) {
            table.getColumnModel().getColumn(2).setMaxWidth(100);
        }
    }

    private void addFrameworkToModel(JsfComponentImplementation component) {
        this.jsfComponentsTableModel.addItem(new JSFComponentModelItem(component));
    }

    private static void fireJsfDialogUpdate(JsfComponentCustomizer jsfComponentExtender, DialogDescriptor dialogDescriptor) {
        if (jsfComponentExtender.getErrorMessage() != null) {
            dialogDescriptor.getNotificationLineSupport().setErrorMessage(jsfComponentExtender.getErrorMessage());
        } else if (jsfComponentExtender.getWarningMessage() != null) {
            dialogDescriptor.getNotificationLineSupport().setWarningMessage(jsfComponentExtender.getWarningMessage());
        } else {
            dialogDescriptor.getNotificationLineSupport().clearMessages();
        }
        dialogDescriptor.setValid(jsfComponentExtender.isValid());
    }

    private static HashSet<Library> getOrCacheJsfLibraries() {
        if (jsfLibrariesCacheDirty) {
            jsfLibrariesCacheDirty = false;
            JSFConfigurationPanelVisual.searchJsfLibraries();
            LibraryManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("libraries".equals(evt.getPropertyName())) {
                        jsfLibrariesCacheDirty = true;
                        JSF_LIBRARIES_CACHE.clear();
                    }
                }
            });
        }
        return new HashSet<Library>(JSF_LIBRARIES_CACHE);
    }

    private static void searchJsfLibraries() {
        for (Library library : LibraryManager.getDefault().getLibraries()) {
            if (!"j2se".equals(library.getType()) || EXCLUDE_FROM_REGISTERED_LIBS.contains(library.getName())) continue;
            List content = library.getContent("classpath");
            try {
                Boolean foundJsfLibrary = (Boolean)ClasspathUtil.containsClass((List)content, JSF_SEEKING_MAP);
                if (foundJsfLibrary == null || !foundJsfLibrary.booleanValue()) continue;
                JSF_LIBRARIES_CACHE.add(library);
            }
            catch (IOException exception) {
                LOG.log(Level.INFO, "", exception);
            }
        }
    }

    static {
        JSF_SEEKING_MAP.put(false, "javax.ejb.Stateless");
        JSF_SEEKING_MAP.put(true, "javax.faces.FacesException");
        JSF_SEEKING_MAP.put(false, "jakarta.ejb.Stateless");
        JSF_SEEKING_MAP.put(true, "jakarta.faces.FacesException");
        INVALID_PATTERN_CHARS = new char[]{'%', '+'};
        VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");
    }

    private class RegisteredLibraryFinder
    implements Runnable {
        private RegisteredLibraryFinder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JSFConfigurationPanelVisual jSFConfigurationPanelVisual = JSFConfigurationPanelVisual.this;
            synchronized (jSFConfigurationPanelVisual) {
                long time = System.currentTimeMillis();
                for (Library library : JSFConfigurationPanelVisual.getOrCacheJsfLibraries()) {
                    List content = library.getContent("classpath");
                    JSFVersion jsfVersion = JSFVersion.forClasspath(content);
                    LibraryItem item = jsfVersion != null ? new LibraryItem(library, jsfVersion) : new LibraryItem(library, JSFVersion.JSF_1_1);
                    JSFConfigurationPanelVisual.this.jsfLibraries.add(item);
                    Collections.sort(JSFConfigurationPanelVisual.this.jsfLibraries, new Comparator<LibraryItem>(){

                        @Override
                        public int compare(LibraryItem li1, LibraryItem li2) {
                            return li1.getLibrary().getDisplayName().compareTo(li2.getLibrary().getDisplayName());
                        }
                    });
                    Collections.reverse(JSFConfigurationPanelVisual.this.jsfLibraries);
                }
                if (JSFConfigurationPanelVisual.this.panel.isMaven()) {
                    JSFConfigurationPanelVisual.this.removeUserDefinedLibraries();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<String> registeredItems = new ArrayList<String>();
                        for (LibraryItem libraryItem : JSFConfigurationPanelVisual.this.jsfLibraries) {
                            registeredItems.add(libraryItem.getLibrary().getDisplayName());
                        }
                        JSFConfigurationPanelVisual.this.setRegisteredLibraryModel(registeredItems.toArray(new String[registeredItems.size()]));
                        JSFConfigurationPanelVisual.this.updatePreferredLanguages();
                        JSFConfigurationPanelVisual.this.updateJsfComponents();
                    }
                });
                LOG.log(Level.FINEST, "Time spent in init registered libraries = {0} ms", System.currentTimeMillis() - time);
            }
        }
    }

    private class ServerLibraryFinder
    implements Runnable {
        private ServerLibraryFinder() {
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            EnumSet<JSFVersion> found = EnumSet.noneOf(JSFVersion.class);
            if (JSFConfigurationPanelVisual.isServerRegistered(JSFConfigurationPanelVisual.this.serverInstanceID)) {
                try {
                    ServerInstance.LibraryManager libManager = Deployment.getDefault().getServerInstance(JSFConfigurationPanelVisual.this.serverInstanceID).getLibraryManager();
                    if (libManager != null) {
                        HashSet libs = new HashSet();
                        libs.addAll(libManager.getDeployedLibraries());
                        libs.addAll(libManager.getDeployableLibraries());
                        for (ServerLibrary lib : libs) {
                            JSFVersion jsfVersion = JSFVersion.forServerLibrary(lib);
                            if (jsfVersion == null) continue;
                            JSFConfigurationPanelVisual.this.serverJsfLibraries.add(new ServerLibraryItem(lib, jsfVersion));
                            found.add(jsfVersion);
                        }
                    }
                }
                catch (InstanceRemovedException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
            }
            J2eePlatform platform = null;
            try {
                if (JSFConfigurationPanelVisual.isServerRegistered(JSFConfigurationPanelVisual.this.serverInstanceID)) {
                    platform = Deployment.getDefault().getServerInstance(JSFConfigurationPanelVisual.this.serverInstanceID).getJ2eePlatform();
                }
            }
            catch (InstanceRemovedException ex) {
                platform = null;
                LOG.log(Level.INFO, NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"SERVER_INSTANCE_REMOVED"), ex);
            }
            File[] cp = platform != null ? platform.getClasspathEntries() : new File[]{};
            JSFVersion jsfVersion = JSFVersion.forClasspath(Arrays.asList(cp));
            if (jsfVersion != null && !found.contains((Object)jsfVersion)) {
                JSFConfigurationPanelVisual.this.serverJsfLibraries.add(new ServerLibraryItem(null, jsfVersion));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSFConfigurationPanelVisual.this.setServerLibraryModel(JSFConfigurationPanelVisual.this.serverJsfLibraries);
                    if (JSFConfigurationPanelVisual.this.serverJsfLibraries.isEmpty()) {
                        Library preferredLibrary = JSFConfigurationPanelVisual.this.getProfile() != null && JSFConfigurationPanelVisual.this.getProfile().isAtLeast(Profile.JAKARTA_EE_10_WEB) ? LibraryManager.getDefault().getLibrary("jsf40") : (JSFConfigurationPanelVisual.this.getProfile() != null && JSFConfigurationPanelVisual.this.getProfile().isAtLeast(Profile.JAKARTA_EE_9_WEB) ? LibraryManager.getDefault().getLibrary("jsf30") : (JSFConfigurationPanelVisual.this.getProfile() != null && JSFConfigurationPanelVisual.this.getProfile().isAtLeast(Profile.JAVA_EE_5) ? LibraryManager.getDefault().getLibrary("jsf20") : LibraryManager.getDefault().getLibrary("jsf12")));
                        if (preferredLibrary != null) {
                            JSFConfigurationPanelVisual.this.rbRegisteredLibrary.setSelected(true);
                            JSFConfigurationPanelVisual.this.cbLibraries.setSelectedItem(preferredLibrary.getDisplayName());
                            JSFConfigurationPanelVisual.this.updateLibrary();
                        } else if (JSFConfigurationPanelVisual.this.jsfLibraries.isEmpty()) {
                            JSFConfigurationPanelVisual.this.rbNewLibrary.setSelected(true);
                        }
                    } else {
                        if (!JSFConfigurationPanelVisual.this.rbServerLibrary.isVisible()) {
                            JSFConfigurationPanelVisual.this.rbServerLibrary.setVisible(true);
                            JSFConfigurationPanelVisual.this.serverLibraries.setVisible(true);
                            JSFConfigurationPanelVisual.this.repaint();
                        }
                        JSFConfigurationPanelVisual.this.rbServerLibrary.setSelected(true);
                        if (JSFConfigurationPanelVisual.this.panel != null) {
                            JSFConfigurationPanelVisual.this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.SERVER);
                        }
                        JSFConfigurationPanelVisual.this.enableNewLibraryComponent(false);
                        JSFConfigurationPanelVisual.this.enableDefinedLibraryComponent(false);
                    }
                    JSFConfigurationPanelVisual.this.updatePreferredLanguages();
                    JSFConfigurationPanelVisual.this.updateJsfComponents();
                    JSFConfigurationPanelVisual.this.updateLibrary();
                }
            });
            LOG.log(Level.FINEST, "Time spent in server libraries init = {0} ms", System.currentTimeMillis() - time);
        }
    }

    private final class JSFComponentModelItem {
        private JsfComponentImplementation component;
        private Boolean selected;

        public JSFComponentModelItem(JsfComponentImplementation component) {
            this.setJsfComponent(component);
            this.setSelected(Boolean.FALSE);
        }

        public JsfComponentImplementation getJsfComponent() {
            return this.component;
        }

        public void setJsfComponent(JsfComponentImplementation component) {
            this.component = component;
        }

        public Boolean isSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = selected;
        }

        public Boolean isClickable() {
            return this.component.createJsfComponentCustomizer(null) != null;
        }
    }

    private final class JSFComponentWindowChangeListener
    implements ChangeListener {
        private DialogDescriptor dialogDescriptor;
        private JsfComponentCustomizer jsfComponentExtender;

        private JSFComponentWindowChangeListener() {
        }

        public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
            this.dialogDescriptor = dialogDescriptor;
        }

        public void setJsfComponentExtender(JsfComponentCustomizer jsfComponentExtender) {
            this.jsfComponentExtender = jsfComponentExtender;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            assert (this.dialogDescriptor != null && this.jsfComponentExtender != null);
            JSFConfigurationPanelVisual.fireJsfDialogUpdate(this.jsfComponentExtender, this.dialogDescriptor);
            JSFConfigurationPanelVisual.this.panel.fireChangeEvent();
        }
    }

    private final class JSFComponentModelActionListener
    implements ActionListener {
        private final JsfComponentImplementation jsfDescriptor;
        private final JSFComponentWindowChangeListener listener;
        private final JsfComponentCustomizer jsfCustomizer;
        private final DialogDescriptor dialogDescriptor;

        public JSFComponentModelActionListener(JsfComponentImplementation jsfDescriptor) {
            this.jsfDescriptor = jsfDescriptor;
            this.listener = new JSFComponentWindowChangeListener();
            this.jsfCustomizer = jsfDescriptor.createJsfComponentCustomizer(null);
            this.dialogDescriptor = new DialogDescriptor((Object)this.jsfCustomizer.getComponent(), jsfDescriptor.getDisplayName(), true, null);
            this.initDialog();
        }

        private void initDialog() {
            this.jsfCustomizer.addChangeListener(this.listener);
            this.dialogDescriptor.createNotificationLineSupport();
            this.dialogDescriptor.setHelpCtx(this.jsfCustomizer.getHelpCtx());
            this.dialogDescriptor.setButtonListener((ActionListener)new ButtonsListener());
            this.listener.setJsfComponentExtender(this.jsfCustomizer);
            this.listener.setDialogDescriptor(this.dialogDescriptor);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSFConfigurationPanelVisual.fireJsfDialogUpdate(this.jsfCustomizer, this.dialogDescriptor);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)this.dialogDescriptor);
        }

        private final class ButtonsListener
        implements ActionListener {
            private ButtonsListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(DialogDescriptor.OK_OPTION)) {
                    JSFConfigurationPanelVisual.this.addJsfComponentCustomizer(JSFComponentModelActionListener.this.jsfDescriptor.getName(), JSFComponentModelActionListener.this.jsfCustomizer);
                    JSFComponentModelActionListener.this.jsfCustomizer.saveConfiguration();
                }
                JSFConfigurationPanelVisual.this.panel.fireChangeEvent();
            }
        }
    }

    public final class JSFComponentsTableModel
    extends AbstractTableModel {
        private final Class<?>[] COLUMN_TYPES = new Class[]{Boolean.class, JsfComponentImplementation.class, JButton.class};
        private DefaultListModel<JSFComponentModelItem> model = new DefaultListModel();

        @Override
        public int getColumnCount() {
            if (JSFConfigurationPanelVisual.this.panel.isMaven()) {
                return 2;
            }
            return this.COLUMN_TYPES.length;
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        public Class getColumnClass(int columnIndex) {
            return this.COLUMN_TYPES[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            JSFComponentModelItem item = this.getItem(row);
            switch (column) {
                case 0: {
                    return item.isSelected();
                }
                case 1: {
                    return item.getJsfComponent();
                }
                case 2: {
                    if (item.isClickable().booleanValue()) {
                        JButton button = new JButton(NbBundle.getMessage(JSFConfigurationWizardPanelVisual.class, (String)"LBL_MoreButton"));
                        button.addActionListener(new JSFComponentModelActionListener(item.getJsfComponent()));
                        return button;
                    }
                    return null;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            JSFComponentModelItem item = this.getItem(row);
            switch (column) {
                case 0: {
                    item.setSelected((Boolean)value);
                    break;
                }
                case 1: {
                    item.setJsfComponent((JsfComponentImplementation)value);
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        private JSFComponentModelItem getItem(int index) {
            return this.model.get(index);
        }

        public void addItem(JSFComponentModelItem item) {
            this.model.addElement(item);
        }

        public void removeAllItems() {
            if (!this.model.isEmpty()) {
                this.model.removeAllElements();
            }
        }
    }

    private class JsfComponentsMouseListener
    extends MouseAdapter {
        private JsfComponentsMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int column = JSFConfigurationPanelVisual.this.jsfComponentsTable.getColumnModel().getColumnIndexAtX(e.getX());
            int row = e.getY() / JSFConfigurationPanelVisual.this.jsfComponentsTable.getRowHeight();
            if (row < JSFConfigurationPanelVisual.this.jsfComponentsTable.getRowCount() && row >= 0 && column < JSFConfigurationPanelVisual.this.jsfComponentsTable.getColumnCount() && column >= 0) {
                Object value = JSFConfigurationPanelVisual.this.jsfComponentsTable.getValueAt(row, column);
                if (value instanceof JButton) {
                    ((JButton)value).doClick();
                } else if (value instanceof Boolean) {
                    JSFConfigurationPanelVisual.this.panel.fireChangeEvent();
                }
            }
        }
    }

    private class JsfComponentsTableModelListener
    implements TableModelListener {
        private JsfComponentsTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (JSFConfigurationPanelVisual.this.jsfComponentsTable.getSelectedRow() == -1) {
                return;
            }
            JSFConfigurationPanelVisual.this.panel.fireChangeEvent();
        }
    }

    private static class JTableButtonRenderer
    implements TableCellRenderer {
        private JTableButtonRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JButton button = (JButton)value;
            if (isSelected) {
                button.setForeground(table.getSelectionForeground());
                button.setBackground(table.getSelectionBackground());
            } else {
                button.setForeground(table.getForeground());
                button.setBackground(UIManager.getColor("Button.background"));
            }
            return button;
        }
    }

    public static class JsfComponentsTableCellRenderer
    extends DefaultTableCellRenderer {
        private TableCellRenderer jbuttonRenderer;
        private TableCellRenderer booleanRenderer;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof JsfComponentImplementation) {
                JsfComponentImplementation item = (JsfComponentImplementation)value;
                Component comp = super.getTableCellRendererComponent(table, item.getDisplayName(), isSelected, false, row, column);
                if (comp instanceof JComponent) {
                    ((JComponent)comp).setOpaque(isSelected);
                }
                return comp;
            }
            if (value instanceof Boolean && this.booleanRenderer != null) {
                return this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }
            if (value instanceof JButton && this.jbuttonRenderer != null) {
                return this.jbuttonRenderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        public void setBooleanRenderer(TableCellRenderer booleanRenderer) {
            this.booleanRenderer = booleanRenderer;
        }

        public void setJButtonRenderer(TableCellRenderer jbuttonRenderer) {
            this.jbuttonRenderer = jbuttonRenderer;
        }
    }

    private static class ServerLibraryItem
    implements Comparable<ServerLibraryItem> {
        private final ServerLibrary library;
        private final JSFVersion version;
        private String name;

        public ServerLibraryItem(ServerLibrary library, JSFVersion version) {
            this.library = library;
            this.version = version;
        }

        public ServerLibrary getLibrary() {
            return this.library;
        }

        public JSFVersion getVersion() {
            return this.version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            ServerLibraryItem serverLibraryItem = this;
            synchronized (serverLibraryItem) {
                if (this.name != null) {
                    return this.name;
                }
            }
            StringBuilder sb = new StringBuilder(this.version.getShortName());
            if (this.library != null && (this.library.getImplementationTitle() != null || this.library.getImplementationVersion() != null)) {
                sb.append(" ");
                sb.append("[");
                if (this.library.getImplementationTitle() != null) {
                    sb.append(this.library.getImplementationTitle());
                }
                if (this.library.getImplementationVersion() != null) {
                    if (this.library.getImplementationTitle() != null) {
                        sb.append(" - ");
                    }
                    sb.append(this.library.getImplementationVersion().toString());
                }
                sb.append("]");
            }
            ServerLibraryItem serverLibraryItem2 = this;
            synchronized (serverLibraryItem2) {
                this.name = sb.toString();
                return this.name;
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerLibraryItem other = (ServerLibraryItem)obj;
            return !(this.toString() == null ? other.toString() != null : !this.toString().equals(other.toString()));
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.toString() != null ? this.toString().hashCode() : 0);
            return hash;
        }

        @Override
        public int compareTo(ServerLibraryItem o) {
            return -this.toString().compareTo(o.toString());
        }
    }

    private static class LibraryItem {
        private Library library;
        private JSFVersion version;

        public LibraryItem(Library library, JSFVersion version) {
            this.library = library;
            this.version = version;
        }

        public Library getLibrary() {
            return this.library;
        }

        public JSFVersion getVersion() {
            return this.version;
        }

        public String toString() {
            return this.library.getDisplayName();
        }
    }
}

