/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class GetRepositoryRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String opcRequestId;
    private List<Fields> fields;

    @ConstructorProperties(value={"repositoryId", "opcRequestId", "fields"})
    GetRepositoryRequest(String repositoryId, String opcRequestId, List<Fields> fields) {
        this.repositoryId = repositoryId;
        this.opcRequestId = opcRequestId;
        this.fields = fields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).opcRequestId(this.opcRequestId).fields(this.fields);
    }

    public String toString() {
        return "GetRepositoryRequest(super=" + super.toString() + ", repositoryId=" + this.getRepositoryId() + ", opcRequestId=" + this.getOpcRequestId() + ", fields=" + this.getFields() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetRepositoryRequest)) {
            return false;
        }
        GetRepositoryRequest other = (GetRepositoryRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$repositoryId = this.getRepositoryId();
        String other$repositoryId = other.getRepositoryId();
        if (this$repositoryId == null ? other$repositoryId != null : !this$repositoryId.equals(other$repositoryId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        List<Fields> this$fields = this.getFields();
        List<Fields> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetRepositoryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $repositoryId = this.getRepositoryId();
        result = result * 59 + ($repositoryId == null ? 43 : $repositoryId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        List<Fields> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Fields> getFields() {
        return this.fields;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRepositoryRequest, Void> {
        private String repositoryId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private List<Fields> fields = null;

        public Builder fields(List<Fields> fields) {
            this.fields = fields;
            return this;
        }

        public Builder fields(Fields singularValue) {
            return this.fields(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRepositoryRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.opcRequestId(o.getOpcRequestId());
            this.fields(o.getFields());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRepositoryRequest build() {
            GetRepositoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetRepositoryRequest buildWithoutInvocationCallback() {
            return new GetRepositoryRequest(this.repositoryId, this.opcRequestId, this.fields);
        }

        public String toString() {
            return "GetRepositoryRequest.Builder(repositoryId=" + this.repositoryId + ", opcRequestId=" + this.opcRequestId + ", fields=" + this.fields + ")";
        }
    }

    public static enum Fields {
        BranchCount("branchCount"),
        CommitCount("commitCount"),
        SizeInBytes("sizeInBytes");

        private final String value;
        private static Map<String, Fields> map;

        private Fields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Fields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Fields: " + key);
        }

        static {
            map = new HashMap<String, Fields>();
            for (Fields v : Fields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

