/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.indexing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.completion.AttrValuesCompletion;
import org.netbeans.modules.html.editor.indexing.Entry;
import org.netbeans.modules.html.editor.indexing.HtmlLinkEntry;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public class HtmlFileModel {
    private static final String STYLE_TAG_NAME = "style";
    private static final Logger LOGGER = Logger.getLogger(HtmlFileModel.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private final List<HtmlLinkEntry> references = new ArrayList<HtmlLinkEntry>();
    private final List<OffsetRange> embeddedCssSections = new ArrayList<OffsetRange>();
    private final Map<String, List<Entry>> cssClasses = new HashMap<String, List<Entry>>();
    private final Map<String, Entry> ids = new HashMap<String, Entry>();
    private HtmlParsingResult htmlResult;
    private Parser.Result parserResult;
    private int embedded_css_section_start = -1;

    public HtmlFileModel(Source source) throws ParseException {
        ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                if (ri != null) {
                    HtmlFileModel.this.parserResult = ri.getParserResult();
                    HtmlFileModel.this.htmlResult = (HtmlParsingResult)HtmlFileModel.this.parserResult;
                    HtmlFileModel.this.init();
                }
            }
        });
    }

    public HtmlFileModel(Parser.Result parserResult, HtmlParsingResult htmlResult) {
        this.parserResult = parserResult;
        this.htmlResult = (HtmlParsingResult)parserResult;
        this.init();
    }

    public HtmlParsingResult getParserResult() {
        return this.htmlResult;
    }

    public Snapshot getSnapshot() {
        return this.parserResult.getSnapshot();
    }

    public FileObject getFileObject() {
        return this.getSnapshot().getSource().getFileObject();
    }

    public List<HtmlLinkEntry> getReferences() {
        return Collections.unmodifiableList(this.references);
    }

    public List<OffsetRange> getEmbeddedCssSections() {
        return Collections.unmodifiableList(this.embeddedCssSections);
    }

    public Map<String, Entry> getIds() {
        return Collections.unmodifiableMap(this.ids);
    }

    public Map<String, List<Entry>> getCssClasses() {
        HashMap result = new HashMap();
        this.cssClasses.forEach((k, v) -> result.put(k, Collections.unmodifiableList(v)));
        return Collections.unmodifiableMap(result);
    }

    private void init() {
        Iterator elements = this.htmlResult.getSyntaxAnalyzerResult().getElementsIterator();
        while (elements.hasNext()) {
            Element element = (Element)elements.next();
            switch (element.type()) {
                case OPEN_TAG: {
                    this.handleOpenTag((OpenTag)element);
                    break;
                }
                case CLOSE_TAG: {
                    this.handleCloseTag((CloseTag)element);
                }
            }
        }
    }

    private void handleOpenTag(OpenTag tnode) {
        CharSequence unquotedValue;
        this.handleReference(tnode);
        this.handleEmbeddedCssSectionStart(tnode);
        Attribute attr = tnode.getAttribute("id");
        if (attr != null && (unquotedValue = attr.unquotedValue()) != null && unquotedValue.length() > 0) {
            String unquotedString = unquotedValue.toString();
            boolean isQuoted = attr.isValueQuoted();
            int startOffset = attr.valueOffset() + (isQuoted ? 1 : 0);
            int endOffset = startOffset + unquotedValue.length();
            OffsetRange astRange = new OffsetRange(startOffset, endOffset);
            OffsetRange documentRange = new OffsetRange(this.getSnapshot().getOriginalOffset(startOffset), this.getSnapshot().getOriginalOffset(endOffset));
            if (!this.ids.containsKey(unquotedString)) {
                this.ids.put(unquotedString, new Entry(unquotedString, astRange, documentRange));
            }
        }
        if ((attr = tnode.getAttribute("class")) != null && (unquotedValue = attr.unquotedValue()) != null && unquotedValue.length() > 0) {
            Scanner scanner = new Scanner(unquotedValue.toString());
            while (scanner.hasNext()) {
                String className = scanner.next();
                if (className.equals("@@@")) continue;
                boolean isQuoted = attr.isValueQuoted();
                int startOffset = attr.valueOffset() + (isQuoted ? 1 : 0) + scanner.match().start();
                int endOffset = attr.valueOffset() + (isQuoted ? 1 : 0) + scanner.match().end();
                OffsetRange astRange = new OffsetRange(startOffset, endOffset);
                OffsetRange documentRange = new OffsetRange(this.getSnapshot().getOriginalOffset(startOffset), this.getSnapshot().getOriginalOffset(endOffset));
                Entry e = new Entry(className, astRange, documentRange);
                this.cssClasses.computeIfAbsent(className, s -> new ArrayList()).add(e);
            }
        }
    }

    private void handleCloseTag(CloseTag closeTag) {
        this.handleEmbeddedCssSectionEnd(closeTag);
    }

    private void handleEmbeddedCssSectionStart(OpenTag tnode) {
        if (LexerUtils.equals((CharSequence)STYLE_TAG_NAME, (CharSequence)tnode.name(), (boolean)true, (boolean)true) && !tnode.isEmpty()) {
            this.embedded_css_section_start = tnode.to();
        }
    }

    private void handleEmbeddedCssSectionEnd(CloseTag closeTag) {
        if (this.embedded_css_section_start == -1) {
            return;
        }
        int embedded_css_section_end = closeTag.from();
        if (this.embedded_css_section_start > embedded_css_section_end) {
            this.dumpIssue212445DebugInfo(this.embedded_css_section_start);
        }
        this.embeddedCssSections.add(new OffsetRange(this.embedded_css_section_start, embedded_css_section_end));
        this.embedded_css_section_start = -1;
    }

    private void dumpIssue212445DebugInfo(int from) {
        StringBuilder msg = new StringBuilder();
        msg.append("A bug #212445 just happended for source text \"");
        CharSequence source = this.getSnapshot().getText();
        CharSequence sample = source.subSequence(Math.max(0, from - 50), Math.min(source.length(), from + 50));
        msg.append(sample);
        msg.append("\". ");
        msg.append("Please report a new bug or reopen the existing issue #212445 and attach this exception + ideally the whole file \"");
        FileObject file = this.getSnapshot().getSource().getFileObject();
        msg.append(file == null ? "???" : file.getPath());
        msg.append("\" there. Thank you for your help!");
        throw new IllegalStateException(msg.toString());
    }

    private void handleReference(OpenTag tnode) {
        Map<String, ValueCompletion<HtmlCompletionItem>> completions = AttrValuesCompletion.getSupportsForTag(tnode.name().toString());
        if (completions != null) {
            for (Attribute attr : tnode.attributes()) {
                CharSequence unquotedValue;
                ValueCompletion<HtmlCompletionItem> avc = completions.get(attr.name().toString());
                if (AttrValuesCompletion.FILE_NAME_SUPPORT != avc || (unquotedValue = attr.unquotedValue()) == null || unquotedValue.length() <= 0) continue;
                boolean isQuoted = attr.isValueQuoted();
                int offset = attr.valueOffset() + (isQuoted ? 1 : 0);
                this.references.add(this.createFileReferenceEntry(unquotedValue.toString(), new OffsetRange(offset, offset + unquotedValue.length()), tnode.name().toString(), attr.name().toString()));
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(":");
        for (HtmlLinkEntry c : this.references) {
            buf.append(" references=");
            buf.append(c);
            buf.append(',');
        }
        return buf.toString();
    }

    private HtmlLinkEntry createFileReferenceEntry(String name, OffsetRange range, String tagName, String attributeName) {
        int qmIndex = name.indexOf("?");
        if (qmIndex >= 0) {
            range = new OffsetRange(range.getStart(), range.getEnd() - (name.length() - qmIndex));
            name = name.substring(0, qmIndex);
        }
        int documentFrom = this.getSnapshot().getOriginalOffset(range.getStart());
        int documentTo = this.getSnapshot().getOriginalOffset(range.getEnd());
        OffsetRange documentRange = null;
        if (documentFrom == -1 || documentTo == -1) {
            if (LOG) {
                LOGGER.log(Level.FINER, "Ast offset range {0}, text=''{1}'',  cannot be properly mapped to source offset range: [{2},{3}] in file {4}", new Object[]{range.toString(), this.getSnapshot().getText().subSequence(range.getStart(), range.getEnd()), documentFrom, documentTo, this.getFileObject().getPath()});
            }
        } else {
            documentRange = new OffsetRange(documentFrom, documentTo);
        }
        return new HtmlLinkEntry(this.getFileObject(), name, range, documentRange, tagName, attributeName);
    }
}

