/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sun.source.util.TreePath;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ShowDocumentParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolLocation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.csl.api.IndexSearcher;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodFinder;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.debugging.attach.AttachConfigurations;
import org.netbeans.modules.java.lsp.server.debugging.attach.AttachNativeConfigurations;
import org.netbeans.modules.java.lsp.server.project.LspProjectInfo;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.LaunchConfigurationCompletion;
import org.netbeans.modules.java.lsp.server.protocol.LspTemplateUI;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.OptionsExportModel;
import org.netbeans.modules.java.lsp.server.protocol.ProjectActionParams;
import org.netbeans.modules.java.lsp.server.protocol.TestProgressParams;
import org.netbeans.modules.java.lsp.server.protocol.TestSuiteInfo;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.ui.JavaSymbolProvider;
import org.netbeans.modules.java.source.ui.JavaTypeProvider;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public final class WorkspaceServiceImpl
implements WorkspaceService,
LanguageClientAware {
    private static final Logger LOG = Logger.getLogger(WorkspaceServiceImpl.class.getName());
    private static final RequestProcessor WORKER = new RequestProcessor(WorkspaceServiceImpl.class.getName(), 1, false, false);
    private static final RequestProcessor PROJECT_WORKER = new RequestProcessor(WorkspaceServiceImpl.class.getName(), 5, false, false);
    private final Gson gson = new Gson();
    private final LspServerState server;
    private NbCodeLanguageClient client;
    private final AtomicReference<BiConsumer<FileObject, Collection<TestMethodController.TestMethod>>> testMethodsListener = new AtomicReference();
    private final AtomicReference<PropertyChangeListener> openProjectsListener = new AtomicReference();
    private static final String[] SOURCE_TYPES = new String[]{"java", "groovy"};
    private static final Position NO_POS = new Position(0, 0);
    private static final Range NO_RANGE = new Range(NO_POS, NO_POS);
    private static final String SOURCE_FOR = "sourceFor:";
    private static final String INIT = "<init>";

    WorkspaceServiceImpl(LspServerState server) {
        this.server = server;
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        String command;
        switch (command = params.getCommand()) {
            case "graalvm.pause.script": {
                ActionsManager am = DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
                am.doAction((Object)"pauseInGraalScript");
                return CompletableFuture.completedFuture(true);
            }
            case "java.new.from.template": {
                return LspTemplateUI.createFromTemplate("Templates", this.client, params);
            }
            case "java.new.project": {
                return LspTemplateUI.createProject("Templates/Project", this.client, params);
            }
            case "nbls.build.workspace": {
                CommandProgress progressOfCompilation = new CommandProgress();
                Lookup ctx = Lookups.singleton((Object)((Object)progressOfCompilation));
                for (Project prj : this.server.openedProjects().getNow(OpenProjects.getDefault().getOpenProjects())) {
                    ActionProvider ap = (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
                    if (ap == null || !ap.isActionEnabled("build", Lookup.EMPTY)) continue;
                    ap.invokeAction("rebuild", ctx);
                }
                progressOfCompilation.checkStatus();
                return progressOfCompilation.getFinishFuture();
            }
            case "java.project.run.action": {
                ArrayList<FileObject> targets = new ArrayList<FileObject>();
                ProjectActionParams actionParams = (ProjectActionParams)this.gson.fromJson(this.gson.toJson(params.getArguments().get(0)), ProjectActionParams.class);
                String actionName = actionParams.getAction();
                String configName = actionParams.getConfiguration();
                boolean acceptDefault = actionParams.getFallbackDefault() == Boolean.TRUE;
                for (int i = 1; i < params.getArguments().size(); ++i) {
                    FileObject file;
                    JsonElement item = (JsonElement)this.gson.fromJson(this.gson.toJson(params.getArguments().get(i)), JsonElement.class);
                    if (!item.isJsonPrimitive()) continue;
                    String uri = item.getAsString();
                    try {
                        file = URLMapper.findFileObject((URL)new URL(uri));
                    }
                    catch (MalformedURLException ex2) {
                        continue;
                    }
                    targets.add(file);
                }
                return this.server.asyncOpenSelectedProjects(targets, false).thenCompose(owners -> {
                    LinkedHashMap<Project, List> items = new LinkedHashMap<Project, List>();
                    for (int i = 0; i < ((Project[])owners).length; ++i) {
                        items.computeIfAbsent(owners[i], p -> new ArrayList()).add((FileObject)targets.get(i));
                    }
                    CommandProgress progressOfCompilation = new CommandProgress();
                    boolean someStarted = false;
                    boolean configNotFound = false;
                    for (Project prj : items.keySet()) {
                        ProjectConfigurationProvider pcp;
                        ArrayList<Object> ctxObjects = new ArrayList<Object>();
                        ctxObjects.add((Object)progressOfCompilation);
                        ctxObjects.addAll((Collection)items.get(prj));
                        if (!StringUtils.isBlank((CharSequence)configName) && (pcp = (ProjectConfigurationProvider)prj.getLookup().lookup(ProjectConfigurationProvider.class)) != null) {
                            Optional<ProjectConfiguration> cfg = pcp.getConfigurations().stream().filter(c -> c.getDisplayName().equals(configName)).findAny();
                            if (cfg.isPresent()) {
                                ctxObjects.add(cfg);
                            } else if (!acceptDefault) {
                                configNotFound = true;
                                continue;
                            }
                        }
                        Lookup ctx = Lookups.fixed((Object[])ctxObjects.toArray(new Object[ctxObjects.size()]));
                        ActionProvider ap = (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
                        if (ap == null || !ap.isActionEnabled(actionName, ctx)) continue;
                        ap.invokeAction(actionName, ctx);
                        someStarted = true;
                    }
                    if (!configNotFound || !someStarted) {
                        return CompletableFuture.completedFuture(false);
                    }
                    boolean cfgNotFound = configNotFound;
                    progressOfCompilation.checkStatus();
                    return progressOfCompilation.getFinishFuture().thenApply(b -> b == Boolean.TRUE && cfgNotFound);
                });
            }
            case "nbls.clean.workspace": {
                CommandProgress progressOfCompilation = new CommandProgress();
                Lookup ctx = Lookups.singleton((Object)((Object)progressOfCompilation));
                for (Project prj : this.server.openedProjects().getNow(OpenProjects.getDefault().getOpenProjects())) {
                    ActionProvider ap = (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
                    if (ap == null || !ap.isActionEnabled("clean", Lookup.EMPTY)) continue;
                    ap.invokeAction("clean", ctx);
                }
                progressOfCompilation.checkStatus();
                return progressOfCompilation.getFinishFuture();
            }
            case "java.get.project.source.roots": {
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                String type = params.getArguments().size() > 1 ? ((JsonPrimitive)params.getArguments().get(1)).getAsString() : "java";
                return this.getSourceRoots(uri, type).thenApply(roots -> roots.stream().map(root -> Utils.toUri(root)).collect(Collectors.toList()));
            }
            case "java.get.project.classpath": {
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                ClasspathInfo.PathKind kind = params.getArguments().size() > 1 ? ClasspathInfo.PathKind.valueOf((String)((JsonPrimitive)params.getArguments().get(1)).getAsString()) : ClasspathInfo.PathKind.COMPILE;
                boolean preferSources = params.getArguments().size() > 2 ? ((JsonPrimitive)params.getArguments().get(2)).getAsBoolean() : false;
                return this.getSourceRoots(uri, "java").thenApply(roots -> {
                    HashSet<FileObject> cpRoots = new HashSet<FileObject>();
                    for (FileObject root : roots) {
                        for (FileObject cpRoot : ClasspathInfo.create((FileObject)root).getClassPath(kind).getRoots()) {
                            FileObject[] srcRoots;
                            FileObject[] fileObjectArray = srcRoots = preferSources ? SourceForBinaryQuery.findSourceRoots((URL)cpRoot.toURL()).getRoots() : null;
                            if (srcRoots != null && srcRoots.length > 0) {
                                for (FileObject srcRoot : srcRoots) {
                                    cpRoots.add(srcRoot);
                                }
                                continue;
                            }
                            cpRoots.add(cpRoot);
                        }
                    }
                    return cpRoots.stream().map(fo -> Utils.toUri(fo)).collect(Collectors.toList());
                });
            }
            case "java.get.project.packages": {
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                boolean srcOnly = params.getArguments().size() > 1 ? ((JsonPrimitive)params.getArguments().get(1)).getAsBoolean() : false;
                return this.getSourceRoots(uri, "java").thenCompose(roots -> {
                    CompletableFuture future = new CompletableFuture();
                    JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY), (FileObject[])new FileObject[0]);
                    try {
                        js.runWhenScanFinished(controller -> {
                            HashSet packages = new HashSet();
                            EnumSet<ClassIndex.SearchScope> scope = srcOnly ? EnumSet.of(ClassIndex.SearchScope.SOURCE) : EnumSet.allOf(ClassIndex.SearchScope.class);
                            for (FileObject root : roots) {
                                packages.addAll(ClasspathInfo.create((FileObject)root).getClassIndex().getPackageNames("", false, scope));
                            }
                            ArrayList ret = new ArrayList(packages);
                            Collections.sort(ret);
                            future.complete(ret);
                        }, true);
                    }
                    catch (IOException ex) {
                        future.completeExceptionally(ex);
                    }
                    return future;
                });
            }
            case "java.load.workspace.tests": {
                FileObject file;
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                try {
                    file = URLMapper.findFileObject((URL)new URL(uri));
                }
                catch (MalformedURLException ex3) {
                    Exceptions.printStackTrace((Throwable)ex3);
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                if (file == null) {
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                return ((CompletableFuture)this.server.asyncOpenFileOwner(file).thenCompose(this::getTestRoots)).thenCompose(testRoots -> {
                    BiFunction<FileObject, Collection, Collection> f = (fo, methods) -> {
                        String url = Utils.toUri(fo);
                        LinkedHashMap<String, TestSuiteInfo> suite2infos = new LinkedHashMap<String, TestSuiteInfo>();
                        for (TestMethodController.TestMethod testMethod : methods) {
                            TestSuiteInfo suite = suite2infos.computeIfAbsent(testMethod.getTestClassName(), name -> {
                                Position pos = testMethod.getTestClassPosition() != null ? Utils.createPosition(fo, testMethod.getTestClassPosition().getOffset()) : null;
                                return new TestSuiteInfo((String)name, url, pos != null ? new Range(pos, pos) : null, "loaded", (List<TestSuiteInfo.TestCaseInfo>)new ArrayList<TestSuiteInfo.TestCaseInfo>());
                            });
                            String id = testMethod.getTestClassName() + ':' + testMethod.method().getMethodName();
                            Position startPos = testMethod.start() != null ? Utils.createPosition(fo, testMethod.start().getOffset()) : null;
                            Position endPos = testMethod.end() != null ? Utils.createPosition(fo, testMethod.end().getOffset()) : startPos;
                            Range range = startPos != null ? new Range(startPos, endPos) : null;
                            suite.getTests().add(new TestSuiteInfo.TestCaseInfo(id, testMethod.method().getMethodName(), url, range, "loaded", null));
                        }
                        return suite2infos.values();
                    };
                    this.testMethodsListener.compareAndSet(null, (fo, methods) -> {
                        try {
                            for (TestSuiteInfo testSuiteInfo : (Collection)f.apply((FileObject)fo, (Collection)methods)) {
                                this.client.notifyTestProgress(new TestProgressParams(Utils.toUri(fo), testSuiteInfo));
                            }
                        }
                        catch (Exception e) {
                            Logger.getLogger(WorkspaceServiceImpl.class.getName()).severe(e.getMessage());
                            Exceptions.printStackTrace((Throwable)e);
                            this.testMethodsListener.set(null);
                        }
                    });
                    if (this.openProjectsListener.compareAndSet(null, evt -> {
                        if ("openProjects".equals(evt.getPropertyName())) {
                            JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY), (FileObject[])new FileObject[0]);
                            try {
                                js.runWhenScanFinished(controller -> {
                                    List<Project> old = Arrays.asList((Project[])evt.getOldValue());
                                    for (Project p : (Project[])evt.getNewValue()) {
                                        if (old.contains(p)) continue;
                                        this.getTestRoots(p).thenAccept(tr -> {
                                            for (Map.Entry entry : TestMethodFinder.findTestMethods((Iterable)tr, this.testMethodsListener.get()).entrySet()) {
                                                for (TestSuiteInfo tsi : (Collection)f.apply((FileObject)entry.getKey(), (Collection)entry.getValue())) {
                                                    this.client.notifyTestProgress(new TestProgressParams(Utils.toUri((FileObject)entry.getKey()), tsi));
                                                }
                                            }
                                        });
                                    }
                                }, true);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    })) {
                        OpenProjects.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.openProjectsListener.get(), (Object)OpenProjects.getDefault()));
                    }
                    CompletableFuture future = new CompletableFuture();
                    JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY), (FileObject[])new FileObject[0]);
                    try {
                        js.runWhenScanFinished(controller -> {
                            Map testMethods = TestMethodFinder.findTestMethods((Iterable)testRoots, this.testMethodsListener.get());
                            ArrayList suites = new ArrayList(testMethods.size());
                            for (Map.Entry entry : testMethods.entrySet()) {
                                suites.addAll((Collection)f.apply((FileObject)entry.getKey(), (Collection)entry.getValue()));
                            }
                            future.complete(suites);
                        }, true);
                    }
                    catch (IOException ex) {
                        future.completeExceptionally(ex);
                    }
                    return future;
                });
            }
            case "java.super.implementation": {
                String uri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                Position pos = (Position)this.gson.fromJson(this.gson.toJson(params.getArguments().get(1)), Position.class);
                return ((TextDocumentServiceImpl)this.server.getTextDocumentService()).superImplementations(uri, pos);
            }
            case "java.source.for": {
                CompletableFuture<Object> result = new CompletableFuture<Object>();
                try {
                    String sourceUri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                    if (sourceUri == null || !sourceUri.startsWith(SOURCE_FOR)) {
                        throw new IllegalArgumentException("Invalid uri: " + sourceUri);
                    }
                    sourceUri = URLDecoder.decode(sourceUri.substring(SOURCE_FOR.length()), StandardCharsets.UTF_8.toString());
                    int qIdx = sourceUri.lastIndexOf(63);
                    int hIdx = sourceUri.lastIndexOf(35);
                    if (qIdx < 0 || hIdx < 0 || hIdx <= qIdx) {
                        throw new IllegalArgumentException("Invalid uri: " + sourceUri);
                    }
                    String rootUri = sourceUri.substring(0, qIdx);
                    FileObject root = URLMapper.findFileObject((URL)URI.create(rootUri).toURL());
                    if (root == null) {
                        throw new IllegalStateException("Unable to find root: " + rootUri);
                    }
                    ElementHandle typeHandle = ElementHandleAccessor.getInstance().create(ElementKind.valueOf(sourceUri.substring(qIdx + 1, hIdx)), new String[]{sourceUri.substring(hIdx + 1)});
                    CompletableFuture location = ElementOpen.getLocation((ClasspathInfo)ClasspathInfo.create((FileObject)root), (ElementHandle)typeHandle, (String)(typeHandle.getQualifiedName().replace('.', '/') + ".class"));
                    ((CompletableFuture)location.exceptionally(ex -> {
                        result.completeExceptionally((Throwable)ex);
                        return null;
                    })).thenAccept(loc -> {
                        if (loc != null) {
                            ShowDocumentParams sdp = new ShowDocumentParams(Utils.toUri(loc.getFileObject()));
                            Position position = Utils.createPosition(loc.getFileObject(), loc.getStartOffset());
                            sdp.setSelection(new Range(position, position));
                            this.client.showDocument(sdp).thenAccept(res -> {
                                if (res.isSuccess()) {
                                    result.complete(null);
                                } else {
                                    result.completeExceptionally(new IllegalStateException("Cannot open source for: " + typeHandle.getQualifiedName()));
                                }
                            });
                        } else if (!result.isCompletedExceptionally()) {
                            result.completeExceptionally(new IllegalStateException("Cannot find source for: " + typeHandle.getQualifiedName()));
                        }
                    });
                }
                catch (Throwable t) {
                    result.completeExceptionally(t);
                }
                return result;
            }
            case "java.project.configurations": {
                FileObject file;
                String fileUri = ((JsonPrimitive)params.getArguments().get(0)).getAsString();
                try {
                    file = URLMapper.findFileObject((URL)new URL(fileUri));
                }
                catch (MalformedURLException ex4) {
                    Exceptions.printStackTrace((Throwable)ex4);
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                return this.findProjectConfigurations(file);
            }
            case "java.attachDebugger.configurations": {
                return AttachConfigurations.findConnectors();
            }
            case "java.attachDebugger.pickProcess": {
                return AttachConfigurations.findProcessAttachTo(this.client);
            }
            case "nativeImage.attachDebugger.pickProcess": {
                return AttachNativeConfigurations.findProcessAttachTo(this.client);
            }
            case "java.project.configuration.completion": {
                List<CompletableFuture> completionFutures;
                List arguments = params.getArguments();
                Collection configurations = Lookup.getDefault().lookupAll(LaunchConfigurationCompletion.class);
                String configUri = ((JsonPrimitive)arguments.get(0)).getAsString();
                Supplier<CompletableFuture> projectSupplier = () -> {
                    FileObject file;
                    try {
                        file = URLMapper.findFileObject((URL)new URL(configUri));
                    }
                    catch (MalformedURLException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        return CompletableFuture.completedFuture(null);
                    }
                    return this.server.asyncOpenFileOwner(file);
                };
                switch (arguments.size()) {
                    case 1: {
                        completionFutures = configurations.stream().map(c -> c.configurations(projectSupplier)).collect(Collectors.toList());
                        break;
                    }
                    case 2: {
                        Map<String, Object> attributes = WorkspaceServiceImpl.attributesMap((JsonObject)arguments.get(1));
                        completionFutures = configurations.stream().map(c -> c.attributes(projectSupplier, attributes)).collect(Collectors.toList());
                        break;
                    }
                    case 3: {
                        Map<String, Object> attributes = WorkspaceServiceImpl.attributesMap((JsonObject)arguments.get(1));
                        String attribute = ((JsonPrimitive)arguments.get(2)).getAsString();
                        completionFutures = configurations.stream().map(c -> c.attributeValues(projectSupplier, attributes, attribute)).collect(Collectors.toList());
                        break;
                    }
                    default: {
                        StringBuilder classes = new StringBuilder();
                        for (int i = 0; i < arguments.size(); ++i) {
                            classes.append(arguments.get(i).getClass().toString());
                        }
                        throw new IllegalStateException("Wrong arguments(" + arguments.size() + "): " + arguments + ", classes = " + classes);
                    }
                }
                CompletionStage joinedFuture = CompletableFuture.allOf(completionFutures.toArray(new CompletableFuture[0])).thenApply(avoid -> completionFutures.stream().flatMap(c -> ((List)c.join()).stream()).collect(Collectors.toList()));
                return joinedFuture;
            }
            case "java.project.resolveProjectProblems": {
                CompletableFuture<Object> result = new CompletableFuture<Object>();
                List arguments = params.getArguments();
                if (!arguments.isEmpty()) {
                    Collection problems;
                    ProjectProblemsProvider ppp;
                    FileObject file;
                    String fileStr = ((JsonPrimitive)arguments.get(0)).getAsString();
                    try {
                        file = URLMapper.findFileObject((URL)URI.create(fileStr).toURL());
                    }
                    catch (MalformedURLException ex5) {
                        result.completeExceptionally(ex5);
                        return result;
                    }
                    Project project = FileOwnerQuery.getOwner((FileObject)file);
                    if (project != null && (ppp = (ProjectProblemsProvider)project.getLookup().lookup(ProjectProblemsProvider.class)) != null && !(problems = ppp.getProblems()).isEmpty()) {
                        WORKER.post(() -> {
                            LinkedList<Pair> resolvers = new LinkedList<Pair>();
                            for (ProjectProblemsProvider.ProjectProblem problem : ppp.getProblems()) {
                                if (problem.isResolvable()) {
                                    resolvers.add(Pair.of((Object)problem, (Object)problem.resolve()));
                                    continue;
                                }
                                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)problem.getDescription(), 0));
                            }
                            if (!resolvers.isEmpty()) {
                                for (Pair resolver : resolvers) {
                                    try {
                                        String message;
                                        if (((ProjectProblemsProvider.Result)((Future)resolver.second()).get()).isResolved() || (message = ((ProjectProblemsProvider.Result)((Future)resolver.second()).get()).getMessage()) == null) continue;
                                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                                    }
                                    catch (ExecutionException ex) {
                                        result.completeExceptionally(ex.getCause());
                                    }
                                    catch (InterruptedException ex) {
                                        result.complete(false);
                                        break;
                                    }
                                }
                            }
                            if (!result.isDone()) {
                                result.complete(true);
                            }
                        });
                    }
                } else {
                    result.completeExceptionally(new IllegalStateException("Expecting file URL as an argument to " + command));
                }
                return result;
            }
            case "java.clear.project.caches": {
                ProjectManager.getDefault().clearNonProjectCache();
                ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                CompletableFuture<Object> result = new CompletableFuture<Object>();
                try {
                    Class<?> queryImpl = Class.forName("org.netbeans.modules.projectapi.SimpleFileOwnerQueryImplementation", true, loader);
                    Method resetMethod = queryImpl.getMethod("reset", new Class[0]);
                    resetMethod.invoke(null, new Object[0]);
                    result.complete(true);
                }
                catch (ReflectiveOperationException ex6) {
                    result.completeExceptionally(ex6);
                }
                for (FileObject f : this.server.getAcceptedWorkspaceFolders()) {
                    f.refresh();
                }
                for (Project p : OpenProjects.getDefault().getOpenProjects()) {
                    p.getProjectDirectory().refresh();
                }
                return result;
            }
            case "nbls.project.info": {
                Object a2;
                CompletableFuture<Object> result = new CompletableFuture<Object>();
                List arguments = params.getArguments();
                if (arguments.size() < 1) {
                    result.completeExceptionally(new IllegalArgumentException("Expecting URL or URL[] as an argument to " + command));
                    return result;
                }
                Object o = arguments.get(0);
                URL[] locations = null;
                if (o instanceof JsonArray) {
                    ArrayList locs = new ArrayList();
                    JsonArray a = (JsonArray)o;
                    a.forEach(e -> {
                        if (e instanceof JsonPrimitive) {
                            String s = ((JsonPrimitive)e).getAsString();
                            try {
                                locs.add(new URL(s));
                            }
                            catch (MalformedURLException ex) {
                                throw new IllegalArgumentException("Illegal location: " + s);
                            }
                        }
                    });
                    locations = locs.toArray(new URL[0]);
                } else if (o instanceof JsonPrimitive) {
                    String s = ((JsonPrimitive)o).getAsString();
                    try {
                        locations = new URL[]{new URL(s)};
                    }
                    catch (MalformedURLException ex7) {
                        throw new IllegalArgumentException("Illegal location: " + s);
                    }
                }
                if (locations == null || locations.length == 0) {
                    result.completeExceptionally(new IllegalArgumentException("Expecting URL or URL[] as an argument to " + command));
                    return result;
                }
                boolean projectStructure = false;
                boolean actions = false;
                boolean recursive = false;
                if (arguments.size() > 1 && (a2 = arguments.get(1)) instanceof JsonObject) {
                    JsonObject options = (JsonObject)a2;
                    projectStructure = WorkspaceServiceImpl.getOption(options, "projectStructure", false);
                    actions = WorkspaceServiceImpl.getOption(options, "actions", false);
                    recursive = WorkspaceServiceImpl.getOption(options, "recursive", false);
                }
                return new ProjectInfoWorker(locations, projectStructure, recursive, actions).process();
            }
        }
        for (CodeActionsProvider codeActionsProvider : Lookup.getDefault().lookupAll(CodeActionsProvider.class)) {
            if (!codeActionsProvider.getCommands().contains(command)) continue;
            return codeActionsProvider.processCommand(this.client, command, params.getArguments());
        }
        throw new UnsupportedOperationException("Command not supported: " + params.getCommand());
    }

    private static boolean getOption(JsonObject opts, String member, boolean def) {
        if (!opts.has(member)) {
            return def;
        }
        JsonElement o = opts.get(member);
        if (!(o instanceof JsonPrimitive)) {
            return false;
        }
        return ((JsonPrimitive)o).getAsBoolean();
    }

    private static Map<String, Object> attributesMap(JsonObject json) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : json.entrySet()) {
            JsonPrimitive jp = (JsonPrimitive)entry.getValue();
            Boolean value = jp.isBoolean() ? Boolean.valueOf(jp.getAsBoolean()) : (jp.isNumber() ? jp.getAsNumber() : jp.getAsString());
            map.put((String)entry.getKey(), value);
        }
        return map;
    }

    private CompletableFuture<Object> findProjectConfigurations(FileObject ownedFile) {
        return this.server.asyncOpenFileOwner(ownedFile).thenApply(p -> {
            if (p == null) {
                return Collections.emptyList();
            }
            ProjectConfigurationProvider provider = (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class);
            ArrayList<String> configDispNames = new ArrayList<String>();
            if (provider != null) {
                for (ProjectConfiguration c : provider.getConfigurations()) {
                    configDispNames.add(c.getDisplayName());
                }
            }
            return configDispNames;
        });
    }

    private CompletableFuture<List<FileObject>> getSourceRoots(String uri, String type) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(uri));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        if (file == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.server.asyncOpenFileOwner(file).thenApply(project -> {
            if (project != null) {
                ArrayList<FileObject> roots = new ArrayList<FileObject>();
                for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups(type)) {
                    roots.add(sourceGroup.getRootFolder());
                }
                return roots;
            }
            return Collections.emptyList();
        });
    }

    private CompletableFuture<Set<FileObject>> getTestRoots(Project prj) {
        HashSet<FileObject> testRoots = new HashSet<FileObject>();
        List contained = null;
        if (prj != null) {
            for (String sourceType : SOURCE_TYPES) {
                for (SourceGroup sg : ProjectUtils.getSources((Project)prj).getSourceGroups(sourceType)) {
                    if (!this.isTestGroup(sg)) continue;
                    testRoots.add(sg.getRootFolder());
                }
            }
            Set containedProjects = ProjectUtils.getContainedProjects((Project)prj, (boolean)true);
            if (containedProjects != null) {
                contained = containedProjects.stream().map(p -> p.getProjectDirectory()).collect(Collectors.toList());
            }
        }
        return this.server.asyncOpenSelectedProjects(contained).thenApply(projects -> {
            for (Project project : projects) {
                for (String sourceType : SOURCE_TYPES) {
                    for (SourceGroup sg : ProjectUtils.getSources((Project)project).getSourceGroups(sourceType)) {
                        if (!this.isTestGroup(sg)) continue;
                        testRoots.add(sg.getRootFolder());
                    }
                }
            }
            return testRoots;
        });
    }

    private boolean isTestGroup(SourceGroup sg) {
        return UnitTestForSourceQuery.findSources((FileObject)sg.getRootFolder()).length > 0;
    }

    public CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> symbol(WorkspaceSymbolParams params) {
        if (this.server.openedProjects().getNow(null) == null) {
            return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
        }
        String query = params.getQuery();
        if (query.isEmpty()) {
            return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
        }
        System.err.println("query=" + query);
        boolean exact = false;
        if (query.endsWith(" ")) {
            query = query.substring(0, query.length() - 1);
            exact = true;
        }
        String queryFin = query;
        boolean exactFin = exact;
        final AtomicBoolean cancel = new AtomicBoolean();
        CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> result = new CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                cancel.set(mayInterruptIfRunning);
                return super.cancel(mayInterruptIfRunning);
            }
        };
        WORKER.post(() -> {
            try {
                final ArrayList<WorkspaceSymbol> symbols = new ArrayList<WorkspaceSymbol>();
                if (this.client.getNbCodeCapabilities().wantsJavaSupport()) {
                    SearchType searchType = WorkspaceServiceImpl.getSearchType(queryFin, exactFin, false, null, null);
                    Collection providers = Lookup.getDefault().lookupAll(IndexSearcher.class);
                    if (!providers.isEmpty()) {
                        for (IndexSearcher provider : providers) {
                            Set descriptors = provider.getSymbols(null, queryFin, Utils.searchType2QueryKind(searchType), null);
                            for (IndexSearcher.Descriptor desc : descriptors) {
                                FileObject fo = desc.getFileObject();
                                org.netbeans.modules.csl.api.ElementHandle element = desc.getElement();
                                if (fo == null) continue;
                                Position startPos = Utils.createPosition(fo, desc.getOffset());
                                Position endPos = Utils.createPosition(fo, desc.getOffset() + desc.getSimpleName().length());
                                WorkspaceSymbol symbol = new WorkspaceSymbol(desc.getSimpleName(), Utils.cslElementKind2SymbolKind(element.getKind()), Either.forLeft((Object)new Location(Utils.toUri(fo), new Range(startPos, endPos))), desc.getContextName());
                                symbols.add(symbol);
                            }
                        }
                    }
                    JavaSymbolProvider.ResultHandler symbolHandler = new JavaSymbolProvider.ResultHandler(){
                        private Map type2Idents;

                        public void setHighlightText(String text) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runRoot(FileObject root, ClassIndexImpl ci, JavaSymbolProvider.ResultHandler.Exec exec) throws IOException, InterruptedException {
                            ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)root);
                            try {
                                this.type2Idents = new HashMap();
                                exec.run();
                                HashMap<FileObject, Map> sources = new HashMap<FileObject, Map>();
                                for (Map.Entry e : this.type2Idents.entrySet()) {
                                    FileObject sourceFile = SourceUtils.getFile((ElementHandle)((ElementHandle)e.getKey()), (ClasspathInfo)cpInfo);
                                    sources.computeIfAbsent(sourceFile, s -> new HashMap()).put((ElementHandle)e.getKey(), (List)e.getValue());
                                }
                                if (!sources.isEmpty()) {
                                    JavaSource.create((ClasspathInfo)cpInfo, sources.keySet()).runUserActionTask(cc -> {
                                        if (JavaSource.Phase.ELEMENTS_RESOLVED.compareTo((Enum)cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED)) > 0) {
                                            return;
                                        }
                                        for (Map.Entry e : ((Map)sources.get(cc.getFileObject())).entrySet()) {
                                            TypeElement te = (TypeElement)((ElementHandle)e.getKey()).resolve((CompilationInfo)cc);
                                            if (te == null) continue;
                                            for (String ident : (List)e.getValue()) {
                                                TreePath path;
                                                if (ident.equals(WorkspaceServiceImpl.getSimpleName(te, null, false)) && (path = cc.getTrees().getPath(te)) != null) {
                                                    String string = te.getSimpleName().toString();
                                                    ElementKind kind = te.getKind();
                                                    if (!kind.isClass() && !kind.isInterface()) {
                                                        WorkspaceSymbol symbol = new WorkspaceSymbol(string, Utils.elementKind2SymbolKind(kind), Either.forLeft((Object)WorkspaceServiceImpl.this.tree2Location((CompilationInfo)cc, path)), te.getQualifiedName().toString());
                                                        symbols.add(symbol);
                                                    }
                                                }
                                                for (Element element : te.getEnclosedElements()) {
                                                    TreePath path2;
                                                    if (!ident.equals(WorkspaceServiceImpl.getSimpleName(element, te, false)) || (path2 = cc.getTrees().getPath(element)) == null) continue;
                                                    Pair name = JavaSymbolProvider.getDisplayName((Element)element, (Element)te);
                                                    String symbolName = (String)name.first() + (name.second() != null ? (String)name.second() : "");
                                                    ElementKind kind = element.getKind();
                                                    if (kind.isClass() || kind.isInterface()) continue;
                                                    WorkspaceSymbol symbol = new WorkspaceSymbol(symbolName, Utils.elementKind2SymbolKind(kind), Either.forLeft((Object)WorkspaceServiceImpl.this.tree2Location((CompilationInfo)cc, path2)), te.getQualifiedName().toString());
                                                    symbols.add(symbol);
                                                }
                                            }
                                        }
                                    }, true);
                                }
                            }
                            finally {
                                this.type2Idents = null;
                            }
                        }

                        public void handleResult(ElementHandle<TypeElement> owner, String ident, boolean caseSensitive) {
                            this.type2Idents.computeIfAbsent(owner, s -> new ArrayList()).add(ident);
                        }
                    };
                    JavaSymbolProvider.doComputeSymbols((SearchType)searchType, (String)queryFin, (JavaSymbolProvider.ResultHandler)symbolHandler, (boolean)true, (AtomicBoolean)cancel);
                    final ArrayList pairs = new ArrayList();
                    JavaTypeProvider.ResultHandler<Pair<ElementHandle<TypeElement>, FileObject>> typeHandler = new JavaTypeProvider.ResultHandler<Pair<ElementHandle<TypeElement>, FileObject>>(){
                        private FileObject root;

                        public void setMessage(String msg) {
                        }

                        public void setHighlightText(String text) {
                        }

                        public void pendingResult() {
                        }

                        public void runRoot(FileObject root, JavaTypeProvider.ResultHandler.Exec exec) throws IOException, InterruptedException {
                            this.root = root;
                            try {
                                exec.run();
                            }
                            finally {
                                this.root = null;
                            }
                        }

                        public Pair<ElementHandle<TypeElement>, FileObject> create(JavaTypeProvider.CacheItem cacheItem, ElementHandle<TypeElement> handle, String simpleName, String relativePath) {
                            return Pair.of(handle, (Object)this.root);
                        }

                        public void addResult(List<? extends Pair<ElementHandle<TypeElement>, FileObject>> types) {
                            pairs.addAll(types);
                        }
                    };
                    JavaTypeProvider.doComputeTypes((SearchType)searchType, (String)queryFin, (JavaTypeProvider.ResultHandler)typeHandler, (AtomicBoolean)cancel);
                    for (Pair pair : pairs) {
                        ElementHandle handle = (ElementHandle)pair.first();
                        String fqn = handle.getQualifiedName();
                        int idx = fqn.lastIndexOf(46);
                        String simpleName = idx < 0 ? fqn : fqn.substring(idx + 1);
                        String contextName = idx < 0 ? null : fqn.substring(0, idx);
                        String uri = URLEncoder.encode(((FileObject)pair.second()).toURI().toString() + '?' + handle.getKind().name() + '#' + handle.getBinaryName(), StandardCharsets.UTF_8.toString());
                        WorkspaceSymbol symbol = new WorkspaceSymbol(simpleName, Utils.elementKind2SymbolKind(handle.getKind()), Either.forRight((Object)new WorkspaceSymbolLocation(SOURCE_FOR + uri)), contextName);
                        symbols.add(symbol);
                    }
                }
                result.complete(Either.forRight(symbols));
            }
            catch (Throwable t) {
                result.completeExceptionally(t);
            }
        });
        return result;
    }

    private Location tree2Location(CompilationInfo info, TreePath path) {
        return new Location(Utils.toUri(info.getFileObject()), Utils.treeRange(info, path.getLeaf()));
    }

    public static int containsWildCard(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    public static boolean isAllUpper(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static SearchType getSearchType(@NonNull String text, boolean exact, boolean isCaseSensitive, @NullAllowed String camelCaseSeparator, @NullAllowed String camelCasePart) {
        int wildcard = WorkspaceServiceImpl.containsWildCard(text);
        if (exact) {
            return SearchType.EXACT_NAME;
        }
        if (wildcard != -1) {
            return isCaseSensitive ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP;
        }
        if (WorkspaceServiceImpl.isAllUpper(text) && text.length() > 1 || Queries.isCamelCase((String)text, (String)camelCaseSeparator, (String)camelCasePart)) {
            return isCaseSensitive ? SearchType.CAMEL_CASE : SearchType.CASE_INSENSITIVE_CAMEL_CASE;
        }
        return isCaseSensitive ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX;
    }

    @NonNull
    private static String getSimpleName(@NonNull Element element, @NullAllowed Element enclosingElement, boolean caseSensitive) {
        String result = element.getSimpleName().toString();
        if (enclosingElement != null && INIT.equals(result)) {
            result = enclosingElement.getSimpleName().toString();
        }
        if (!caseSensitive) {
            result = result.toLowerCase();
        }
        return result;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        this.server.openedProjects().thenAccept(projects -> {
            if (projects != null && ((Project[])projects).length > 0) {
                this.updateJavaFormatPreferences(projects[0].getProjectDirectory(), ((JsonObject)params.getSettings()).getAsJsonObject("netbeans").getAsJsonObject("format"));
                this.updateJavaImportPreferences(projects[0].getProjectDirectory(), ((JsonObject)params.getSettings()).getAsJsonObject("netbeans").getAsJsonObject("java").getAsJsonObject("imports"));
            }
        });
    }

    void updateJavaFormatPreferences(FileObject fo, JsonObject configuration) {
        block9: {
            if (configuration != null && this.client.getNbCodeCapabilities().wantsJavaSupport()) {
                String path;
                NbPreferences.Provider provider = (NbPreferences.Provider)Lookup.getDefault().lookup(NbPreferences.Provider.class);
                Preferences prefs = provider != null ? provider.preferencesRoot().node("de/funfried/netbeans/plugins/externalcodeformatter") : null;
                JsonPrimitive formatterPrimitive = configuration.getAsJsonPrimitive("codeFormatter");
                String formatter = formatterPrimitive != null ? formatterPrimitive.getAsString() : null;
                JsonPrimitive pathPrimitive = configuration.getAsJsonPrimitive("settingsPath");
                String string = path = pathPrimitive != null ? pathPrimitive.getAsString() : null;
                if (formatter == null || "NetBeans".equals(formatter)) {
                    if (prefs != null) {
                        prefs.put("enabledFormatter.JAVA", "netbeans-formatter");
                    }
                    Path p = path != null ? Paths.get(path, new String[0]) : null;
                    File file = p != null ? p.toFile() : null;
                    try {
                        if (file != null && file.exists() && file.canRead() && file.getName().endsWith(".zip")) {
                            OptionsExportModel.get().doImport(file);
                            break block9;
                        }
                        OptionsExportModel.get().clean();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else if (prefs != null) {
                    prefs.put("enabledFormatter.JAVA", formatter.toLowerCase(Locale.ENGLISH).concat("-java-formatter"));
                    if (path != null) {
                        prefs.put(formatter.toLowerCase(Locale.ENGLISH).concat("FormatterLocation"), path);
                    }
                }
            }
        }
    }

    void updateJavaImportPreferences(FileObject fo, JsonObject configuration) {
        Preferences prefs = CodeStylePreferences.get((FileObject)fo, (String)"text/x-java").getPreferences();
        if (prefs != null && configuration != null) {
            prefs.put("importGroupsOrder", String.join((CharSequence)";", (CharSequence[])this.gson.fromJson(configuration.get("groups"), String[].class)));
            prefs.putBoolean("allowConvertToStarImport", true);
            prefs.putInt("countForUsingStarImport", configuration.getAsJsonPrimitive("countForUsingStarImport").getAsInt());
            prefs.putBoolean("allowConvertToStaticStarImport", true);
            prefs.putInt("countForUsingStaticStarImport", configuration.getAsJsonPrimitive("countForUsingStaticStarImport").getAsInt());
        }
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        ArrayList<FileObject> refreshProjectFolders = new ArrayList<FileObject>();
        for (WorkspaceFolder wkspFolder : params.getEvent().getAdded()) {
            String uri = wkspFolder.getUri();
            try {
                FileObject f = Utils.fromUri(uri);
                if (f == null) continue;
                refreshProjectFolders.add(f);
            }
            catch (MalformedURLException ex) {
                LOG.fine("Workspace folder URI could not be converted into fileobject: {0}");
            }
        }
        if (!refreshProjectFolders.isEmpty()) {
            this.server.asyncOpenSelectedProjects(refreshProjectFolders, true).thenAccept(projects -> {
                if (((Project[])projects).length == 0) {
                    return;
                }
                ProjectInformation pi = ProjectUtils.getInformation((Project)projects[0]);
                String n = pi.getDisplayName();
                if (n == null) {
                    n = pi.getName();
                }
                if (n == null) {
                    n = projects[0].getProjectDirectory().getName();
                }
                String msg = ((Project[])projects).length == 1 ? Bundle.MSG_ProjectFolderInitializationComplete(n) : Bundle.MSG_ProjectFolderInitializationComplete2(n, ((Project[])projects).length);
                StatusDisplayer.getDefault().setStatusText(msg, 1000);
            });
        }
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams arg0) {
    }

    public void connect(LanguageClient client) {
        this.client = (NbCodeLanguageClient)client;
    }

    private static final class CommandProgress
    extends ActionProgress {
        private final CompletableFuture<Object> commandFinished = new CompletableFuture();
        private int running;
        private int success;
        private int failure;

        private CommandProgress() {
        }

        protected synchronized void started() {
            ++this.running;
            ((Object)((Object)this)).notify();
        }

        public synchronized void finished(boolean ok) {
            if (ok) {
                ++this.success;
            } else {
                ++this.failure;
            }
            this.checkStatus();
        }

        final synchronized void checkStatus() {
            if (this.running == 0) {
                try {
                    ((Object)((Object)this)).wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.running <= this.success + this.failure) {
                this.commandFinished.complete(this.failure == 0);
            }
        }

        CompletableFuture<Object> getFinishFuture() {
            return this.commandFinished;
        }
    }

    private class ProjectInfoWorker {
        final URL[] locations;
        final boolean projectStructure;
        final boolean recursive;
        final boolean actions;
        Map<FileObject, LspProjectInfo> infos = new HashMap<FileObject, LspProjectInfo>();
        Set<Project> toOpen = new HashSet<Project>();

        public ProjectInfoWorker(URL[] locations, boolean projectStructure, boolean recursive, boolean actions) {
            this.locations = locations;
            this.projectStructure = projectStructure;
            this.recursive = recursive;
            this.actions = actions;
        }

        public CompletableFuture<LspProjectInfo[]> process() {
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            for (URL u : this.locations) {
                FileObject f = URLMapper.findFileObject((URL)u);
                if (f == null) continue;
                files.add(f);
            }
            return WorkspaceServiceImpl.this.server.asyncOpenSelectedProjects(files, false).thenCompose(this::processProjects);
        }

        LspProjectInfo fillProjectInfo(Project p) {
            ActionProvider ap;
            LspProjectInfo info = this.infos.get(p.getProjectDirectory());
            if (info != null) {
                return info;
            }
            info = new LspProjectInfo();
            ProjectInformation pi = ProjectUtils.getInformation((Project)p);
            URL projectURL = URLMapper.findURL((FileObject)p.getProjectDirectory(), (int)1);
            if (projectURL != null) {
                try {
                    info.projectDirectory = projectURL.toURI();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            info.name = pi.getName();
            info.displayName = pi.getDisplayName();
            ProjectManager.Result r = ProjectManager.getDefault().isProject2(p.getProjectDirectory());
            info.projectType = r.getProjectType();
            if (this.actions && (ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class)) != null) {
                info.projectActionNames = ap.getSupportedActions();
            }
            if (this.projectStructure) {
                Set children = ProjectUtils.getContainedProjects((Project)p, (boolean)false);
                ArrayList<URI> subprojectDirs = new ArrayList<URI>();
                for (Project c : children) {
                    try {
                        subprojectDirs.add(URLMapper.findURL((FileObject)c.getProjectDirectory(), (int)1).toURI());
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                info.subprojects = subprojectDirs.toArray(new URI[subprojectDirs.size()]);
                Project root = ProjectUtils.rootOf((Project)p);
                if (root != null) {
                    try {
                        info.rootProject = URLMapper.findURL((FileObject)root.getProjectDirectory(), (int)1).toURI();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                if (this.recursive) {
                    this.toOpen.addAll(children);
                }
            }
            this.infos.put(p.getProjectDirectory(), info);
            return info;
        }

        CompletableFuture<LspProjectInfo[]> processProjects(Project[] prjs) {
            for (Project p : prjs) {
                this.fillProjectInfo(p);
            }
            if (this.toOpen.isEmpty()) {
                return this.finalizeInfos();
            }
            ArrayList<FileObject> dirs = new ArrayList<FileObject>(this.toOpen.size());
            for (Project p : this.toOpen) {
                dirs.add(p.getProjectDirectory());
            }
            this.toOpen.clear();
            return WorkspaceServiceImpl.this.server.asyncOpenSelectedProjects(dirs).thenCompose(this::processProjects);
        }

        CompletableFuture<LspProjectInfo[]> finalizeInfos() {
            ArrayList<LspProjectInfo> list = new ArrayList<LspProjectInfo>();
            for (URL u : this.locations) {
                FileObject f = URLMapper.findFileObject((URL)u);
                Project owner = FileOwnerQuery.getOwner((FileObject)f);
                if (owner != null) {
                    list.add(this.infos.remove(owner.getProjectDirectory()));
                    continue;
                }
                list.add(null);
            }
            list.addAll(this.infos.values());
            LspProjectInfo[] toArray = list.toArray(new LspProjectInfo[list.size()]);
            return CompletableFuture.completedFuture(toArray);
        }
    }
}

