/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.io.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeepOpenInputStream
extends FilterInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(KeepOpenInputStream.class);

    public KeepOpenInputStream(InputStream is) {
        super(is);
        if (!is.markSupported()) {
            throw new IllegalArgumentException(String.format("Stream '%s' does not support mark/reset, retries won't work", is.getClass().getName()));
        }
    }

    @Override
    public void close() throws IOException {
        LOG.debug("Not closing stream yet");
    }

    public void doClose() throws IOException {
        LOG.debug("Closing stream now");
        super.close();
    }

    public static void closeStream(InputStream is) {
        try {
            if (is instanceof KeepOpenInputStream) {
                ((KeepOpenInputStream)is).doClose();
            } else {
                is.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to close input stream", (Throwable)e);
        }
    }
}

