/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.csl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.OverridingMethods;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.csl.DeclarationFinderImpl;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.openide.filesystems.FileObject;

public class OverridingMethodsImpl
implements OverridingMethods {
    private String classSignatureForInheritedMethods = "";
    private String classSignatureForInheritedByMethods = "";
    private String classSignatureForInheritedByTypes = "";
    private String classSignatureForInheritedFields = "";
    private String classSignatureForInheritedByFields = "";
    private String classSignatureForInheritedClassConstants = "";
    private String classSignatureForInheritedByClassConstants = "";
    private Set<MethodElement> inheritedMethods = Collections.emptySet();
    private Set<MethodElement> inheritedByMethods = Collections.emptySet();
    private Set<TypeElement> inheritedByTypes = new LinkedHashSet<TypeElement>();
    private Set<FieldElement> inheritedFields = Collections.emptySet();
    private Set<FieldElement> inheritedByFields = Collections.emptySet();
    private Set<TypeConstantElement> inheritedClassConstants = Collections.emptySet();
    private Set<TypeConstantElement> inheritedByClassConstants = Collections.emptySet();

    public Collection<? extends DeclarationFinder.AlternativeLocation> overrides(ParserResult info, ElementHandle handle) {
        assert (handle instanceof ModelElement);
        if (handle instanceof MethodScope) {
            MethodScope method = (MethodScope)handle;
            ElementFilter methodNameFilter = ElementFilter.forName(NameKind.exact(method.getName()));
            Set<MethodElement> overridenMethods = methodNameFilter.filter(this.getInheritedMethods(info, method));
            ArrayList<MethodLocation> retval = new ArrayList<MethodLocation>();
            for (MethodElement methodElement : overridenMethods) {
                retval.add(MethodLocation.newInstance(methodElement));
            }
            return retval;
        }
        if (handle instanceof org.netbeans.modules.php.editor.model.FieldElement) {
            org.netbeans.modules.php.editor.model.FieldElement field = (org.netbeans.modules.php.editor.model.FieldElement)handle;
            ElementFilter fieldNameFilter = ElementFilter.forName(NameKind.exact(field.getName()));
            Set<FieldElement> overridenFields = fieldNameFilter.filter(this.getInheritedFields(info, field));
            ArrayList<FieldLocation> retval = new ArrayList<FieldLocation>();
            for (FieldElement fieldElement : overridenFields) {
                retval.add(FieldLocation.newInstance(fieldElement));
            }
            return retval;
        }
        if (handle instanceof ClassConstantElement) {
            ClassConstantElement constant = (ClassConstantElement)handle;
            ElementFilter constantNameFilter = ElementFilter.forName(NameKind.exact(constant.getName()));
            Set<TypeConstantElement> overridenConstants = constantNameFilter.filter(this.getInheritedClassConstants(info, constant));
            ArrayList<ClassConstantLocation> retval = new ArrayList<ClassConstantLocation>();
            for (TypeConstantElement constantElement : overridenConstants) {
                retval.add(ClassConstantLocation.newInstance(constantElement));
            }
            return retval;
        }
        return null;
    }

    public Collection<? extends DeclarationFinder.AlternativeLocation> overriddenBy(ParserResult info, ElementHandle handle) {
        assert (handle instanceof ModelElement);
        if (handle instanceof MethodScope) {
            MethodScope method = (MethodScope)handle;
            ElementFilter methodNameFilter = ElementFilter.forName(NameKind.exact(method.getName()));
            Set<MethodElement> overridenByMethods = methodNameFilter.filter(this.getInheritedByMethods(info, method));
            ArrayList<MethodLocation> retval = new ArrayList<MethodLocation>();
            for (MethodElement methodElement : overridenByMethods) {
                retval.add(MethodLocation.newInstance(methodElement));
            }
            return retval;
        }
        if (handle instanceof TypeScope) {
            ArrayList<TypeLocation> retval = new ArrayList<TypeLocation>();
            for (TypeElement typeElement : this.getInheritedByTypes(info, (TypeScope)handle)) {
                retval.add(TypeLocation.newInstance(typeElement));
            }
            return retval;
        }
        if (handle instanceof org.netbeans.modules.php.editor.model.FieldElement) {
            org.netbeans.modules.php.editor.model.FieldElement field = (org.netbeans.modules.php.editor.model.FieldElement)handle;
            ElementFilter fieldFilter = ElementFilter.allOf(ElementFilter.forName(NameKind.exact(field.getName())), ElementFilter.forPrivateModifiers(false));
            Set<FieldElement> overridenByFields = fieldFilter.filter(this.getInheritedByFields(info, field));
            ArrayList<FieldLocation> retval = new ArrayList<FieldLocation>();
            for (FieldElement fieldElement : overridenByFields) {
                retval.add(FieldLocation.newInstance(fieldElement));
            }
            return retval;
        }
        if (handle instanceof ClassConstantElement) {
            ClassConstantElement constant = (ClassConstantElement)handle;
            ElementFilter constantFilter = ElementFilter.allOf(ElementFilter.forName(NameKind.exact(constant.getName())), ElementFilter.forPrivateModifiers(false));
            Set<TypeConstantElement> overridenByConstants = constantFilter.filter(this.getInheritedByClassConstants(info, constant));
            ArrayList<ClassConstantLocation> retval = new ArrayList<ClassConstantLocation>();
            for (TypeConstantElement constantElement : overridenByConstants) {
                retval.add(ClassConstantLocation.newInstance(constantElement));
            }
            return retval;
        }
        return null;
    }

    public boolean isOverriddenBySupported(ParserResult info, ElementHandle handle) {
        return true;
    }

    private Set<MethodElement> getInheritedMethods(ParserResult info, MethodScope method) {
        Scope inScope = method.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = typeScope.getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedMethods)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedMethods = index.getInheritedMethods(typeScope);
        }
        this.classSignatureForInheritedMethods = signature;
        return Collections.unmodifiableSet(this.inheritedMethods);
    }

    private Set<FieldElement> getInheritedFields(ParserResult info, org.netbeans.modules.php.editor.model.FieldElement field) {
        Scope inScope = field.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = typeScope.getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedFields)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedFields = index.getInheritedFields(typeScope);
        }
        this.classSignatureForInheritedFields = signature;
        return Collections.unmodifiableSet(this.inheritedFields);
    }

    private Set<TypeConstantElement> getInheritedClassConstants(ParserResult info, ClassConstantElement constant) {
        Scope inScope = constant.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = typeScope.getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedClassConstants)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedClassConstants = index.getInheritedTypeConstants(typeScope);
        }
        this.classSignatureForInheritedClassConstants = signature;
        return Collections.unmodifiableSet(this.inheritedClassConstants);
    }

    private Set<TypeElement> getInheritedByTypes(ParserResult info, TypeScope type) {
        String signature = type.getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedByTypes)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedByTypes = index.getInheritedByTypes(type);
        }
        this.classSignatureForInheritedByTypes = signature;
        return Collections.unmodifiableSet(this.inheritedByTypes);
    }

    private Set<MethodElement> getInheritedByMethods(ParserResult info, MethodScope method) {
        Scope inScope = method.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = ((TypeScope)inScope).getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedByMethods)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedByMethods = new HashSet<MethodElement>();
            for (TypeElement nextType : this.getInheritedByTypes(info, typeScope)) {
                this.inheritedByMethods.addAll(index.getDeclaredMethods(nextType));
            }
        }
        this.classSignatureForInheritedByMethods = signature;
        return Collections.unmodifiableSet(this.inheritedByMethods);
    }

    private Set<FieldElement> getInheritedByFields(ParserResult info, org.netbeans.modules.php.editor.model.FieldElement field) {
        Scope inScope = field.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = ((TypeScope)inScope).getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedByFields)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedByFields = new HashSet<FieldElement>();
            for (TypeElement nextType : this.getInheritedByTypes(info, typeScope)) {
                this.inheritedByFields.addAll(index.getDeclaredFields(nextType));
            }
        }
        this.classSignatureForInheritedByFields = signature;
        return Collections.unmodifiableSet(this.inheritedByFields);
    }

    private Set<TypeConstantElement> getInheritedByClassConstants(ParserResult info, ClassConstantElement constant) {
        Scope inScope = constant.getInScope();
        assert (inScope instanceof TypeScope);
        TypeScope typeScope = (TypeScope)inScope;
        String signature = ((TypeScope)inScope).getIndexSignature();
        if (signature != null && !signature.equals(this.classSignatureForInheritedByClassConstants)) {
            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
            this.inheritedByClassConstants = new HashSet<TypeConstantElement>();
            for (TypeElement nextType : this.getInheritedByTypes(info, typeScope)) {
                this.inheritedByClassConstants.addAll(index.getDeclaredTypeConstants(nextType));
            }
        }
        this.classSignatureForInheritedByClassConstants = signature;
        return Collections.unmodifiableSet(this.inheritedByClassConstants);
    }

    private static final class ClassConstantLocation
    extends DeclarationFinderImpl.AlternativeLocationImpl {
        public static ClassConstantLocation newInstance(PhpElement modelElement) {
            FileObject fileObject = modelElement.getFileObject();
            DeclarationFinder.DeclarationLocation declarationLocation = fileObject == null ? DeclarationFinder.DeclarationLocation.NONE : new DeclarationFinder.DeclarationLocation(fileObject, modelElement.getOffset(), (ElementHandle)modelElement);
            return new ClassConstantLocation(modelElement, declarationLocation);
        }

        private ClassConstantLocation(PhpElement modelElement, DeclarationFinder.DeclarationLocation declaration) {
            super(modelElement, declaration);
        }

        @Override
        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder(30);
            TypeConstantElement constant = (TypeConstantElement)this.getElement();
            TypeElement type = constant.getType();
            sb.append(type.getFullyQualifiedName().toNotFullyQualified().toString());
            FileObject fileObject = type.getFileObject();
            if (fileObject != null) {
                sb.append(" (");
                sb.append(fileObject.getNameExt());
                sb.append(")");
            }
            return sb.toString();
        }
    }

    private static final class FieldLocation
    extends DeclarationFinderImpl.AlternativeLocationImpl {
        public static FieldLocation newInstance(PhpElement modelElement) {
            FileObject fileObject = modelElement.getFileObject();
            DeclarationFinder.DeclarationLocation declarationLocation = fileObject == null ? DeclarationFinder.DeclarationLocation.NONE : new DeclarationFinder.DeclarationLocation(fileObject, modelElement.getOffset(), (ElementHandle)modelElement);
            return new FieldLocation(modelElement, declarationLocation);
        }

        private FieldLocation(PhpElement modelElement, DeclarationFinder.DeclarationLocation declaration) {
            super(modelElement, declaration);
        }

        @Override
        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder(30);
            FieldElement field = (FieldElement)this.getElement();
            TypeElement type = field.getType();
            sb.append(type.getFullyQualifiedName().toNotFullyQualified().toString());
            FileObject fileObject = type.getFileObject();
            if (fileObject != null) {
                sb.append(" (");
                sb.append(fileObject.getNameExt());
                sb.append(")");
            }
            return sb.toString();
        }
    }

    private static final class TypeLocation
    extends DeclarationFinderImpl.AlternativeLocationImpl {
        public static TypeLocation newInstance(PhpElement modelElement) {
            FileObject fileObject = modelElement.getFileObject();
            DeclarationFinder.DeclarationLocation declarationLocation = fileObject == null ? DeclarationFinder.DeclarationLocation.NONE : new DeclarationFinder.DeclarationLocation(fileObject, modelElement.getOffset(), (ElementHandle)modelElement);
            return new TypeLocation(modelElement, declarationLocation);
        }

        private TypeLocation(PhpElement modelElement, DeclarationFinder.DeclarationLocation declarationLocation) {
            super(modelElement, declarationLocation);
        }

        @Override
        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder(30);
            TypeElement type = (TypeElement)this.getElement();
            sb.append(type.getFullyQualifiedName().toNotFullyQualified().toString());
            FileObject fileObject = type.getFileObject();
            if (fileObject != null) {
                sb.append(" (");
                sb.append(fileObject.getNameExt());
                sb.append(")");
            }
            return sb.toString();
        }
    }

    private static final class MethodLocation
    extends DeclarationFinderImpl.AlternativeLocationImpl {
        public static MethodLocation newInstance(PhpElement modelElement) {
            FileObject fileObject = modelElement.getFileObject();
            DeclarationFinder.DeclarationLocation declarationLocation = fileObject == null ? DeclarationFinder.DeclarationLocation.NONE : new DeclarationFinder.DeclarationLocation(fileObject, modelElement.getOffset(), (ElementHandle)modelElement);
            return new MethodLocation(modelElement, declarationLocation);
        }

        private MethodLocation(PhpElement modelElement, DeclarationFinder.DeclarationLocation declarationLocation) {
            super(modelElement, declarationLocation);
        }

        @Override
        public String getDisplayHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder(30);
            MethodElement method = (MethodElement)this.getElement();
            TypeElement type = method.getType();
            sb.append(type.getFullyQualifiedName().toNotFullyQualified().toString());
            FileObject fileObject = type.getFileObject();
            if (fileObject != null) {
                sb.append(" (");
                sb.append(fileObject.getNameExt());
                sb.append(")");
            }
            return sb.toString();
        }
    }
}

