/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TransformUtil {
    private static final String SAX_FEATURES_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String DEFAULT_OUTPUT_EXT = "html";
    private static TransformerFactory transformerFactory;
    private static SAXParserFactory saxParserFactory;

    public static boolean isXSLTransformation(DataObject dataObject) {
        return dataObject.getPrimaryFile().getMIMEType().equals("application/xslt+xml");
    }

    public static String getURLName(FileObject fileObject) throws MalformedURLException, FileStateInvalidException {
        URL fileURL = null;
        File file = FileUtil.toFile((FileObject)fileObject);
        fileURL = file != null ? file.toURL() : fileObject.toURL();
        return fileURL.toExternalForm();
    }

    public static URL createURL(URL baseURL, String fileName) throws MalformedURLException, FileStateInvalidException {
        URL url = new URL(baseURL, fileName);
        return url;
    }

    public static Source createSource(URL baseURL, String fileName) throws IOException, MalformedURLException, FileStateInvalidException, ParserConfigurationException, SAXException {
        URL url = TransformUtil.createURL(baseURL, fileName);
        InputStream is = url.openStream();
        is.close();
        XMLReader reader = TransformUtil.newXMLReader();
        reader.setEntityResolver(TransformUtil.getEntityResolver());
        SAXSource source = new SAXSource(reader, new InputSource(url.toExternalForm()));
        return source;
    }

    public static URIResolver getURIResolver() {
        UserCatalog catalog = UserCatalog.getDefault();
        URIResolver res = catalog == null ? null : catalog.getURIResolver();
        return res;
    }

    public static EntityResolver getEntityResolver() {
        UserCatalog catalog = UserCatalog.getDefault();
        EntityResolver res = catalog == null ? null : catalog.getEntityResolver();
        return res;
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(TransformUtil.getURIResolver());
        }
        return transformerFactory;
    }

    private static SAXParserFactory getSAXParserFactory() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException {
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature(SAX_FEATURES_NAMESPACES, true);
        }
        return saxParserFactory;
    }

    public static Transformer newTransformer(Source xsl) throws TransformerConfigurationException {
        Transformer transformer = TransformUtil.getTransformerFactory().newTransformer(xsl);
        return transformer;
    }

    public static XMLReader newXMLReader() throws ParserConfigurationException, SAXException {
        SAXParser parser = TransformUtil.getSAXParserFactory().newSAXParser();
        return parser.getXMLReader();
    }

    public static Source getAssociatedStylesheet(URL baseURL) {
        Source xml_stylesheet = null;
        try {
            XMLReader reader = TransformUtil.newXMLReader();
            reader.setEntityResolver(TransformUtil.getEntityResolver());
            SAXSource source = new SAXSource(reader, new InputSource(baseURL.toExternalForm()));
            xml_stylesheet = TransformUtil.getTransformerFactory().getAssociatedStylesheet(source, null, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xml_stylesheet;
    }

    public static String guessOutputExt(Source source) {
        String ext = DEFAULT_OUTPUT_EXT;
        try {
            Transformer transformer = TransformUtil.newTransformer(source);
            String method = transformer.getOutputProperty("method");
            if ("text".equals(method)) {
                ext = "txt";
            } else if (method != null) {
                ext = method;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ext;
    }

    public static void transform(Source xml, TransformableCookie transformable, Source xsl, Result output, CookieObserver notifier) throws TransformerException {
        if (transformable != null) {
            transformable.transform(xsl, output, notifier);
        } else {
            try {
                Transformer transformer = TransformUtil.newTransformer(xsl);
                if (notifier != null) {
                    ProtectionDomain domain = transformer.getClass().getProtectionDomain();
                    CodeSource codeSource = domain.getCodeSource();
                    if (codeSource == null) {
                        notifier.receive(new CookieMessage(NbBundle.getMessage(TransformUtil.class, (String)"BK000", (Object)transformer.getClass().getName())));
                    } else {
                        URL location = codeSource.getLocation();
                        notifier.receive(new CookieMessage(NbBundle.getMessage(TransformUtil.class, (String)"BK001", (Object)location, (Object)transformer.getClass().getName())));
                    }
                    Proxy proxy = new Proxy(notifier);
                    transformer.setErrorListener(proxy);
                }
                transformer.transform(xml, output);
            }
            catch (Exception exc) {
                TransformerException transExcept = null;
                DefaultXMLProcessorDetail detail = null;
                if (exc instanceof TransformerException) {
                    transExcept = (TransformerException)exc;
                    if (notifier != null && exc instanceof TransformerConfigurationException) {
                        detail = new DefaultXMLProcessorDetail(transExcept);
                    }
                } else if (exc instanceof SAXParseException) {
                    transExcept = new TransformerException(exc);
                    if (notifier != null) {
                        detail = new DefaultXMLProcessorDetail((SAXParseException)exc);
                    }
                } else {
                    transExcept = new TransformerException(exc);
                    if (notifier != null) {
                        detail = new DefaultXMLProcessorDetail(transExcept);
                    }
                }
                if (notifier != null && detail != null) {
                    CookieMessage message = new CookieMessage(TransformUtil.unwrapExceptionMessage(exc), 3, (Object)detail);
                    notifier.receive(message);
                }
                throw transExcept;
            }
        }
    }

    public static String unwrapExceptionMessage(Throwable exc) {
        Throwable msgHolder = TransformUtil.unwrapException(exc);
        String m = msgHolder.getMessage();
        if (m != null) {
            return m;
        }
        return msgHolder.getClass().getSimpleName();
    }

    public static Throwable unwrapException(Throwable exc) {
        Throwable wrapped = null;
        if (exc instanceof TransformerException) {
            wrapped = ((TransformerException)exc).getException();
        } else if (exc instanceof SAXException) {
            wrapped = ((SAXException)exc).getException();
        } else {
            return exc;
        }
        if (wrapped == null) {
            return exc;
        }
        return TransformUtil.unwrapException(wrapped);
    }

    private static class Proxy
    implements ErrorListener {
        private final CookieObserver peer;

        public Proxy(CookieObserver peer) {
            if (peer == null) {
                throw new NullPointerException();
            }
            this.peer = peer;
        }

        @Override
        public void error(TransformerException tex) throws TransformerException {
            this.report(2, tex);
        }

        @Override
        public void fatalError(TransformerException tex) throws TransformerException {
            this.report(3, tex);
            throw tex;
        }

        @Override
        public void warning(TransformerException tex) throws TransformerException {
            this.report(1, tex);
        }

        private void report(int level, TransformerException tex) throws TransformerException {
            CookieMessage message = new CookieMessage(TransformUtil.unwrapExceptionMessage(tex), level, (Object)new DefaultXMLProcessorDetail(tex));
            this.peer.receive(message);
        }
    }
}

