/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.refactoring;

import com.google.gson.Gson;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowInputBoxParams;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.refactoring.Bundle;
import org.netbeans.modules.java.lsp.server.refactoring.CodeRefactoring;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.java.api.ExtractInterfaceRefactoring;
import org.netbeans.modules.refactoring.java.api.ExtractSuperclassRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public final class ExtractSuperclassOrInterfaceRefactoring
extends CodeRefactoring {
    private static final String EXTRACT_SUPERCLASS_REFACTORING_COMMAND = "java.refactor.extract.superclass";
    private static final String EXTRACT_INTERFACE_REFACTORING_COMMAND = "java.refactor.extract.interface";
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private final Set<String> commands = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.refactor.extract.interface", "java.refactor.extract.superclass")));
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(ResultIterator resultIterator, CodeActionParams params) throws Exception {
        TypeElement type;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("refactor")) {
            return Collections.emptyList();
        }
        CompilationController info = CompilationController.get((Parser.Result)resultIterator.getParserResult());
        if (info == null || !JavaRefactoringUtils.isRefactorable((FileObject)info.getFileObject())) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        int offset = ExtractSuperclassOrInterfaceRefactoring.getOffset((CompilationInfo)info, params.getRange().getStart());
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(offset);
        if (ts.moveNext() && ts.token().id() != JavaTokenId.WHITESPACE && ts.offset() == offset) {
            ++offset;
        }
        String uri = Utils.toUri(info.getFileObject());
        Trees trees = info.getTrees();
        TreeUtilities treeUtilities = info.getTreeUtilities();
        TreePath path = treeUtilities.pathFor(offset);
        if ((path = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)info, (TreePath)path, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false)).getLeaf().getKind() == Tree.Kind.COMPILATION_UNIT) {
            List<? extends Tree> decls = info.getCompilationUnit().getTypeDecls();
            if (!decls.isEmpty()) {
                path = TreePath.getPath(info.getCompilationUnit(), decls.get(0));
            } else {
                return Collections.emptyList();
            }
        }
        if ((type = (TypeElement)trees.getElement(path)) == null) {
            return Collections.emptyList();
        }
        SourcePositions sourcePositions = info.getTrees().getSourcePositions();
        ArrayList<QuickPickItem> members = new ArrayList<QuickPickItem>();
        ArrayList<QuickPickItem> allMembers = new ArrayList<QuickPickItem>();
        ClassTree sourceTree = (ClassTree)path.getLeaf();
        for (Tree tree : sourceTree.getMembers()) {
            QuickPickItem memberItem;
            Element memberElm;
            TreePath memberTreePath = new TreePath(path, tree);
            if (treeUtilities.isSynthetic(memberTreePath) || (memberElm = trees.getElement(memberTreePath)) == null) continue;
            long startMember = sourcePositions.getStartPosition(info.getCompilationUnit(), tree);
            long endMember = sourcePositions.getEndPosition(info.getCompilationUnit(), tree);
            boolean selected = (long)offset > startMember && (long)offset < endMember;
            Set<Modifier> mods = memberElm.getModifiers();
            if (memberElm.getKind() == ElementKind.FIELD) {
                memberItem = new QuickPickItem(ExtractSuperclassOrInterfaceRefactoring.createLabel((CompilationInfo)info, memberElm), null, null, selected, new CodeActionsProvider.ElementData(memberElm));
                allMembers.add(memberItem);
                if (!mods.contains((Object)Modifier.PUBLIC) || !mods.contains((Object)Modifier.STATIC) || !mods.contains((Object)Modifier.FINAL) || ((VariableTree)tree).getInitializer() == null) continue;
                members.add(memberItem);
                continue;
            }
            if (memberElm.getKind() != ElementKind.METHOD) continue;
            memberItem = new QuickPickItem(ExtractSuperclassOrInterfaceRefactoring.createLabel((CompilationInfo)info, memberElm), null, null, selected, new CodeActionsProvider.ElementData(memberElm));
            allMembers.add(memberItem);
            if (!mods.contains((Object)Modifier.PUBLIC) || mods.contains((Object)Modifier.STATIC)) continue;
            members.add(memberItem);
        }
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        if (!allMembers.isEmpty()) {
            QuickPickItem quickPickItem = new QuickPickItem(ExtractSuperclassOrInterfaceRefactoring.createLabel((CompilationInfo)info, type));
            quickPickItem.setUserData(new CodeActionsProvider.ElementData(type));
            if (!type.getKind().isInterface()) {
                result.add(this.createCodeAction(Bundle.DN_ExtractSuperclass(), "refactor.extract", null, EXTRACT_SUPERCLASS_REFACTORING_COMMAND, uri, quickPickItem, allMembers));
            }
            if (!members.isEmpty()) {
                result.add(this.createCodeAction(Bundle.DN_ExtractInterface(), "refactor.extract", null, EXTRACT_INTERFACE_REFACTORING_COMMAND, uri, quickPickItem, members));
            }
        }
        return result;
    }

    @Override
    public Set<String> getCommands() {
        return this.commands;
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        if (arguments.size() > 2) {
            String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
            QuickPickItem type = (QuickPickItem)this.gson.fromJson(this.gson.toJson(arguments.get(1)), QuickPickItem.class);
            List<QuickPickItem> members = Arrays.asList((QuickPickItem[])this.gson.fromJson(this.gson.toJson(arguments.get(2)), QuickPickItem[].class));
            client.showQuickPick(new ShowQuickPickParams(null, Bundle.DN_SelectMembersToExtract(), true, members)).thenAccept(selected -> {
                if (selected != null && !selected.isEmpty()) {
                    String label = EXTRACT_SUPERCLASS_REFACTORING_COMMAND.equals(command) ? Bundle.DN_SelectClassName() : Bundle.DN_SelectInterfaceName();
                    String value = EXTRACT_SUPERCLASS_REFACTORING_COMMAND.equals(command) ? "NewClass" : "NewInterface";
                    client.showInputBox(new ShowInputBoxParams(label, value)).thenAccept(name -> {
                        if (name != null && !name.isEmpty()) {
                            this.extract(client, uri, command, type, (List<QuickPickItem>)selected, (String)name);
                        }
                    });
                }
            });
        } else {
            client.showMessage(new MessageParams(MessageType.Error, String.format("Illegal number of arguments received for command: %s", command)));
        }
        return CompletableFuture.completedFuture(true);
    }

    private void extract(NbCodeLanguageClient client, String uri, String command, QuickPickItem source, List<QuickPickItem> members, String name) {
        try {
            ExtractInterfaceRefactoring refactoring;
            FileObject file = Utils.fromUri(uri);
            ClasspathInfo info = ClasspathInfo.create((FileObject)file);
            ElementHandle handle = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(source.getUserData()), CodeActionsProvider.ElementData.class)).toHandle();
            if (EXTRACT_SUPERCLASS_REFACTORING_COMMAND.equals(command)) {
                ArrayList memberHandles = new ArrayList();
                JavaSource js = JavaSource.forFileObject((FileObject)file);
                if (js == null) {
                    throw new IOException("Cannot get JavaSource for: " + uri);
                }
                js.runUserActionTask(ci -> {
                    ci.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    for (QuickPickItem member : members) {
                        Element el = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(member.getUserData()), CodeActionsProvider.ElementData.class)).resolve((CompilationInfo)ci);
                        memberHandles.add(MemberInfo.create((Element)el, (CompilationInfo)ci));
                    }
                }, true);
                ExtractSuperclassRefactoring r = new ExtractSuperclassRefactoring(TreePathHandle.from((ElementHandle)handle, (ClasspathInfo)info));
                r.setMembers(memberHandles.toArray(new MemberInfo[memberHandles.size()]));
                r.setSuperClassName(name);
                refactoring = r;
            } else {
                ArrayList<ElementHandle> fields = new ArrayList<ElementHandle>();
                ArrayList<ElementHandle> methods = new ArrayList<ElementHandle>();
                for (QuickPickItem member : members) {
                    ElementHandle memberHandle = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(member.getUserData()), CodeActionsProvider.ElementData.class)).toHandle();
                    switch (memberHandle.getKind()) {
                        case FIELD: {
                            fields.add(memberHandle);
                            break;
                        }
                        case METHOD: {
                            methods.add(memberHandle);
                        }
                    }
                }
                ExtractInterfaceRefactoring r = new ExtractInterfaceRefactoring(TreePathHandle.from((ElementHandle)handle, (ClasspathInfo)info));
                r.setFields(fields);
                r.setMethods(methods);
                r.setInterfaceName(name);
                refactoring = r;
            }
            refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor((FileObject[])new FileObject[]{file}));
            client.applyEdit(new ApplyWorkspaceEditParams(ExtractSuperclassOrInterfaceRefactoring.perform((AbstractRefactoring)refactoring, EXTRACT_SUPERCLASS_REFACTORING_COMMAND.equals(command) ? "Extract Superclass" : "Extract Interface")));
        }
        catch (Exception ex) {
            client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
        }
    }
}

