/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor.bracesmatcher;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.gsp.lexer.GspLexerLanguage;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public class GspBracesMatcher
implements BracesMatcher {
    private MatcherContext context;
    private BaseDocument document;

    GspBracesMatcher(MatcherContext context) {
        this.context = context;
        this.document = (BaseDocument)context.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        this.document.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(GspLexerLanguage.getLanguage());
            if (tokenSequence == null) {
                int[] nArray = null;
                return nArray;
            }
            tokenSequence.move(this.context.getSearchOffset());
            tokenSequence.moveNext();
            Token gspToken = tokenSequence.token();
            if (gspToken == null || this.isIndependentTag((TokenSequence<GspTokenId>)tokenSequence)) {
                int[] nArray = null;
                return nArray;
            }
            int[] nArray = this.findTagBoundaries((TokenSequence<GspTokenId>)tokenSequence, (Token<GspTokenId>)gspToken);
            return nArray;
        }
        finally {
            this.document.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        this.document.readLock();
        try {
            Token<GspTokenId> matchingTokenId;
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence(GspLexerLanguage.getLanguage());
            if (tokenSequence == null) {
                int[] nArray = null;
                return nArray;
            }
            tokenSequence.move(this.context.getSearchOffset());
            tokenSequence.moveNext();
            Token gspToken = tokenSequence.token();
            if (gspToken == null) {
                int[] nArray = null;
                return nArray;
            }
            switch ((GspTokenId)gspToken.id()) {
                case GTAG_OPENING_START: 
                case GTAG_OPENING_NAME: 
                case GTAG_OPENING_END: 
                case GTAG_ATTRIBUTE_VALUE: 
                case GTAG_ATTRIBUTE_NAME: {
                    matchingTokenId = this.findClosingToken((TokenSequence<GspTokenId>)tokenSequence, GspTokenId.GTAG_OPENING_START, GspTokenId.GTAG_CLOSING_START, GspTokenId.GTAG_INDEPENDENT_END);
                    break;
                }
                case GTAG_CLOSING_START: 
                case GTAG_CLOSING_NAME: 
                case GTAG_CLOSING_END: {
                    matchingTokenId = this.findOpeningToken((TokenSequence<GspTokenId>)tokenSequence, GspTokenId.GTAG_OPENING_END, GspTokenId.GTAG_CLOSING_END);
                    break;
                }
                case COMMENT_JSP_STYLE_START: {
                    matchingTokenId = this.findClosingToken((TokenSequence<GspTokenId>)tokenSequence, GspTokenId.COMMENT_JSP_STYLE_START, GspTokenId.COMMENT_JSP_STYLE_END, null);
                    break;
                }
                case COMMENT_JSP_STYLE_END: {
                    matchingTokenId = this.findOpeningToken((TokenSequence<GspTokenId>)tokenSequence, GspTokenId.COMMENT_JSP_STYLE_START, GspTokenId.COMMENT_JSP_STYLE_END);
                    break;
                }
                case COMMENT_GSP_STYLE_START: {
                    matchingTokenId = this.findClosingToken((TokenSequence<GspTokenId>)tokenSequence, GspTokenId.COMMENT_GSP_STYLE_START, GspTokenId.COMMENT_GSP_STYLE_END, null);
                    break;
                }
                case COMMENT_GSP_STYLE_END: {
                    matchingTokenId = this.findOpeningToken((TokenSequence<GspTokenId>)tokenSequence, GspTokenId.COMMENT_GSP_STYLE_START, GspTokenId.COMMENT_GSP_STYLE_END);
                    break;
                }
                case COMMENT_HTML_STYLE_START: {
                    matchingTokenId = this.findClosingToken((TokenSequence<GspTokenId>)tokenSequence, GspTokenId.COMMENT_HTML_STYLE_START, GspTokenId.COMMENT_HTML_STYLE_END, null);
                    break;
                }
                case COMMENT_HTML_STYLE_END: {
                    matchingTokenId = this.findOpeningToken((TokenSequence<GspTokenId>)tokenSequence, GspTokenId.COMMENT_HTML_STYLE_START, GspTokenId.COMMENT_HTML_STYLE_END);
                    break;
                }
                default: {
                    int[] nArray = null;
                    return nArray;
                }
            }
            int[] nArray = this.findTagBoundaries((TokenSequence<GspTokenId>)tokenSequence, matchingTokenId);
            return nArray;
        }
        finally {
            this.document.readUnlock();
        }
    }

    private boolean isIndependentTag(TokenSequence<GspTokenId> tokenSequence) {
        while (!MatcherContext.isTaskCanceled()) {
            switch ((GspTokenId)tokenSequence.token().id()) {
                case GTAG_INDEPENDENT_END: {
                    return true;
                }
                case GTAG_OPENING_END: 
                case GTAG_CLOSING_END: 
                case WHITESPACE: {
                    return false;
                }
            }
            if (tokenSequence.moveNext()) continue;
            break;
        }
        return false;
    }

    private int[] findTagBoundaries(TokenSequence<GspTokenId> tokenSequence, Token<GspTokenId> gspTokenID) {
        int tagEnd;
        int tagStart;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
        switch ((GspTokenId)gspTokenID.id()) {
            case COMMENT_JSP_STYLE_START: 
            case COMMENT_JSP_STYLE_END: 
            case COMMENT_GSP_STYLE_START: 
            case COMMENT_GSP_STYLE_END: 
            case COMMENT_HTML_STYLE_START: 
            case COMMENT_HTML_STYLE_END: {
                tagStart = gspTokenID.offset(tokenHierarchy);
                tagEnd = tagStart + gspTokenID.length();
                break;
            }
            case GTAG_OPENING_START: {
                tagStart = gspTokenID.offset(tokenHierarchy);
                tagEnd = this.findForwards(tokenSequence, GspTokenId.GTAG_OPENING_END);
                break;
            }
            case GTAG_OPENING_NAME: 
            case GTAG_ATTRIBUTE_VALUE: 
            case GTAG_ATTRIBUTE_NAME: {
                tagStart = this.findBackwards(tokenSequence, GspTokenId.GTAG_OPENING_START);
                tagEnd = this.findForwards(tokenSequence, GspTokenId.GTAG_OPENING_END);
                break;
            }
            case GTAG_OPENING_END: {
                tagStart = this.findBackwards(tokenSequence, GspTokenId.GTAG_OPENING_START);
                tagEnd = gspTokenID.offset(tokenHierarchy) + gspTokenID.length();
                break;
            }
            case GTAG_CLOSING_START: {
                tagStart = gspTokenID.offset(tokenHierarchy);
                tagEnd = this.findForwards(tokenSequence, GspTokenId.GTAG_CLOSING_END);
                break;
            }
            case GTAG_CLOSING_NAME: {
                tagStart = this.findBackwards(tokenSequence, GspTokenId.GTAG_CLOSING_START);
                tagEnd = this.findForwards(tokenSequence, GspTokenId.GTAG_CLOSING_END);
                break;
            }
            case GTAG_CLOSING_END: {
                tagStart = this.findBackwards(tokenSequence, GspTokenId.GTAG_CLOSING_START);
                tagEnd = gspTokenID.offset(tokenHierarchy) + gspTokenID.length();
                break;
            }
            default: {
                return null;
            }
        }
        return new int[]{tagStart, tagEnd};
    }

    private int findBackwards(TokenSequence<GspTokenId> tokenSequence, GspTokenId tokenID) {
        while (!MatcherContext.isTaskCanceled()) {
            Token nextGspToken = tokenSequence.token();
            if (nextGspToken.id() == tokenID) {
                return nextGspToken.offset(TokenHierarchy.get((Document)this.document));
            }
            if (tokenSequence.movePrevious()) continue;
            break;
        }
        return 0;
    }

    private int findForwards(TokenSequence<GspTokenId> tokenSequence, GspTokenId tokenID) {
        while (!MatcherContext.isTaskCanceled()) {
            Token nextToken = tokenSequence.token();
            if (nextToken.id() == tokenID) {
                return nextToken.offset(TokenHierarchy.get((Document)this.document)) + nextToken.length();
            }
            if (tokenSequence.moveNext()) continue;
            break;
        }
        return 0;
    }

    private Token<GspTokenId> findClosingToken(TokenSequence<GspTokenId> tokenSequence, TokenId openingTokenID, TokenId closingTokenID, TokenId independentTokenID) {
        int balance = 0;
        while (tokenSequence.moveNext()) {
            if (MatcherContext.isTaskCanceled()) {
                return null;
            }
            Token token = tokenSequence.token();
            TokenId tokenID = token.id();
            if (tokenID == openingTokenID) {
                ++balance;
                continue;
            }
            if (tokenID == independentTokenID) {
                --balance;
                continue;
            }
            if (tokenID != closingTokenID) continue;
            if (balance == 0) {
                return token;
            }
            --balance;
        }
        return null;
    }

    private Token<GspTokenId> findOpeningToken(TokenSequence<GspTokenId> tokenSequence, TokenId openingTokenID, TokenId closingTokenID) {
        int balance = 0;
        while (tokenSequence.movePrevious()) {
            if (MatcherContext.isTaskCanceled()) {
                return null;
            }
            Token token = tokenSequence.token();
            TokenId tokenID = token.id();
            if (tokenID == openingTokenID) {
                if (balance == 0) {
                    return token;
                }
                --balance;
                continue;
            }
            if (tokenID != closingTokenID) continue;
            ++balance;
        }
        return null;
    }
}

