/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;

public class JaxWsClientMethodGenerator
implements CancellableTask<WorkingCopy> {
    boolean isStatic;
    String operationName;
    String returnType;
    String[] paramTypes;
    String[] paramNames;
    String[] exceptionTypes;
    String body;

    public JaxWsClientMethodGenerator(boolean isStatic, String operationName, String returnType, String[] paramTypes, String[] paramNames, String[] exceptionTypes, String body) {
        this.isStatic = isStatic;
        this.operationName = operationName;
        this.returnType = returnType;
        this.paramTypes = paramTypes;
        this.paramNames = paramNames;
        this.exceptionTypes = exceptionTypes;
        this.body = body;
    }

    public void run(WorkingCopy copy) throws Exception {
        copy.toPhase(JavaSource.Phase.RESOLVED);
        ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)copy);
        if (javaClass != null) {
            TypeElement returnTypeEl;
            TreeMaker maker = copy.getTreeMaker();
            HashSet<Modifier> methodModifs = new HashSet<Modifier>();
            methodModifs.add(Modifier.PRIVATE);
            if (this.isStatic) {
                methodModifs.add(Modifier.STATIC);
            }
            ExpressionTree returnTypeTree = (returnTypeEl = copy.getElements().getTypeElement(this.returnType)) == null ? maker.Identifier((CharSequence)this.returnType) : maker.QualIdent((Element)returnTypeEl);
            ArrayList<VariableTree> variables = new ArrayList<VariableTree>();
            ModifiersTree fieldModif = maker.Modifiers(Collections.emptySet());
            for (int i = 0; i < this.paramTypes.length; ++i) {
                IdentifierTree paramType = maker.Identifier((CharSequence)this.paramTypes[i]);
                variables.add(maker.Variable(fieldModif, (CharSequence)this.paramNames[i], (Tree)paramType, null));
            }
            ArrayList<ExpressionTree> exceptions = new ArrayList<ExpressionTree>();
            for (int i = 0; i < this.exceptionTypes.length; ++i) {
                TypeElement exceptionTypeEl = copy.getElements().getTypeElement(this.exceptionTypes[i]);
                ExpressionTree exceptionTypeTree = exceptionTypeEl == null ? maker.Identifier((CharSequence)this.exceptionTypes[i]) : maker.QualIdent((Element)exceptionTypeEl);
                exceptions.add(exceptionTypeTree);
            }
            MethodTree methodTree = maker.Method(maker.Modifiers(methodModifs), (CharSequence)this.suggestMethodName(javaClass, this.operationName), (Tree)returnTypeTree, Collections.emptyList(), variables, exceptions, this.body, null);
            ClassTree modifiedClass = maker.addClassMember(javaClass, (Tree)methodTree);
            copy.rewrite((Tree)javaClass, (Tree)modifiedClass);
        }
    }

    public void cancel() {
    }

    private String suggestMethodName(ClassTree javaClass, String suggestedMethodName) {
        String suggestedName = suggestedMethodName;
        boolean scanningNeeded = true;
        int i = 1;
        while (scanningNeeded) {
            boolean foundDuplicity = false;
            for (Tree tree : javaClass.getMembers()) {
                MethodTree method;
                if (Tree.Kind.METHOD != tree.getKind() || !(method = (MethodTree)tree).getName().contentEquals(suggestedName)) continue;
                suggestedName = suggestedMethodName + "_" + String.valueOf(i++);
                foundDuplicity = true;
                break;
            }
            scanningNeeded = foundDuplicity;
        }
        return suggestedName;
    }
}

