/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.jaxws;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.spi.jaxws.client.ProjectJAXWSClientSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;

public class EjbProjectJAXWSClientSupport
extends ProjectJAXWSClientSupport {
    private EjbJarProject project;

    public EjbProjectJAXWSClientSupport(EjbJarProject project, AntProjectHelper helper) {
        super((Project)project, helper);
        this.project = project;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        FileObject metaInfFo;
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        if (ejbModule != null && (metaInfFo = ejbModule.getMetaInf()) != null) {
            FileObject wsdlFo = metaInfFo.getFileObject("wsdl");
            if (wsdlFo != null) {
                return wsdlFo;
            }
            if (create) {
                return metaInfFo.createFolder("wsdl");
            }
        }
        return null;
    }

    protected void addJaxWs20Library() throws Exception {
        SourceGroup[] sgs = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (sgs.length > 0) {
            try {
                FileObject srcRoot = sgs[0].getRootFolder();
                WSUtils.addJaxWsApiEndorsed((Project)this.project, (FileObject)srcRoot);
            }
            catch (IOException ex) {
                Logger.getLogger(EjbProjectJAXWSClientSupport.class.getName()).log(Level.FINE, "Cannot add JAX-WS-ENDORSED classpath", ex);
            }
        }
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getAPIEjbJar().getMetaInf();
    }

    protected String getProjectJavaEEVersion() {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        if (ejbModule != null) {
            if (Profile.JAVA_EE_6_WEB.equals(ejbModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_6_FULL.equals(ejbModule.getJ2eeProfile())) {
                return "java-ee-version-16";
            }
            if (Profile.JAVA_EE_7_WEB.equals(ejbModule.getJ2eeProfile())) {
                return "java-ee-version-17";
            }
            if (Profile.JAVA_EE_7_FULL.equals(ejbModule.getJ2eeProfile())) {
                return "java-ee-version-17";
            }
            if (Profile.JAVA_EE_8_WEB.equals(ejbModule.getJ2eeProfile())) {
                return "java-ee-version-18";
            }
            if (Profile.JAVA_EE_8_FULL.equals(ejbModule.getJ2eeProfile())) {
                return "java-ee-version-18";
            }
            if (Profile.JAKARTA_EE_8_WEB.equals(ejbModule.getJ2eeProfile())) {
                return "jakarta-ee-version-8";
            }
            if (Profile.JAKARTA_EE_8_FULL.equals(ejbModule.getJ2eeProfile())) {
                return "jakarta-ee-version-8";
            }
            if (Profile.JAKARTA_EE_9_WEB.equals(ejbModule.getJ2eeProfile())) {
                return "jakarta-ee-version-9";
            }
            if (Profile.JAKARTA_EE_9_FULL.equals(ejbModule.getJ2eeProfile())) {
                return "jakarta-ee-version-9";
            }
            if (Profile.JAKARTA_EE_9_1_WEB.equals(ejbModule.getJ2eeProfile())) {
                return "jakarta-ee-version-91";
            }
            if (Profile.JAKARTA_EE_9_1_FULL.equals(ejbModule.getJ2eeProfile())) {
                return "jakarta-ee-version-91";
            }
            if (Profile.JAKARTA_EE_10_WEB.equals(ejbModule.getJ2eeProfile())) {
                return "jakarta-ee-version-10";
            }
            if (Profile.JAKARTA_EE_10_FULL.equals(ejbModule.getJ2eeProfile())) {
                return "jakarta-ee-version-10";
            }
            if (Profile.JAVA_EE_5.equals(ejbModule.getJ2eeProfile())) {
                return "java-ee-version-15";
            }
        }
        return "java-ee-version-none";
    }
}

