/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.entity;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.util.SourceLevelChecker;
import org.netbeans.modules.j2ee.persistence.wizard.entity.EntityWizardPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class EntityWizardDescriptor
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private EntityWizardPanel p;
    private List changeListeners = new ArrayList();
    private WizardDescriptor wizardDescriptor;
    private Project project;

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public Component getComponent() {
        if (this.p == null) {
            this.p = new EntityWizardPanel(this);
            this.p.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object newvalue;
                    if (evt.getPropertyName().equals("EntityWizardPanel_isValid") && (newvalue = evt.getNewValue()) instanceof Boolean) {
                        EntityWizardDescriptor.this.stateChanged(null);
                    }
                }
            });
        }
        return this.p;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(EntityWizardDescriptor.class);
    }

    public boolean isValid() {
        if (this.wizardDescriptor == null) {
            return true;
        }
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        if (groups == null || groups.length == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_JavaSourceGroup"));
            return false;
        }
        if (SourceLevelChecker.isSourceLevel14orLower(this.project)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_NeedProperSourceLevel"));
            return false;
        }
        if (this.p.getPrimaryKeyClassName().trim().equals("")) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_PrimaryKeyNotEmpty"));
            return false;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    public void readSettings(Object settings) {
        this.wizardDescriptor = (WizardDescriptor)settings;
        if (this.project == null) {
            this.project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
            this.p.setProject(this.project);
        }
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wizardDescriptor);
        this.p.setTargetFolder(targetFolder);
        try {
            if (ProviderUtil.isValidServerInstanceOrNone(this.project) && !this.isPersistenceUnitDefined(targetFolder)) {
                this.p.setPersistenceUnitButtonVisibility(true);
            } else {
                this.p.setPersistenceUnitButtonVisibility(false);
            }
        }
        catch (InvalidPersistenceXmlException ipx) {
            this.p.setPersistenceUnitButtonVisibility(false);
        }
        catch (RuntimeException ipx) {
            this.p.setPersistenceUnitButtonVisibility(false);
        }
    }

    private boolean isPersistenceUnitDefined(FileObject targetFolder) throws InvalidPersistenceXmlException {
        return ProviderUtil.persistenceExists(this.project, targetFolder);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void storeSettings(Object settings) {
    }

    public String getPrimaryKeyClassName() {
        return this.p.getPrimaryKeyClassName();
    }

    public boolean isCreatePU() {
        return this.p.isCreatePU();
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator it;
        List list = this.changeListeners;
        synchronized (list) {
            it = new HashSet(this.changeListeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent();
    }
}

