/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.mylyn.util.BugtrackingCommand;

public class GetMultiTaskDataCommand
extends BugtrackingCommand {
    private final AbstractRepositoryConnector repositoryConnector;
    private final TaskRepository taskRepository;
    private final Set<String> ids;
    private final TaskDataCollector collector;

    public GetMultiTaskDataCommand(AbstractRepositoryConnector repositoryConnector, TaskRepository taskRepository, TaskDataCollector collector, Set<String> ids) {
        this.taskRepository = taskRepository;
        this.repositoryConnector = repositoryConnector;
        this.ids = ids;
        this.collector = collector;
    }

    @Override
    public void execute() throws CoreException {
        Logger log = Logger.getLogger(this.getClass().getName());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "executing GetMultiTaskDataCommand for tasks: {0}", this.print(this.ids));
        }
        this.repositoryConnector.getTaskDataHandler().getMultiTaskData(this.taskRepository, this.ids, this.collector, (IProgressMonitor)new NullProgressMonitor());
    }

    private String print(Set<String> ids) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String string : ids) {
            sb.append(string);
            if (++i >= ids.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GetMultiTaskDataCommand [repository=");
        sb.append(this.taskRepository.getUrl());
        sb.append(",...]");
        return sb.toString();
    }
}

