/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.devops.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListPathsRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String ref;
    private Boolean pathsInSubtree;
    private String folderPath;
    private Integer limit;
    private String page;
    private String displayName;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    @ConstructorProperties(value={"repositoryId", "ref", "pathsInSubtree", "folderPath", "limit", "page", "displayName", "sortOrder", "sortBy", "opcRequestId"})
    ListPathsRequest(String repositoryId, String ref, Boolean pathsInSubtree, String folderPath, Integer limit, String page, String displayName, SortOrder sortOrder, SortBy sortBy, String opcRequestId) {
        this.repositoryId = repositoryId;
        this.ref = ref;
        this.pathsInSubtree = pathsInSubtree;
        this.folderPath = folderPath;
        this.limit = limit;
        this.page = page;
        this.displayName = displayName;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).ref(this.ref).pathsInSubtree(this.pathsInSubtree).folderPath(this.folderPath).limit(this.limit).page(this.page).displayName(this.displayName).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "ListPathsRequest(super=" + super.toString() + ", repositoryId=" + this.getRepositoryId() + ", ref=" + this.getRef() + ", pathsInSubtree=" + this.getPathsInSubtree() + ", folderPath=" + this.getFolderPath() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", displayName=" + this.getDisplayName() + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPathsRequest)) {
            return false;
        }
        ListPathsRequest other = (ListPathsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$pathsInSubtree = this.getPathsInSubtree();
        Boolean other$pathsInSubtree = other.getPathsInSubtree();
        if (this$pathsInSubtree == null ? other$pathsInSubtree != null : !((Object)this$pathsInSubtree).equals(other$pathsInSubtree)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$repositoryId = this.getRepositoryId();
        String other$repositoryId = other.getRepositoryId();
        if (this$repositoryId == null ? other$repositoryId != null : !this$repositoryId.equals(other$repositoryId)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        String this$folderPath = this.getFolderPath();
        String other$folderPath = other.getFolderPath();
        if (this$folderPath == null ? other$folderPath != null : !this$folderPath.equals(other$folderPath)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListPathsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $pathsInSubtree = this.getPathsInSubtree();
        result = result * 59 + ($pathsInSubtree == null ? 43 : ((Object)$pathsInSubtree).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $repositoryId = this.getRepositoryId();
        result = result * 59 + ($repositoryId == null ? 43 : $repositoryId.hashCode());
        String $ref = this.getRef();
        result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
        String $folderPath = this.getFolderPath();
        result = result * 59 + ($folderPath == null ? 43 : $folderPath.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRef() {
        return this.ref;
    }

    public Boolean getPathsInSubtree() {
        return this.pathsInSubtree;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListPathsRequest, Void> {
        private String repositoryId;
        private String ref;
        private Boolean pathsInSubtree;
        private String folderPath;
        private Integer limit;
        private String page;
        private String displayName;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListPathsRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.ref(o.getRef());
            this.pathsInSubtree(o.getPathsInSubtree());
            this.folderPath(o.getFolderPath());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.displayName(o.getDisplayName());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListPathsRequest build() {
            ListPathsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public Builder pathsInSubtree(Boolean pathsInSubtree) {
            this.pathsInSubtree = pathsInSubtree;
            return this;
        }

        public Builder folderPath(String folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListPathsRequest buildWithoutInvocationCallback() {
            return new ListPathsRequest(this.repositoryId, this.ref, this.pathsInSubtree, this.folderPath, this.limit, this.page, this.displayName, this.sortOrder, this.sortBy, this.opcRequestId);
        }

        public String toString() {
            return "ListPathsRequest.Builder(repositoryId=" + this.repositoryId + ", ref=" + this.ref + ", pathsInSubtree=" + this.pathsInSubtree + ", folderPath=" + this.folderPath + ", limit=" + this.limit + ", page=" + this.page + ", displayName=" + this.displayName + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortBy {
        Type("type"),
        SizeInBytes("sizeInBytes"),
        Name("name");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

