/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class FileToRepoMappingStorage {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.util.FileToRepoMappingStorage");
    private static final String REPOSITORY_FOR_FILE_PREFIX = "repository for ";
    private static final Boolean FIRM_ASSOCIATION = Boolean.TRUE;
    private static final Boolean LOOSE_ASSOCIATION = Boolean.FALSE;
    private static FileToRepoMappingStorage instance;

    public static synchronized FileToRepoMappingStorage getInstance() {
        if (instance == null) {
            instance = new FileToRepoMappingStorage();
        }
        return instance;
    }

    public void setFirmAssociation(File file, String repositoryUrl) {
        this.setAssociation(file, repositoryUrl, true);
    }

    public boolean setLooseAssociation(File file, String repositoryUrl) {
        String firmlyAssociated = this.getFirmlyAssociatedRepository(file);
        if (firmlyAssociated == null) {
            this.setAssociation(file, repositoryUrl, false);
            return true;
        }
        return false;
    }

    public String getRepository(File file) {
        return this.getAssociatedRepository(file, null);
    }

    public String getFirmlyAssociatedRepository(File file) {
        return this.getAssociatedRepository(file, FIRM_ASSOCIATION);
    }

    public String getLooselyAssociatedRepository(File file) {
        return this.getAssociatedRepository(file, LOOSE_ASSOCIATION);
    }

    public Collection<String> getAllFirmlyAssociatedUrls() {
        HashSet<String> associatedUrls = new HashSet<String>(10);
        try {
            String[] keys;
            Preferences prefs = this.getPreferences();
            for (String key : keys = prefs.keys()) {
                String value;
                if (!key.startsWith(REPOSITORY_FOR_FILE_PREFIX) || (value = prefs.get(key, null)) == null || value.length() <= 0 || value.charAt(0) != '!') continue;
                associatedUrls.add(value.substring(1));
            }
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        return associatedUrls;
    }

    private String getAssociatedRepository(File file, Boolean reqAssociationType) {
        boolean matches;
        String key = FileToRepoMappingStorage.getPath(file);
        if (key == null) {
            return null;
        }
        String value = this.getValueForKey(key);
        if (value == null || value.length() == 0) {
            return null;
        }
        char firstChar = value.charAt(0);
        switch (firstChar) {
            case '!': {
                matches = reqAssociationType != LOOSE_ASSOCIATION;
                break;
            }
            case '?': {
                matches = reqAssociationType != FIRM_ASSOCIATION;
                break;
            }
            default: {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("unexpected first char of value in mapping: " + key + '=' + value + " (expected: '?' or '!')");
                }
                matches = false;
            }
        }
        return matches ? value.substring(1) : null;
    }

    private void setAssociation(File file, String repositoryUrl, boolean firm) {
        String key = FileToRepoMappingStorage.getPath(file);
        if (key == null) {
            return;
        }
        repositoryUrl = FileToRepoMappingStorage.cutTrailingSlashes(repositoryUrl);
        String value = new StringBuilder(1 + repositoryUrl.length()).append(firm ? (char)'!' : '?').append(repositoryUrl).toString();
        this.storeKeyValuePair(key, value);
    }

    private static String getPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            LOG.throwing(FileToRepoMappingStorage.class.getCanonicalName(), "storeMappingToPrefs", ex);
            return null;
        }
    }

    private void storeKeyValuePair(String key, String value) {
        this.getPreferences().put(REPOSITORY_FOR_FILE_PREFIX + key, value);
    }

    private String getValueForKey(String key) {
        return this.getPreferences().get(REPOSITORY_FOR_FILE_PREFIX + key, null);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(FileToRepoMappingStorage.class);
    }

    public static String cutTrailingSlashes(String url) {
        int endIndex;
        for (endIndex = url.length(); endIndex > 1 && url.charAt(endIndex - 1) == '/'; --endIndex) {
        }
        return endIndex == url.length() ? url : url.substring(0, endIndex);
    }
}

