/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.module.graph;

import java.util.Objects;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.module.graph.ModuleNode;
import org.openide.util.Parameters;

final class DependencyEdge {
    private final ModuleNode source;
    private final ModuleNode target;
    private final boolean pub;
    private final boolean trans;

    DependencyEdge(@NonNull ModuleNode source, @NonNull ModuleNode target, boolean pubReq, boolean trans) {
        Parameters.notNull((CharSequence)"source", (Object)source);
        Parameters.notNull((CharSequence)"target", (Object)target);
        this.source = source;
        this.target = target;
        this.pub = pubReq;
        this.trans = trans;
    }

    @NonNull
    ModuleNode getSource() {
        return this.source;
    }

    @NonNull
    ModuleNode getTarget() {
        return this.target;
    }

    boolean isPublic() {
        return this.pub;
    }

    boolean isTrasitive() {
        return this.trans;
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyEdge other = (DependencyEdge)obj;
        if (this.pub != other.pub) {
            return false;
        }
        if (this.trans != other.trans) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        return Objects.equals(this.target, other.target);
    }
}

