/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDomainRequest
extends BmcRequest<Void> {
    private String domainId;
    private String opcRequestId;

    @ConstructorProperties(value={"domainId", "opcRequestId"})
    GetDomainRequest(String domainId, String opcRequestId) {
        this.domainId = domainId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().domainId(this.domainId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetDomainRequest(super=" + super.toString() + ", domainId=" + this.getDomainId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDomainRequest)) {
            return false;
        }
        GetDomainRequest other = (GetDomainRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$domainId = this.getDomainId();
        String other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetDomainRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $domainId = this.getDomainId();
        result = result * 59 + ($domainId == null ? 43 : $domainId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDomainRequest, Void> {
        private String domainId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDomainRequest o) {
            this.domainId(o.getDomainId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDomainRequest build() {
            GetDomainRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDomainRequest buildWithoutInvocationCallback() {
            return new GetDomainRequest(this.domainId, this.opcRequestId);
        }

        public String toString() {
            return "GetDomainRequest.Builder(domainId=" + this.domainId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

