/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.TagDefaultSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class AssembleEffectiveTagSetRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private TagDefaultSummary.LifecycleState lifecycleState;

    @ConstructorProperties(value={"compartmentId", "lifecycleState"})
    AssembleEffectiveTagSetRequest(String compartmentId, TagDefaultSummary.LifecycleState lifecycleState) {
        this.compartmentId = compartmentId;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).lifecycleState(this.lifecycleState);
    }

    public String toString() {
        return "AssembleEffectiveTagSetRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssembleEffectiveTagSetRequest)) {
            return false;
        }
        AssembleEffectiveTagSetRequest other = (AssembleEffectiveTagSetRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        TagDefaultSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        TagDefaultSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        return !(this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssembleEffectiveTagSetRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        TagDefaultSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public TagDefaultSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder
    implements BmcRequest.Builder<AssembleEffectiveTagSetRequest, Void> {
        private String compartmentId;
        private TagDefaultSummary.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AssembleEffectiveTagSetRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AssembleEffectiveTagSetRequest build() {
            AssembleEffectiveTagSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder lifecycleState(TagDefaultSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public AssembleEffectiveTagSetRequest buildWithoutInvocationCallback() {
            return new AssembleEffectiveTagSetRequest(this.compartmentId, this.lifecycleState);
        }

        public String toString() {
            return "AssembleEffectiveTagSetRequest.Builder(compartmentId=" + this.compartmentId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

