/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNodeGen;
import com.oracle.truffle.js.runtime.JSRealm;

public abstract class ForeignObjectPrototypeNode
extends JavaScriptBaseNode {
    public abstract DynamicObject executeDynamicObject(Object var1);

    @Specialization(limit="3")
    public DynamicObject doTruffleObject(Object truffleObject, @CachedContext(value=JavaScriptLanguage.class) JSRealm realm, @CachedLibrary(value="truffleObject") InteropLibrary interop) {
        if (interop.hasArrayElements(truffleObject)) {
            return realm.getArrayPrototype();
        }
        if (interop.isExecutable(truffleObject) || interop.isInstantiable(truffleObject)) {
            return realm.getFunctionPrototype();
        }
        if (interop.isInstant(truffleObject)) {
            return realm.getDatePrototype();
        }
        return realm.getObjectPrototype();
    }

    public static ForeignObjectPrototypeNode create() {
        return ForeignObjectPrototypeNodeGen.create();
    }
}

