/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax.event;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.tax.event.TreeEvent;
import org.netbeans.tax.event.TreeEventChangeSupport;

public final class TreeEventManager {
    public static final short FIRE_NOW = 1;
    public static final short FIRE_LATER = 2;
    private short firePolicy;
    private Set cachedSupports = new HashSet();

    public TreeEventManager(short policy) {
        this.firePolicy = policy;
    }

    public TreeEventManager() {
        this(1);
    }

    public TreeEventManager(TreeEventManager eventManager) {
        this.firePolicy = eventManager.firePolicy;
    }

    public final short getFirePolicy() {
        return this.firePolicy;
    }

    public final void setFirePolicy(short firePolicy) {
        if (this.firePolicy == firePolicy) {
            return;
        }
        this.firePolicy = firePolicy;
        if (firePolicy == 1) {
            this.fireCached();
        }
    }

    private void fireCached() {
        Iterator it = this.cachedSupports.iterator();
        while (it.hasNext()) {
            TreeEventChangeSupport next = (TreeEventChangeSupport)it.next();
            next.firePropertyChangeCache();
            it.remove();
        }
    }

    private void addToCache(TreeEventChangeSupport support) {
        this.cachedSupports.add(support);
    }

    public final void firePropertyChange(TreeEventChangeSupport eventChangeSupport, TreeEvent evt) {
        if (this.firePolicy == 1) {
            eventChangeSupport.firePropertyChangeCache();
            eventChangeSupport.firePropertyChangeNow(evt);
            return;
        }
        if (this.firePolicy == 2) {
            eventChangeSupport.firePropertyChangeLater(evt);
            this.addToCache(eventChangeSupport);
            return;
        }
    }
}

