/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartDecorator;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;

final class RowBoundsDecorator
implements ChartDecorator {
    private static final Color BORDER_COLOR = Color.LIGHT_GRAY;
    private final TimelineChart chart;

    RowBoundsDecorator(TimelineChart chart) {
        this.chart = chart;
    }

    public void paint(Graphics2D g, Rectangle dirtyArea, ChartContext context) {
        int rowsCount = this.chart.getRowsCount();
        for (int i = 0; i < rowsCount; ++i) {
            TimelineChart.Row row = this.chart.getRow(i);
            ChartContext rowContext = row.getContext();
            int y = Utils.checkedInt((double)rowContext.getViewportOffsetY()) + rowContext.getViewportHeight() - 1;
            int w = this.chart.getWidth();
            g.setColor(BORDER_COLOR);
            g.drawLine(0, y, w, y);
        }
    }
}

