/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.ui;

import java.net.URL;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.modules.java.lsp.server.htmlui.Browser;
import org.netbeans.modules.java.lsp.server.htmlui.Buttons;
import org.netbeans.modules.java.lsp.server.protocol.HtmlPageParams;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeClientCapabilities;
import org.netbeans.modules.java.lsp.server.protocol.UIContext;
import org.netbeans.modules.java.lsp.server.ui.Bundle;
import org.netbeans.spi.htmlui.HTMLViewerSpi;
import org.openide.util.Exceptions;

public class AbstractLspHtmlViewer
implements HTMLViewerSpi<View, Object> {
    private final Browser.Config initial = new Browser.Config();

    protected AbstractLspHtmlViewer() {
    }

    public View newView(HTMLViewerSpi.Context context) {
        UIContext ui = UIContext.find();
        View view = new View(ui, context);
        return view;
    }

    public Object createButton(View view, String id) {
        return Buttons.createButton0(id, view.ctx);
    }

    public <C> C component(View view, Class<C> type) {
        if (type == Void.class) {
            view.load();
            return null;
        }
        throw new ClassCastException(view + " cannot be cast to " + type);
    }

    public String getId(View view, Object b) {
        return Buttons.buttonName0(b);
    }

    public void setText(View view, Object b, String text) {
        Buttons.buttonText0(b, text);
    }

    public void setEnabled(View view, Object b, boolean enabled) {
        Buttons.buttonDisabled0(b, !enabled);
    }

    public void runLater(View view, Runnable r) {
        r.run();
    }

    protected final class View {
        final HTMLViewerSpi.Context ctx;
        private final UIContext ui;
        private Browser presenter;

        private View(UIContext ui, HTMLViewerSpi.Context ctx) {
            this.ui = ui;
            this.ctx = ctx;
        }

        private void notifyClose() {
            if (this.ctx != null) {
                this.ctx.onSubmit(null);
            }
        }

        private void load() {
            NbCodeClientCapabilities caps = NbCodeClientCapabilities.find(this.ui);
            if (caps == null || !caps.hasShowHtmlPageSupport()) {
                MessageParams msg = new MessageParams();
                msg.setMessage(Bundle.MSG_NoHtmlUI());
                msg.setType(MessageType.Warning);
                this.ui.showMessage(msg);
                this.notifyClose();
                return;
            }
            URL pageUrl = this.ctx.getPage();
            Browser.Config c = AbstractLspHtmlViewer.this.initial.clone();
            c.browser(page -> {
                try {
                    ((CompletableFuture)this.ui.showHtmlPage(new HtmlPageParams(page.toASCIIString())).thenAccept(t -> {
                        Browser p = this.presenter;
                        if (p == null) {
                            return;
                        }
                        try {
                            this.notifyClose();
                        }
                        catch (Throwable ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        try {
                            p.close();
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            this.presenter = null;
                        }
                    })).exceptionally(t -> {
                        this.notifyClose();
                        this.presenter = null;
                        return null;
                    });
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
            this.presenter = new Browser(c);
            this.presenter.displayPage(pageUrl, () -> {
                Buttons.registerCloseWindow();
                try {
                    this.ctx.onPageLoad();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
    }
}

