/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.common.event.SimpleProfilingStateAdapter;
import org.netbeans.modules.profiler.Bundle;

class ServerStateMonitor {
    private final Profiler profiler;
    private ProgressHandle progressHandle = null;
    private int activeServerState = -1;
    private int activeServerProgress = -1;
    private int activeServerProgressValue = -1;

    ServerStateMonitor(Profiler profiler) {
        this.profiler = profiler;
        this.updateProgress();
        profiler.addProfilingStateListener((ProfilingStateListener)new SimpleProfilingStateAdapter(){

            protected void update() {
                ServerStateMonitor.this.updateProgress();
            }
        });
    }

    private void updateProgress() {
        boolean display;
        boolean bl = display = this.profiler.getProfilingState() != 1 && this.profiler.getServerState() != 0;
        if (display) {
            int serverProgress = this.profiler.getServerProgress();
            int serverState = this.profiler.getServerState();
            if (this.progressHandle == null) {
                this.progressHandle = ProgressHandle.createHandle((String)Bundle.ServerStateMonitor_ProfilerBusy());
                if (serverProgress == -1) {
                    this.progressHandle.start();
                } else {
                    this.progressHandle.start(100);
                }
                this.activeServerState = -1;
                this.activeServerProgress = serverProgress;
            }
            if (serverProgress != this.activeServerProgress) {
                if (this.activeServerProgress == -1) {
                    this.progressHandle.switchToDeterminate(100);
                    this.progressHandle.progress(serverProgress);
                    this.activeServerProgressValue = serverProgress;
                } else if (serverProgress == -1) {
                    this.progressHandle.switchToIndeterminate();
                } else if (serverProgress > this.activeServerProgressValue) {
                    this.progressHandle.progress(serverProgress);
                    this.activeServerProgressValue = serverProgress;
                }
                this.activeServerProgress = serverProgress;
            }
            if (serverState != this.activeServerState) {
                this.activeServerState = serverState;
                switch (this.activeServerState) {
                    case 1: {
                        this.progressHandle.progress(Bundle.ServerStateMonitor_ServerInitializing());
                        break;
                    }
                    case 3: {
                        this.progressHandle.progress(Bundle.ServerStateMonitor_ServerInstrumenting());
                        break;
                    }
                    case 2: {
                        this.progressHandle.progress(Bundle.ServerStateMonitor_ServerPreparing());
                        break;
                    }
                    default: {
                        this.progressHandle.progress("");
                    }
                }
            }
        } else {
            this.closeProgress();
        }
    }

    private void closeProgress() {
        if (this.progressHandle != null) {
            this.progressHandle.finish();
            this.progressHandle = null;
        }
    }
}

