/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.swing.PopupButton;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTreeTable;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;

public final class ExportUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.swing.Bundle");
    private static final String BUTTON_EXPORT = messages.getString("ExportUtils_ButtonExport");
    private static final String NPS_FILE = messages.getString("ExportUtils_NpsFile");
    private static final String CSV_FILE = messages.getString("ExportUtils_CsvFile");
    private static final String HTML_FILE = messages.getString("ExportUtils_HtmlFile");
    private static final String XML_FILE = messages.getString("ExportUtils_XmlFile");
    private static final String PNG_FILE = messages.getString("ExportUtils_PngFile");
    private static final String FILE_FILTER_DESCR = messages.getString("ExportUtils_FileFilterDescr");
    private static final String MSG_CANNOT_OVERWRITE_SOURCE = messages.getString("ExportUtils_MsgCannotOverwriteSource");
    private static final String MSG_EXPORT_SNAPSHOT_FAILED = messages.getString("ExportUtils_MsgExportSnapshotFailed");
    private static final String MSG_EXPORT_IMAGE_FAILED = messages.getString("ExportUtils_MsgExportImageFailed");
    private static final String TITLE_OVERWRITE_FILE = messages.getString("ExportUtils_TitleOverwriteFile");
    private static final String MSG_OVERWRITE_FILE = messages.getString("ExportUtils_MsgOverwriteFile");
    private static final Logger LOGGER = Logger.getLogger(ExportUtils.class.getName());
    public static final FormatFilter NPS_FILTER = new FormatFilter(NPS_FILE, "nps");
    public static final FormatFilter CSV_FILTER = new FormatFilter(CSV_FILE, "csv");
    public static final FormatFilter HTML_FILTER = new FormatFilter(HTML_FILE, "html");
    public static final FormatFilter XML_FILTER = new FormatFilter(XML_FILE, "xml");
    public static final FormatFilter PNG_FILTER = new FormatFilter(PNG_FILE, "png");
    private static int LAST_indent = Integer.MIN_VALUE;
    private static String LAST_INDENT;

    public static AbstractButton exportButton(final Component parent, String tooltip, final Exportable ... exportables) {
        PopupButton exportPopup = new PopupButton(Icons.getIcon((String)"GeneralIcons.SaveAs")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                for (final Exportable exportable : exportables) {
                    if (exportable == null || !exportable.isEnabled()) continue;
                    popup.add(new JMenuItem(exportable.getName()){

                        @Override
                        protected void fireActionPerformed(ActionEvent e) {
                            ExportProvider[] providers;
                            JFileChooser fileChooser = new JFileChooser();
                            fileChooser.setDialogType(1);
                            fileChooser.setFileSelectionMode(2);
                            fileChooser.setMultiSelectionEnabled(false);
                            fileChooser.setDialogTitle(exportable.getName());
                            fileChooser.removeChoosableFileFilter(fileChooser.getAcceptAllFileFilter());
                            for (ExportProvider provider : providers = exportable.getProviders()) {
                                fileChooser.addChoosableFileFilter(provider.getFormatFilter());
                            }
                            ExportUtils.showExportDialog(fileChooser, parent, providers);
                        }
                    });
                }
            }
        };
        exportPopup.setToolTipText(tooltip);
        return exportPopup;
    }

    private static void showExportDialog(final JFileChooser fileChooser, final Component parent, final ExportProvider[] providers) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (fileChooser.showDialog(parent, BUTTON_EXPORT) != 0) {
                    return;
                }
                File targetFile = fileChooser.getSelectedFile();
                FileFilter filter = fileChooser.getFileFilter();
                for (ExportProvider provider : providers) {
                    FormatFilter format = provider.getFormatFilter();
                    if (!filter.equals(format)) continue;
                    if (ExportUtils.checkFileExists(targetFile = ExportUtils.checkFileExtension(targetFile, format.getExtension()))) {
                        provider.export(targetFile);
                        break;
                    }
                    ExportUtils.showExportDialog(fileChooser, parent, providers);
                    break;
                }
            }
        });
    }

    private static boolean checkFileExists(File file) {
        return !file.isFile() ? true : ProfilerDialogs.displayConfirmation((String)MSG_OVERWRITE_FILE, (String)TITLE_OVERWRITE_FILE);
    }

    public static File checkFileExtension(File file, String extension) {
        if (file.getName().endsWith(extension)) {
            return file;
        }
        return new File(file.getPath() + extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportCSV(ProfilerTable table, char separator, File file) {
        Exporter ex = new Exporter(file);
        char doubleQuote = '\"';
        int rowCount = table.getRowCount();
        int columnCount = table.getColumnCount();
        try {
            int col;
            for (col = 0; col < columnCount; ++col) {
                ex.write(doubleQuote);
                ex.write(table.getColumnName(col));
                ex.write(doubleQuote);
                if (col < columnCount - 1) {
                    ex.write(separator);
                    continue;
                }
                ex.writeln();
            }
            if (ex.failed()) {
                col = 0;
                return col != 0;
            }
            if (table instanceof ProfilerTreeTable) {
                ProfilerTreeTable treeTable = (ProfilerTreeTable)table;
                TreePath path = treeTable.getNextPath(treeTable.getRootPath());
                TreeNode node = (TreeNode)path.getLastPathComponent();
                int indent = path.getPathCount() - 2;
                TreePath firstPath = path;
                do {
                    if (ex.failed()) {
                        boolean bl = false;
                        return bl;
                    }
                    for (int col2 = 0; col2 < columnCount; ++col2) {
                        ex.write(doubleQuote);
                        if (table.getColumnClass(col2) == JTree.class) {
                            for (int i = 0; i < indent; ++i) {
                                ex.write(' ');
                            }
                        }
                        ex.write(treeTable.getStringValue(node, col2));
                        ex.write(doubleQuote);
                        if (col2 < columnCount - 1) {
                            ex.write(separator);
                            continue;
                        }
                        ex.writeln();
                    }
                    path = treeTable.getNextPath(path);
                    node = (TreeNode)path.getLastPathComponent();
                    indent = path.getPathCount() - 2;
                } while (!firstPath.equals(path));
            } else {
                for (int row = 0; row < rowCount; ++row) {
                    if (ex.failed()) {
                        boolean path = false;
                        return path;
                    }
                    for (int col3 = 0; col3 < columnCount; ++col3) {
                        ex.write(doubleQuote);
                        ex.write(table.getStringValue(row, col3));
                        ex.write(doubleQuote);
                        if (col3 < columnCount - 1) {
                            ex.write(separator);
                            continue;
                        }
                        ex.writeln();
                    }
                }
            }
        }
        finally {
            ex.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportHTML(ProfilerTable table, String name, File file) {
        int columnCount = table.getColumnCount();
        try (Exporter ex = new Exporter(file);){
            int col;
            ex.writeln("<html>");
            if (ex.failed()) {
                boolean bl = false;
                return bl;
            }
            ex.writeln(" <head>");
            ex.writeln("  <meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" />");
            ex.write("  <title>");
            ex.write(name);
            ex.writeln("</title>");
            ex.writeln(" </head>");
            ex.writeln(" <body>");
            ex.writeln("  <table>");
            ex.writeln("   <tr>");
            for (col = 0; col < columnCount; ++col) {
                ex.write("    <th>");
                ex.write(ExportUtils.escapeHTML(table.getColumnName(col)));
                ex.writeln("</th>");
            }
            ex.writeln("   </tr>");
            if (ex.failed()) {
                col = 0;
                return col != 0;
            }
            if (table instanceof ProfilerTreeTable) {
                ProfilerTreeTable treeTable = (ProfilerTreeTable)table;
                TreePath path = treeTable.getNextPath(treeTable.getRootPath());
                TreeNode node = (TreeNode)path.getLastPathComponent();
                int indent = path.getPathCount() - 2;
                TreePath firstPath = path;
                do {
                    if (ex.failed()) {
                        boolean bl = false;
                        return bl;
                    }
                    ex.writeln("   <tr>");
                    for (int col2 = 0; col2 < columnCount; ++col2) {
                        ex.write("    <td><pre>");
                        if (table.getColumnClass(col2) == JTree.class) {
                            for (int i = 0; i < indent; ++i) {
                                ex.write('.');
                            }
                        }
                        ex.write(ExportUtils.escapeHTML(treeTable.getStringValue(node, col2)));
                        ex.writeln("</pre></td>");
                    }
                    ex.writeln("   </tr>");
                    path = treeTable.getNextPath(path);
                    node = (TreeNode)path.getLastPathComponent();
                    indent = path.getPathCount() - 2;
                } while (!firstPath.equals(path));
            } else {
                int rowCount = table.getRowCount();
                for (int row = 0; row < rowCount; ++row) {
                    if (ex.failed()) {
                        boolean node = false;
                        return node;
                    }
                    ex.writeln("   <tr>");
                    for (int col3 = 0; col3 < columnCount; ++col3) {
                        ex.write("    <td><pre>");
                        ex.write(ExportUtils.escapeHTML(table.getStringValue(row, col3)));
                        ex.writeln("</pre></td>");
                    }
                    ex.writeln("   </tr>");
                }
            }
            ex.writeln("  </table>");
            ex.writeln(" </body>");
            ex.writeln("</html>");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportXML(ProfilerTable table, String name, File file) {
        int columnCount = table.getColumnCount();
        try (Exporter ex = new Exporter(file);){
            ex.writeln("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (ex.failed()) {
                boolean bl = false;
                return bl;
            }
            if (table instanceof ProfilerTreeTable) {
                ProfilerTreeTable treeTable = (ProfilerTreeTable)table;
                TreePath path = treeTable.getNextPath(treeTable.getRootPath());
                TreeNode node = (TreeNode)path.getLastPathComponent();
                int indent = path.getPathCount();
                TreePath firstPath = path;
                ex.write("<dataview name=\"");
                ex.write(name);
                ex.writeln("\" type=\"tree\">");
                ex.writeln(" <tree>");
                do {
                    if (ex.failed()) {
                        boolean bl = false;
                        return bl;
                    }
                    ex.write(ExportUtils.indent(indent));
                    ex.writeln("<node>");
                    for (int col = 0; col < columnCount; ++col) {
                        ex.write(ExportUtils.indent(indent));
                        ex.write(" <property name=\"");
                        ex.write(ExportUtils.escapeXML(treeTable.getColumnName(col)));
                        ex.write("\" value=\"");
                        ex.write(ExportUtils.escapeXML(treeTable.getStringValue(node, col)));
                        ex.writeln("\" />");
                    }
                    path = treeTable.getNextPath(path);
                    node = (TreeNode)path.getLastPathComponent();
                    int oldIndent = indent;
                    indent = path.getPathCount();
                    for (int i = 0; i <= oldIndent - indent; ++i) {
                        ex.write(ExportUtils.indent(oldIndent - i));
                        ex.writeln("</node>");
                    }
                } while (!firstPath.equals(path));
                ex.writeln(" </tree>");
                ex.writeln("</dataview>");
            } else {
                int col;
                int rowCount = table.getRowCount();
                ex.write("<dataview name=\"");
                ex.write(name);
                ex.writeln("\" type=\"table\">");
                ex.write(" <table rows=\"");
                ex.write(Integer.toString(rowCount));
                ex.write("\" columns=\"");
                ex.write(Integer.toString(columnCount));
                ex.writeln("\">");
                ex.writeln("  <thead>");
                for (col = 0; col < columnCount; ++col) {
                    ex.write("   <th><![CDATA[");
                    ex.write(ExportUtils.escapeXML(table.getColumnName(col)));
                    ex.writeln("]]></th>");
                }
                ex.writeln("  </thead>");
                if (ex.failed()) {
                    col = 0;
                    return col != 0;
                }
                ex.writeln("  <tbody>");
                for (int row = 0; row < rowCount; ++row) {
                    if (ex.failed()) {
                        boolean node = false;
                        return node;
                    }
                    ex.writeln("   <tr>");
                    for (int col2 = 0; col2 < columnCount; ++col2) {
                        ex.write("    <td><![CDATA[");
                        ex.write(ExportUtils.escapeXML(table.getStringValue(row, col2)));
                        ex.writeln("]]></td>");
                    }
                    ex.writeln("   </tr>");
                }
                ex.writeln("  </tbody>");
                ex.writeln(" </table>");
                ex.writeln("</dataview>");
            }
        }
        return true;
    }

    private static String indent(int indent) {
        if (LAST_indent == indent) {
            return LAST_INDENT;
        }
        if (indent == 0) {
            return "";
        }
        if (indent == 1) {
            return " ";
        }
        if (indent == 2) {
            return "  ";
        }
        if (indent == 3) {
            return "   ";
        }
        if (indent == 4) {
            return "    ";
        }
        if (indent == 5) {
            return "     ";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        LAST_indent = indent;
        LAST_INDENT = sb.toString();
        return LAST_INDENT;
    }

    private static String escapeHTML(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String escapeXML(String s) {
        return s;
    }

    private static ExecutorService createExecutor(final String file) {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Export thread for " + file);
            }
        });
    }

    private ExportUtils() {
    }

    private static final class Exporter {
        private static final int WRT_BUF = 16384;
        private static final int STR_BUF = 32256;
        private volatile boolean failed = false;
        private final File file;
        private StringBuilder buffer;
        private Writer writer;
        private ExecutorService executor;

        Exporter(File file) {
            this.file = file;
            this.buffer = new StringBuilder();
        }

        boolean failed() {
            return this.failed;
        }

        void write(char ch) {
            if (this.failed) {
                return;
            }
            this.buffer.append(ch);
            this.checkAutoFlush();
        }

        void writeln(char ch) {
            if (this.failed) {
                return;
            }
            this.buffer.append(ch).append(System.lineSeparator());
            this.checkAutoFlush();
        }

        void write(String string) {
            if (this.failed) {
                return;
            }
            this.buffer.append(string);
            this.checkAutoFlush();
        }

        void writeln(String string) {
            if (this.failed) {
                return;
            }
            this.buffer.append(string).append(System.lineSeparator());
            this.checkAutoFlush();
        }

        void writeln() {
            if (this.failed) {
                return;
            }
            this.buffer.append(System.lineSeparator());
            this.checkAutoFlush();
        }

        void flush() {
            if (this.failed) {
                return;
            }
            if (this.buffer.length() == 0) {
                return;
            }
            final StringBuilder _buffer = this.buffer;
            this.buffer = new StringBuilder();
            if (this.executor == null) {
                this.executor = ExportUtils.createExecutor(this.file.getName());
            }
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (writer == null) {
                            writer = Exporter.createWriter(file);
                        }
                        writer.append(_buffer);
                    }
                    catch (Throwable t) {
                        this.failed(t);
                    }
                }
            });
        }

        void close() {
            if (this.failed) {
                return;
            }
            this.flush();
            if (this.executor != null) {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable t) {
                                this.failed(t);
                            }
                        }
                    }
                });
            }
        }

        private void failed(Throwable t) {
            this.failed = true;
            LOGGER.log(Level.INFO, t.getMessage(), t);
            String msg = t.getLocalizedMessage().replace("<", "&lt;").replace(">", "&gt;");
            ProfilerDialogs.displayError((String)("<html><b>" + MSG_EXPORT_SNAPSHOT_FAILED + "</b><br><br>" + msg + "</html>"));
        }

        private void checkAutoFlush() {
            if (this.buffer.length() > 32256) {
                this.flush();
            }
        }

        private static Writer createWriter(File file) throws IOException {
            file.toPath();
            CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
            FileOutputStream out = new FileOutputStream(file);
            return new BufferedWriter(new OutputStreamWriter((OutputStream)out, encoder), 16384);
        }
    }

    public static class PNGExportProvider
    extends BaseExportProvider {
        private final Component component;

        public PNGExportProvider(Component component) {
            super(PNG_FILTER);
            this.component = component;
        }

        @Override
        public void export(final File targetFile) {
            final BufferedImage image = UIUtils.createScreenshot(this.component);
            ExportUtils.createExecutor(targetFile.getName()).submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        targetFile.toPath();
                        ImageIO.write((RenderedImage)image, "PNG", targetFile);
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.INFO, t.getMessage(), t);
                        String msg = t.getLocalizedMessage().replace("<", "&lt;").replace(">", "&gt;");
                        ProfilerDialogs.displayError((String)("<html><b>" + MSG_EXPORT_IMAGE_FAILED + "</b><br><br>" + msg + "</html>"));
                    }
                }
            });
        }
    }

    public static class XMLExportProvider
    extends ProfilerTableExportProvider {
        private final String name;

        public XMLExportProvider(ProfilerTable table, String name) {
            super(table, XML_FILTER);
            this.name = name;
        }

        @Override
        protected void export(ProfilerTable table, File targetFile) {
            ExportUtils.exportXML(table, this.name, targetFile);
        }
    }

    public static class HTMLExportProvider
    extends ProfilerTableExportProvider {
        private final String name;

        public HTMLExportProvider(ProfilerTable table, String name) {
            super(table, HTML_FILTER);
            this.name = name;
        }

        @Override
        protected void export(ProfilerTable table, File targetFile) {
            ExportUtils.exportHTML(table, this.name, targetFile);
        }
    }

    public static class CSVExportProvider
    extends ProfilerTableExportProvider {
        public CSVExportProvider(ProfilerTable table) {
            super(table, CSV_FILTER);
        }

        @Override
        protected void export(ProfilerTable table, File targetFile) {
            ExportUtils.exportCSV(table, ',', targetFile);
        }
    }

    public static abstract class AbstractNPSExportProvider
    extends BaseExportProvider {
        private final File sourceFile;

        public AbstractNPSExportProvider(File sourceFile) {
            super(NPS_FILTER);
            this.sourceFile = sourceFile;
        }

        @Override
        public void export(File targetFile) {
            if (targetFile.isFile() && targetFile.equals(this.sourceFile)) {
                ProfilerDialogs.displayError((String)MSG_CANNOT_OVERWRITE_SOURCE);
            } else {
                this.doExport(targetFile);
            }
        }

        protected abstract void doExport(File var1);
    }

    public static abstract class ProfilerTableExportProvider
    extends BaseExportProvider {
        private final ProfilerTable table;

        public ProfilerTableExportProvider(ProfilerTable table, FormatFilter formatFilter) {
            super(formatFilter);
            this.table = table;
        }

        @Override
        public void export(File targetFile) {
            this.export(this.table, targetFile);
        }

        protected abstract void export(ProfilerTable var1, File var2);
    }

    public static abstract class BaseExportProvider
    extends ExportProvider {
        private final FormatFilter formatFilter;

        protected BaseExportProvider(FormatFilter formatFilter) {
            this.formatFilter = formatFilter;
        }

        @Override
        public FormatFilter getFormatFilter() {
            return this.formatFilter;
        }
    }

    public static abstract class ExportProvider {
        public abstract FormatFilter getFormatFilter();

        public abstract void export(File var1);
    }

    public static abstract class Exportable {
        public abstract String getName();

        public abstract boolean isEnabled();

        public abstract ExportProvider[] getProviders();
    }

    public static class FormatFilter
    extends FileFilter {
        private final String name;
        private final String extension;

        public FormatFilter(String name, String extension) {
            this.name = name;
            this.extension = extension.startsWith(".") ? extension : "." + extension;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(this.extension);
        }

        @Override
        public String getDescription() {
            return MessageFormat.format(FILE_FILTER_DESCR, this.name, this.extension);
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

