/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.EclipseLinkLogRecord;

public class LogFormatter
extends SimpleFormatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private final String lineSeparator = Helper.cr();

    @Override
    public synchronized String format(LogRecord record0) {
        if (!(record0 instanceof EclipseLinkLogRecord)) {
            return super.format(record0);
        }
        EclipseLinkLogRecord record = (EclipseLinkLogRecord)record0;
        StringBuffer sb = new StringBuffer();
        if (record.shouldPrintDate()) {
            this.dat.setTime(record.getMillis());
            this.args[0] = this.dat;
            StringBuffer text = new StringBuffer();
            if (this.formatter == null) {
                this.formatter = new MessageFormat(format);
            }
            this.formatter.format(this.args, text, (FieldPosition)null);
            sb.append(text);
            sb.append(" ");
        }
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(" ");
            sb.append(record.getSourceMethodName());
        }
        if (record.getSessionString() != null) {
            sb.append(" ");
            sb.append(record.getSessionString());
        }
        if (record.getConnection() != null) {
            sb.append(" ");
            sb.append("Connection(" + String.valueOf(System.identityHashCode(record.getConnection())) + ")");
        }
        if (record.shouldPrintThread()) {
            sb.append(" ");
            sb.append("Thread(" + String.valueOf(record.getThreadID()) + ")");
        }
        sb.append(this.lineSeparator);
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            Throwable throwable = null;
            Object var7_8 = null;
            try (PrintWriter pw = new PrintWriter(sw);){
                if (record.getLevel().intValue() == Level.SEVERE.intValue()) {
                    record.getThrown().printStackTrace(pw);
                } else if (record.getLevel().intValue() <= Level.WARNING.intValue()) {
                    if (record.shouldLogExceptionStackTrace()) {
                        record.getThrown().printStackTrace(pw);
                    } else {
                        pw.write(record.getThrown().toString());
                        pw.write(this.lineSeparator);
                    }
                }
                pw.close();
                sb.append(sw.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return sb.toString();
    }
}

