/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javafx2.project.JFXProjectProperties;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JFXIconsPanel
extends JPanel {
    private final Project project;
    private final JFXProjectProperties jfxProps;
    private File lastImageFolder = null;
    private IconFieldListener wsIconListener = null;
    private IconFieldListener splashListener = null;
    private IconFieldListener nativeIconListener = null;
    private JButton nativeIconButton;
    private JLabel nativeIconLabel;
    private JTextField nativeIconTextField;
    private JButton nativeIconToggleButton;
    private JLabel remarkLabel;
    private JButton splashButton;
    private JLabel splashLabel;
    private JTextField splashTextField;
    private JButton splashToggleButton;
    private JButton wsIconButton;
    private JLabel wsIconLabel;
    private JTextField wsIconTextField;
    private JButton wsIconToggleButton;

    public JFXIconsPanel(JFXProjectProperties props, File lastFolder) {
        this.jfxProps = props;
        this.project = this.jfxProps.getProject();
        this.lastImageFolder = lastFolder;
        this.initComponents();
        this.wsIconTextField.setText(this.jfxProps.getWSIconPath());
        this.splashTextField.setText(this.jfxProps.getSplashImagePath());
        this.nativeIconTextField.setText(this.jfxProps.getNativeIconPath());
    }

    void store() {
        this.jfxProps.setWSIconPath(this.wsIconTextField.getText().trim());
        this.jfxProps.setSplashImagePath(this.splashTextField.getText().trim());
        this.jfxProps.setNativeIconPath(this.nativeIconTextField.getText().trim());
    }

    private void initComponents() {
        this.wsIconLabel = new JLabel();
        this.wsIconTextField = new JTextField();
        this.splashLabel = new JLabel();
        this.splashTextField = new JTextField();
        this.nativeIconLabel = new JLabel();
        this.nativeIconTextField = new JTextField();
        this.wsIconButton = new JButton();
        this.splashButton = new JButton();
        this.nativeIconButton = new JButton();
        this.remarkLabel = new JLabel();
        this.wsIconToggleButton = new JButton();
        this.nativeIconToggleButton = new JButton();
        this.splashToggleButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.wsIconLabel.setLabelFor(this.wsIconTextField);
        Mnemonics.setLocalizedText((JLabel)this.wsIconLabel, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.wsIconLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(14, 38, 0, 0);
        this.add((Component)this.wsIconLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 450;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(11, 4, 0, 0);
        this.add((Component)this.wsIconTextField, gridBagConstraints);
        this.wsIconTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXIconsPanel.class, (String)"AN_JFXIconsPanel.textFieldWSIcon.text"));
        this.wsIconTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXIconsPanel.class, (String)"AD_JFXIconsPanel.textFieldWSIcon.text"));
        this.splashLabel.setLabelFor(this.splashTextField);
        Mnemonics.setLocalizedText((JLabel)this.splashLabel, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.splashLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(14, 44, 0, 0);
        this.add((Component)this.splashLabel, gridBagConstraints);
        this.splashTextField.setText(NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.splashTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 450;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(11, 4, 0, 0);
        this.add((Component)this.splashTextField, gridBagConstraints);
        this.splashTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXIconsPanel.class, (String)"AN_JFXIconsPanel.textFieldSplashImage.text"));
        this.splashTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXIconsPanel.class, (String)"AD_JFXIconsPanel.textFieldSplashImage.text"));
        this.nativeIconLabel.setLabelFor(this.nativeIconTextField);
        Mnemonics.setLocalizedText((JLabel)this.nativeIconLabel, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.nativeIconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(14, 10, 0, 0);
        this.add((Component)this.nativeIconLabel, gridBagConstraints);
        this.nativeIconTextField.setText(NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.nativeIconTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 450;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(11, 4, 0, 0);
        this.add((Component)this.nativeIconTextField, gridBagConstraints);
        this.nativeIconTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXIconsPanel.class, (String)"AN_JFXIconsPanel.textFieldNativeIcon.text"));
        this.nativeIconTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXIconsPanel.class, (String)"AD_JFXIconsPanel.textFieldNativeIcon.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.wsIconButton, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.wsIconButton.text"));
        this.wsIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXIconsPanel.this.wsIconButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(9, 6, 0, 10);
        this.add((Component)this.wsIconButton, gridBagConstraints);
        this.wsIconButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXIconsPanel.class, (String)"AN_JFXIconsPanel.buttonWSIcon.text"));
        this.wsIconButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXIconsPanel.class, (String)"AD_JFXIconsPanel.buttonWSIcon.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.splashButton, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.splashButton.text"));
        this.splashButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXIconsPanel.this.splashButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(9, 6, 0, 10);
        this.add((Component)this.splashButton, gridBagConstraints);
        this.splashButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXIconsPanel.class, (String)"AN_JFXIconsPanel.buttonSplashImage.text"));
        this.splashButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXIconsPanel.class, (String)"AD_JFXIconsPanel.buttonSplashImage.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.nativeIconButton, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.nativeIconButton.text"));
        this.nativeIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXIconsPanel.this.nativeIconButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(9, 6, 0, 10);
        this.add((Component)this.nativeIconButton, gridBagConstraints);
        this.nativeIconButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXIconsPanel.class, (String)"AN_JFXIconsPanel.buttonNativeIcon.text"));
        this.nativeIconButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXIconsPanel.class, (String)"AD_JFXIconsPanel.buttonNativeIcon.text"));
        Mnemonics.setLocalizedText((JLabel)this.remarkLabel, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.remarkLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 4, 3, 0);
        this.add((Component)this.remarkLabel, gridBagConstraints);
        this.wsIconToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/javafx2/project/ui/resources/toggle_absolute_relative.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.wsIconToggleButton, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.wsIconToggleButton.text"));
        this.wsIconToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXIconsPanel.this.wsIconToggleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = -25;
        gridBagConstraints.ipady = -1;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(9, 6, 0, 0);
        this.add((Component)this.wsIconToggleButton, gridBagConstraints);
        this.wsIconToggleButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXIconsPanel.class, (String)"AN_JFXIconsPanel.buttonToggleWSIcon.text"));
        this.wsIconToggleButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXIconsPanel.class, (String)"AD_JFXIconsPanel.buttonToggleWSIcon.text"));
        this.nativeIconToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/javafx2/project/ui/resources/toggle_absolute_relative.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.nativeIconToggleButton, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.nativeIconToggleButton.text"));
        this.nativeIconToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXIconsPanel.this.nativeIconToggleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = -25;
        gridBagConstraints.ipady = -1;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(9, 6, 0, 0);
        this.add((Component)this.nativeIconToggleButton, gridBagConstraints);
        this.nativeIconToggleButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXIconsPanel.class, (String)"AN_JFXIconsPanel.buttonToggleNativeIcon.text"));
        this.nativeIconToggleButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXIconsPanel.class, (String)"AD_JFXIconsPanel.buttonToggleNativeIcon.text"));
        this.splashToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/javafx2/project/ui/resources/toggle_absolute_relative.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.splashToggleButton, (String)NbBundle.getMessage(JFXIconsPanel.class, (String)"JFXIconsPanel.splashToggleButton.text"));
        this.splashToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFXIconsPanel.this.splashToggleButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = -25;
        gridBagConstraints.ipady = -1;
        gridBagConstraints.anchor = 1280;
        gridBagConstraints.insets = new Insets(9, 6, 0, 0);
        this.add((Component)this.splashToggleButton, gridBagConstraints);
        this.splashToggleButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JFXIconsPanel.class, (String)"AN_JFXIconsPanel.buttonToggleSplashScreen.text"));
        this.splashToggleButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JFXIconsPanel.class, (String)"AD_JFXIconsPanel.buttonToggleSplashScreen.text"));
    }

    private void wsIconButtonActionPerformed(ActionEvent evt) {
        File lastFolder;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new IconFileFilter(true));
        String current = this.wsIconTextField.getText();
        File file = lastFolder = current != null ? this.getFileFromPath(current) : null;
        if (lastFolder != null) {
            chooser.setSelectedFile(lastFolder);
        } else if (this.lastImageFolder != null) {
            chooser.setSelectedFile(this.lastImageFolder);
        }
        chooser.setDialogTitle(NbBundle.getMessage(JFXIconsPanel.class, (String)"LBL_Select_Icon_Image"));
        if (0 == chooser.showOpenDialog(this)) {
            File file2 = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            String relPath = JFXProjectUtils.getRelativePath(this.project.getProjectDirectory(), FileUtil.toFileObject((File)file2));
            this.wsIconTextField.setText(relPath);
            this.lastImageFolder = file2;
        }
    }

    private void splashButtonActionPerformed(ActionEvent evt) {
        File lastFolder;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new IconFileFilter(false));
        String current = this.splashTextField.getText();
        File file = lastFolder = current != null ? this.getFileFromPath(current) : null;
        if (lastFolder != null) {
            chooser.setSelectedFile(lastFolder);
        } else if (this.lastImageFolder != null) {
            chooser.setSelectedFile(this.lastImageFolder);
        }
        chooser.setDialogTitle(NbBundle.getMessage(JFXIconsPanel.class, (String)"LBL_Select_Icon_Image"));
        if (0 == chooser.showOpenDialog(this)) {
            File file2 = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            String relPath = JFXProjectUtils.getRelativePath(this.project.getProjectDirectory(), FileUtil.toFileObject((File)file2));
            this.splashTextField.setText(relPath);
            this.lastImageFolder = file2;
        }
    }

    private void nativeIconButtonActionPerformed(ActionEvent evt) {
        File lastFolder;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(null);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new IconFileFilter(false));
        String current = this.nativeIconTextField.getText();
        File file = lastFolder = current != null ? this.getFileFromPath(current) : null;
        if (lastFolder != null) {
            chooser.setSelectedFile(lastFolder);
        } else if (this.lastImageFolder != null) {
            chooser.setSelectedFile(this.lastImageFolder);
        }
        chooser.setDialogTitle(NbBundle.getMessage(JFXIconsPanel.class, (String)"LBL_Select_Icon_Image"));
        if (0 == chooser.showOpenDialog(this)) {
            File file2 = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            String relPath = JFXProjectUtils.getRelativePath(this.project.getProjectDirectory(), FileUtil.toFileObject((File)file2));
            this.nativeIconTextField.setText(relPath);
            this.lastImageFolder = file2;
        }
    }

    private void togglePathType(@NonNull JTextField field) {
        String path = field.getText();
        if (this.isAbsolutePath(path)) {
            File file = this.getFileFromPath(path);
            String r = this.getRelativePath(file);
            if (r != null && !r.isEmpty()) {
                field.setText(r);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (this.isRelativePath(path)) {
            File file = this.getFileFromPath(path);
            String a = this.getAbsolutePath(file);
            if (a != null && !a.isEmpty()) {
                field.setText(a);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private void wsIconToggleButtonActionPerformed(ActionEvent evt) {
        this.togglePathType(this.wsIconTextField);
    }

    private void splashToggleButtonActionPerformed(ActionEvent evt) {
        this.togglePathType(this.splashTextField);
    }

    private void nativeIconToggleButtonActionPerformed(ActionEvent evt) {
        this.togglePathType(this.nativeIconTextField);
    }

    boolean isAbsolutePath(String file) {
        File f = new File(file);
        return f.exists();
    }

    boolean isRelativePath(String file) {
        File f = new File(this.project.getProjectDirectory().getPath() + File.separator + file);
        return f.exists();
    }

    File getFileFromPath(String file) {
        if (file == null || file.isEmpty()) {
            return null;
        }
        File f = new File(file);
        if (f.exists()) {
            return f.getAbsoluteFile();
        }
        f = new File(this.project.getProjectDirectory().getPath() + File.separator + file);
        if (f.exists()) {
            return f.getAbsoluteFile();
        }
        return null;
    }

    String getRelativePath(@NonNull File file) {
        return JFXProjectUtils.getRelativePath(this.project.getProjectDirectory(), FileUtil.toFileObject((File)file));
    }

    String getAbsolutePath(@NonNull File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ex) {
            return file.getAbsolutePath();
        }
    }

    public void registerDocumentListeners() {
        this.wsIconListener = new IconFieldListener(new ToggleButtonUpdater(this.wsIconToggleButton, this.wsIconTextField));
        this.wsIconTextField.getDocument().addDocumentListener(this.wsIconListener);
        this.splashListener = new IconFieldListener(new ToggleButtonUpdater(this.splashToggleButton, this.splashTextField));
        this.splashTextField.getDocument().addDocumentListener(this.splashListener);
        this.nativeIconListener = new IconFieldListener(new ToggleButtonUpdater(this.nativeIconToggleButton, this.nativeIconTextField));
        this.nativeIconTextField.getDocument().addDocumentListener(this.nativeIconListener);
        this.wsIconListener.updateComponent();
        this.splashListener.updateComponent();
        this.nativeIconListener.updateComponent();
    }

    public void unregisterDocumentListeners() {
        this.wsIconTextField.getDocument().removeDocumentListener(this.wsIconListener);
        this.splashTextField.getDocument().removeDocumentListener(this.splashListener);
        this.nativeIconTextField.getDocument().removeDocumentListener(this.nativeIconListener);
    }

    class ToggleButtonUpdater {
        private JComponent button;
        private JTextField field;

        ToggleButtonUpdater(@NonNull JComponent button, JTextField field) {
            this.button = button;
            this.field = field;
        }

        void update() {
            String path = this.field.getText();
            if (JFXIconsPanel.this.getFileFromPath(path) != null) {
                this.button.setEnabled(true);
                this.button.setToolTipText(NbBundle.getMessage(JFXIconsPanel.class, (String)"TOOLTIP_IconsPanel.togglepath.text"));
            } else {
                this.button.setEnabled(false);
                this.button.setToolTipText(NbBundle.getMessage(JFXIconsPanel.class, (String)"TOOLTIP_IconsPanel.notafile.text"));
                if (path != null && !path.isEmpty()) {
                    this.field.setToolTipText(NbBundle.getMessage(JFXIconsPanel.class, (String)"TOOLTIP_IconsPanel.notafile.text"));
                } else {
                    this.field.setToolTipText(null);
                }
            }
        }
    }

    class IconFieldListener
    implements DocumentListener {
        private ToggleButtonUpdater toggleUpdater;

        public IconFieldListener(ToggleButtonUpdater toggleUpdater) {
            this.toggleUpdater = toggleUpdater;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateComponent();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateComponent();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateComponent();
        }

        public void updateComponent() {
            if (this.toggleUpdater != null) {
                this.toggleUpdater.update();
            }
        }
    }

    private static class IconFileFilter
    extends FileFilter {
        private boolean wsOnly = false;

        public IconFileFilter(boolean forWebStart) {
            this.wsOnly = forWebStart;
        }

        @Override
        public boolean accept(File f) {
            String ext;
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            return index > 0 && index < name.length() - 1 && ("gif".equals(ext = name.substring(index + 1).toLowerCase()) || "jpg".equals(ext) || !this.wsOnly && ("png".equals(ext) || "ico".equals(ext) || "icns".equals(ext)));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(JFXIconsPanel.class, (String)"MSG_IconFileFilter_Description");
        }
    }
}

