/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.fxml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.modules.javafx2.project.fxml.FXMLTemplateWizardIterator;
import org.netbeans.modules.javafx2.project.fxml.SourceGroupSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ConfigureFXMLControllerPanelVisual
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String SPACE_CHAR = " ";
    private Panel observer;
    private boolean ignoreRootCombo;
    private RequestProcessor.Task updatePackagesTask;
    private static final ComboBoxModel WAIT_MODEL = SourceGroupSupport.getWaitModel();
    private final boolean isMaven;
    SourceGroupSupport support;
    private String previousControllerName;
    private ButtonGroup buttonGroup1;
    private JButton chooseButton;
    private JCheckBox controllerCheckBox;
    private JRadioButton createNewRadioButton;
    private JLabel createdLocation;
    private JComboBox createdLocationComboBox;
    private JLabel createdNameLabel;
    private JTextField createdNameTextField;
    private JLabel createdPackage;
    private JComboBox createdPackageComboBox;
    private JLabel existingNameLabel;
    private JTextField existingNameTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private Box.Filler filler1;
    private JRadioButton useExistingRadioButton;

    private ConfigureFXMLControllerPanelVisual(Panel observer, SourceGroupSupport support, boolean isMaven) {
        this.support = support;
        this.observer = observer;
        this.isMaven = isMaven;
        this.setName(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"TXT_ControllerNameAndLoc"));
        this.initComponents();
        this.initComponents2();
    }

    private void fireChange() {
        this.observer.fireChangeEvent();
    }

    private void initComponents2() {
        this.createdNameTextField.getDocument().addDocumentListener(this);
        this.existingNameTextField.getDocument().addDocumentListener(this);
        this.createdPackageComboBox.getEditor().addActionListener(this);
        Component packageEditor = this.createdPackageComboBox.getEditor().getEditorComponent();
        if (packageEditor instanceof JTextField) {
            ((JTextField)packageEditor).getDocument().addDocumentListener(this);
        }
        this.createdLocationComboBox.setRenderer(new SourceGroupSupport.GroupListCellRenderer());
        this.createdPackageComboBox.setRenderer(PackageView.listRenderer());
        this.createdLocationComboBox.addActionListener(this);
    }

    public void initValues(FileObject template, FileObject preselectedFolder) {
        String displayName;
        if (template == null) {
            throw new IllegalArgumentException(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"MSG_ConfigureFXMLPanel_Template_Error"));
        }
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.createdLocationComboBox.setModel(new DefaultComboBoxModel<Object>(this.support.getSourceGroups().toArray()));
        SourceGroupSupport.SourceGroupProxy preselectedGroup = this.isMaven ? SourceGroupSupport.getContainingSourceGroup(this.support, preselectedFolder) : this.support.getParent().getCurrentSourceGroup();
        this.ignoreRootCombo = true;
        this.createdLocationComboBox.setSelectedItem(preselectedGroup);
        this.ignoreRootCombo = false;
        if (this.isMaven) {
            Object preselectedPackage = FXMLTemplateWizardIterator.getPreselectedPackage(preselectedGroup, preselectedFolder);
            if (preselectedPackage != null) {
                this.createdPackageComboBox.getEditor().setItem(preselectedPackage);
            }
        } else {
            this.createdPackageComboBox.getEditor().setItem(this.support.getParent().getCurrentPackageName());
        }
        this.updatePackages();
        this.updateText();
        this.updateResult();
    }

    boolean isControllerEnabled() {
        return this.controllerCheckBox.isSelected();
    }

    public FileObject getLocationFolder() {
        Object selectedItem = this.createdLocationComboBox.getSelectedItem();
        return selectedItem instanceof SourceGroupSupport.SourceGroupProxy ? ((SourceGroupSupport.SourceGroupProxy)selectedItem).getRootFolder() : null;
    }

    public String getPackageFileName() {
        String packageName = this.createdPackageComboBox.getEditor().getItem().toString();
        return packageName.replace('.', '/');
    }

    String getPackageName() {
        return this.createdPackageComboBox.getEditor().getItem().toString();
    }

    String getNewControllerName() {
        String text = this.createdNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    String getExistingControllerName() {
        String text = this.existingNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    private void radioButtonsStateChanged() {
        if (!this.controllerCheckBox.isSelected()) {
            return;
        }
        this.createdNameLabel.setEnabled(this.createNewRadioButton.isSelected());
        this.createdNameTextField.setEnabled(this.createNewRadioButton.isSelected());
        this.existingNameLabel.setEnabled(!this.createNewRadioButton.isSelected());
        this.existingNameTextField.setEnabled(!this.createNewRadioButton.isSelected());
        this.chooseButton.setEnabled(!this.createNewRadioButton.isSelected());
        this.createdLocation.setEnabled(this.createNewRadioButton.isSelected());
        this.createdLocationComboBox.setEnabled(this.createNewRadioButton.isSelected());
        this.createdPackage.setEnabled(this.createNewRadioButton.isSelected());
        this.createdPackageComboBox.setEnabled(this.createNewRadioButton.isSelected());
        this.updateResult();
        this.fireChange();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.controllerCheckBox = new JCheckBox();
        this.createdNameLabel = new JLabel();
        this.createdNameTextField = new JTextField();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.createNewRadioButton = new JRadioButton();
        this.useExistingRadioButton = new JRadioButton();
        this.existingNameLabel = new JLabel();
        this.existingNameTextField = new JTextField();
        this.chooseButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.createdLocation = new JLabel();
        this.createdLocationComboBox = new JComboBox();
        this.createdPackage = new JLabel();
        this.createdPackageComboBox = new JComboBox();
        this.setPreferredSize(new Dimension(500, 340));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.controllerCheckBox, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.controllerCheckBox.text"));
        this.controllerCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLControllerPanelVisual.this.controllerCheckBoxItemStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.controllerCheckBox, gridBagConstraints);
        this.controllerCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.controllerCheckBox.AccessibleContext.accessibleDescription"));
        this.createdNameLabel.setLabelFor(this.createdNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdNameLabel, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createdNameLabel.text"));
        this.createdNameLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.createdNameLabel, gridBagConstraints);
        this.createdNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createdNameLabel.AccessibleContext.accessibleDescription"));
        this.createdNameTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.createdNameTextField, gridBagConstraints);
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.resultLabel.text"));
        this.fileLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(25, 15, 0, 0);
        this.add((Component)this.fileLabel, gridBagConstraints);
        this.fileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.fileLabel.AccessibleContext.accessibleDescription"));
        this.fileTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.buttonGroup1.add(this.createNewRadioButton);
        this.createNewRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createNewRadioButton, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createNewRadioButton.text"));
        this.createNewRadioButton.setEnabled(false);
        this.createNewRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLControllerPanelVisual.this.createNewRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 0, 0);
        this.add((Component)this.createNewRadioButton, gridBagConstraints);
        this.createNewRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createNewRadioButton.AccessibleContext.accessibleDescription"));
        this.buttonGroup1.add(this.useExistingRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.useExistingRadioButton, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.useExistingRadioButton.text"));
        this.useExistingRadioButton.setEnabled(false);
        this.useExistingRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigureFXMLControllerPanelVisual.this.useExistingRadioButtonItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.add((Component)this.useExistingRadioButton, gridBagConstraints);
        this.useExistingRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.useExistingRadioButton.AccessibleContext.accessibleDescription"));
        this.existingNameLabel.setLabelFor(this.existingNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.existingNameLabel, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.existingNameLabel.text"));
        this.existingNameLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 40, 0, 0);
        this.add((Component)this.existingNameLabel, gridBagConstraints);
        this.existingNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.existingNameLabel.AccessibleContext.accessibleDescription"));
        this.existingNameTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.existingNameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chooseButton, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.chooseButton.text"));
        this.chooseButton.setEnabled(false);
        this.chooseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigureFXMLControllerPanelVisual.this.chooseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.chooseButton, gridBagConstraints);
        this.chooseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.chooseButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.filler1, gridBagConstraints);
        this.createdLocation.setLabelFor(this.createdLocationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.createdLocation, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createdLocation.text"));
        this.createdLocation.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 40, 0, 0);
        this.add((Component)this.createdLocation, gridBagConstraints);
        this.createdLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.locationLabel.AccessibleContext.accessibleDescription"));
        this.createdLocationComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.createdLocationComboBox, gridBagConstraints);
        this.createdPackage.setLabelFor(this.createdPackageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.createdPackage, (String)NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.createdPackage.text"));
        this.createdPackage.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 40, 0, 0);
        this.add((Component)this.createdPackage, gridBagConstraints);
        this.createdPackage.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"ConfigureFXMLControllerPanelVisual.packageLabel.AccessibleContext.accessibleDescription"));
        this.createdPackageComboBox.setEditable(true);
        this.createdPackageComboBox.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.createdPackageComboBox, gridBagConstraints);
    }

    private void controllerCheckBoxItemStateChanged(ItemEvent evt) {
        this.createNewRadioButton.setEnabled(this.controllerCheckBox.isSelected());
        if (this.createNewRadioButton.isSelected()) {
            this.createdNameLabel.setEnabled(this.controllerCheckBox.isSelected());
            this.createdNameTextField.setEnabled(this.controllerCheckBox.isSelected());
            this.createdLocation.setEnabled(this.controllerCheckBox.isSelected());
            this.createdLocationComboBox.setEnabled(this.controllerCheckBox.isSelected());
            this.createdPackage.setEnabled(this.controllerCheckBox.isSelected());
            this.createdPackageComboBox.setEnabled(this.controllerCheckBox.isSelected());
        }
        this.useExistingRadioButton.setEnabled(this.controllerCheckBox.isSelected());
        if (this.useExistingRadioButton.isSelected()) {
            this.existingNameLabel.setEnabled(this.controllerCheckBox.isSelected());
            this.existingNameTextField.setEnabled(this.controllerCheckBox.isSelected());
            this.chooseButton.setEnabled(this.controllerCheckBox.isSelected());
        }
        this.fileLabel.setEnabled(this.controllerCheckBox.isSelected());
        this.updateResult();
        this.fireChange();
    }

    private void chooseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(new FXMLTemplateWizardIterator.SrcFileSystemView(this.support.getSourceGroupsAsFiles()));
        chooser.setDialogTitle(NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"LBL_ConfigureFXMLPanel_FileChooser_Select_Controller"));
        chooser.setFileFilter(FXMLTemplateWizardIterator.FXMLTemplateFileFilter.createJavaFilter());
        String existingPath = this.existingNameTextField.getText();
        if (existingPath.length() > 0) {
            File f = new File(this.support.getCurrentChooserFolder().getPath() + File.pathSeparator + existingPath);
            if (f.exists()) {
                chooser.setSelectedFile(f);
            } else {
                chooser.setCurrentDirectory(FileUtil.toFile((FileObject)this.support.getCurrentChooserFolder()));
            }
        } else {
            chooser.setCurrentDirectory(FileUtil.toFile((FileObject)this.support.getCurrentChooserFolder()));
        }
        if (0 == chooser.showOpenDialog(this)) {
            String controllerClass = FileUtil.normalizeFile((File)chooser.getSelectedFile()).getPath();
            String srcPath = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)this.support.getCurrentSourceGroupFolder())).getPath();
            String relativePath = controllerClass.substring(srcPath.length() + 1);
            String relativePathWithoutExt = relativePath.substring(0, relativePath.indexOf(".java"));
            this.existingNameTextField.setText(relativePathWithoutExt.replace(File.separatorChar, '.'));
        }
    }

    private void createNewRadioButtonItemStateChanged(ItemEvent evt) {
        this.radioButtonsStateChanged();
    }

    private void useExistingRadioButtonItemStateChanged(ItemEvent evt) {
        this.radioButtonsStateChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.createdLocationComboBox == e.getSource()) {
            if (!this.ignoreRootCombo) {
                this.updatePackages();
            }
            this.updateText();
            this.updateResult();
            this.fireChange();
        } else if (this.createdPackageComboBox == e.getSource()) {
            this.updateText();
            this.updateResult();
            this.fireChange();
        } else if (this.createdPackageComboBox.getEditor() == e.getSource()) {
            this.updateText();
            this.updateResult();
            this.fireChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateResult();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void updatePackages() {
        final Object item = this.createdLocationComboBox.getSelectedItem();
        if (!(item instanceof SourceGroupSupport.SourceGroupProxy)) {
            return;
        }
        WAIT_MODEL.setSelectedItem(this.createdPackageComboBox.getEditor().getItem());
        this.createdPackageComboBox.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){

            @Override
            public void run() {
                final ComboBoxModel model = ((SourceGroupSupport.SourceGroupProxy)item).getPackagesComboBoxModel();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        model.setSelectedItem(ConfigureFXMLControllerPanelVisual.this.createdPackageComboBox.getEditor().getItem());
                        ConfigureFXMLControllerPanelVisual.this.createdPackageComboBox.setModel(model);
                    }
                });
            }
        });
    }

    private void updateText() {
        String controllerName = this.getNewControllerName();
        if (controllerName == null || controllerName.equals(this.previousControllerName)) {
            controllerName = this.support.getParent().getCurrentFileName();
            if (controllerName.contains(SPACE_CHAR)) {
                String[] splittedName = controllerName.trim().split(SPACE_CHAR);
                StringBuilder sb = new StringBuilder();
                for (String part : splittedName) {
                    sb.append(String.valueOf(part.charAt(0)).toUpperCase());
                    sb.append(part.substring(1));
                }
                controllerName = sb.toString() + NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"TXT_FileNameControllerPostfix");
            } else {
                String firstChar = String.valueOf(controllerName.charAt(0)).toUpperCase();
                String otherChars = controllerName.substring(1);
                controllerName = firstChar + otherChars + NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"TXT_FileNameControllerPostfix");
            }
            this.createdNameTextField.setText(controllerName);
            this.previousControllerName = controllerName;
        }
    }

    private void updateResult() {
        String controllerName;
        String string = controllerName = this.shouldCreateController() ? this.getNewControllerName() : this.getExistingControllerName();
        if (controllerName == null) {
            this.fileTextField.setText(null);
            return;
        }
        if (this.shouldCreateController()) {
            String createdFileName;
            Object selectedItem = this.createdLocationComboBox.getSelectedItem();
            if (selectedItem instanceof SourceGroupSupport.SourceGroupProxy) {
                String path;
                SourceGroupSupport.SourceGroupProxy g = (SourceGroupSupport.SourceGroupProxy)selectedItem;
                String packageName = this.getPackageName();
                this.support.setCurrentSourceGroup(g);
                this.support.setCurrentPackageName(packageName);
                this.support.setCurrentFileName(controllerName);
                if (controllerName != null && controllerName.length() > 0) {
                    controllerName = controllerName + ".java";
                }
                createdFileName = (path = this.support.getCurrentPackagePath()) == null ? "" : path.replace(".", "/") + controllerName;
            } else {
                createdFileName = "";
            }
            this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
        } else {
            this.fileTextField.setText(this.getPathForExistingController(controllerName));
        }
    }

    private String getPathForExistingController(String controllerName) {
        assert (controllerName != null);
        return FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)this.support.getCurrentSourceGroupFolder())).getPath() + File.separatorChar + controllerName.replace('.', File.separatorChar) + ".java";
    }

    String isControllerValid() {
        if (!this.isControllerEnabled()) {
            return null;
        }
        if (this.createNewRadioButton.isSelected()) {
            if (!Utilities.isJavaIdentifier((String)this.getNewControllerName())) {
                return NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"WARN_ConfigureFXMLPanel_Provide_Java_Name");
            }
            return FXMLTemplateWizardIterator.canUseFileName(FileUtil.toFile((FileObject)this.support.getCurrentChooserFolder()), this.getNewControllerName());
        }
        if (this.existingNameTextField.getText().isEmpty()) {
            return NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)"WARN_ConfigureFXMLPanel_Provide_Java_Name");
        }
        return FXMLTemplateWizardIterator.fileExist(this.getPathForExistingController(this.getExistingControllerName()));
    }

    boolean shouldCreateController() {
        return this.controllerCheckBox.isSelected() && this.createNewRadioButton.isSelected();
    }

    static class Panel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    WizardDescriptor.FinishablePanel<WizardDescriptor> {
        private ConfigureFXMLControllerPanelVisual component;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private WizardDescriptor settings;
        SourceGroupSupport support;

        public Panel(SourceGroupSupport support, boolean isMaven) {
            this.support = support;
            this.component = new ConfigureFXMLControllerPanelVisual(this, support, isMaven);
        }

        public Component getComponent() {
            return this.component;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void readSettings(WizardDescriptor settings) {
            this.settings = settings;
            FileObject preselectedFolder = Templates.getTargetFolder((WizardDescriptor)settings);
            this.component.initValues(Templates.getTemplate((WizardDescriptor)settings), preselectedFolder);
            Object substitute = this.component.getClientProperty("NewFileWizard_Title");
            if (substitute != null) {
                settings.putProperty("NewFileWizard_Title", substitute);
            }
        }

        public void storeSettings(WizardDescriptor settings) {
            Object value = settings.getValue();
            if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
                return;
            }
            if (this.isValid()) {
                settings.putProperty("javaControllerEnabled", (Object)this.component.isControllerEnabled());
                settings.putProperty("javaController", this.component.shouldCreateController() ? this.component.getNewControllerName() : null);
                settings.putProperty("javaControllerExisting", (Object)this.component.getExistingControllerName());
            }
            settings.putProperty("NewFileWizard_Title", null);
        }

        public boolean isValid() {
            if (this.component.isControllerEnabled()) {
                if (!FXMLTemplateWizardIterator.isValidPackageName(this.component.getPackageName())) {
                    FXMLTemplateWizardIterator.setErrorMessage("WARN_ConfigureFXMLPanel_Provide_Package_Name", this.settings);
                    return false;
                }
                if (JFXProjectUtils.hasModuleInfo(this.support) && this.component.getPackageName().isEmpty()) {
                    FXMLTemplateWizardIterator.setErrorMessage("WARN_ConfigureFXMLPanel_Default_Package_Invalid", this.settings);
                    return false;
                }
                if (!FXMLTemplateWizardIterator.isValidPackage(this.component.getLocationFolder(), this.component.getPackageName())) {
                    FXMLTemplateWizardIterator.setErrorMessage("WARN_ConfigureFXMLPanel_Package_Invalid", this.settings);
                    return false;
                }
                String errorMessage = this.component.isControllerValid();
                this.settings.getNotificationLineSupport().setErrorMessage(errorMessage);
                return errorMessage == null;
            }
            this.settings.getNotificationLineSupport().setErrorMessage(null);
            return true;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        private void fireChangeEvent() {
            this.changeSupport.fireChange();
        }

        public boolean isFinishPanel() {
            return true;
        }
    }
}

