/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import org.eclipse.tm4e.core.internal.oniguruma.IOnigCaptureIndex;
import org.eclipse.tm4e.core.internal.oniguruma.IOnigNextMatchResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;

class OnigNextMatchResult
implements IOnigNextMatchResult {
    private final int index;
    private final IOnigCaptureIndex[] captureIndices;

    public OnigNextMatchResult(OnigResult result, OnigString source) {
        this.index = result.getIndex();
        this.captureIndices = OnigNextMatchResult.captureIndicesForMatch(result, source);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public IOnigCaptureIndex[] getCaptureIndices() {
        return this.captureIndices;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{\n");
        result.append("  \"index\": ");
        result.append(this.getIndex());
        result.append(",\n");
        result.append("  \"captureIndices\": [\n");
        int i = 0;
        for (IOnigCaptureIndex captureIndex : this.getCaptureIndices()) {
            if (i > 0) {
                result.append(",\n");
            }
            result.append("    ");
            result.append(captureIndex);
            ++i;
        }
        result.append("\n");
        result.append("  ]\n");
        result.append("}");
        return result.toString();
    }

    private static IOnigCaptureIndex[] captureIndicesForMatch(OnigResult result, OnigString source) {
        int resultCount = result.count();
        IOnigCaptureIndex[] captures = new IOnigCaptureIndex[resultCount];
        for (int index = 0; index < resultCount; ++index) {
            int captureStart = source.convertUtf8OffsetToUtf16(result.locationAt(index));
            int captureEnd = source.convertUtf8OffsetToUtf16(result.locationAt(index) + result.lengthAt(index));
            captures[index] = new OnigCaptureIndex(index, captureStart, captureEnd);
        }
        return captures;
    }

    private static class OnigCaptureIndex
    implements IOnigCaptureIndex {
        private final int index;
        private final int start;
        private final int end;

        public OnigCaptureIndex(int index, int start, int end) {
            this.index = index;
            this.start = start >= 0 ? start : 0;
            this.end = end >= 0 ? end : 0;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public int getLength() {
            return this.end - this.start;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("{\"index\": ");
            result.append(this.getIndex());
            result.append(", \"start\": ");
            result.append(this.getStart());
            result.append(", \"end\": ");
            result.append(this.getEnd());
            result.append(", \"length\": ");
            result.append(this.getLength());
            result.append("}");
            return result.toString();
        }
    }
}

