/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support.debug;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SmartSteppingCallback;

public class GroovySmartStepping
extends SmartSteppingCallback {
    private static final String[] GROOVY_PACKAGES = new String[]{"org.codehaus.groovy.", "org.apache.groovy.", "groovy.", "groovyjar"};
    private static final Set<String> PATTERNS_SKIP_IN_GROOVY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.", "jdk.internal.", "sun.", "com.sun.")));
    private static final Set<String> FILTERS_SKIP_IN_GROOVY = PATTERNS_SKIP_IN_GROOVY.stream().map(pattern -> pattern + '*').collect(Collectors.toSet());
    private static final Logger logger = Logger.getLogger(GroovySmartStepping.class.getName());
    private final Map<SmartSteppingFilter, Boolean> steppingInGroovy = Collections.synchronizedMap(new WeakHashMap());

    public void initFilter(SmartSteppingFilter filter) {
    }

    public boolean stopHere(ContextProvider lookupProvider, JPDAThread thread, SmartSteppingFilter filter) {
        return true;
    }

    public SmartSteppingCallback.StopOrStep stopAt(ContextProvider lookupProvider, CallStackFrame frame, SmartSteppingFilter filter) {
        String className = frame.getClassName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("GroovySmartStepping.stopAt(" + className + ")");
        }
        JPDAThread thread = frame.getThread();
        boolean inGroovy = false;
        for (String gp : GROOVY_PACKAGES) {
            if (!className.startsWith(gp)) continue;
            inGroovy = true;
            this.steppingInGroovy.put(filter, true);
            break;
        }
        if (inGroovy) {
            logger.fine(" => In Groovy: Step In");
            return SmartSteppingCallback.StopOrStep.step((int)0, (int)1);
        }
        if (Boolean.TRUE.equals(this.steppingInGroovy.get(filter))) {
            if (GroovySmartStepping.isPackageToSkip(className)) {
                logger.fine(" => Was In Groovy: Step In");
                filter.addExclusionPatterns(FILTERS_SKIP_IN_GROOVY);
                return SmartSteppingCallback.StopOrStep.step((int)0, (int)1);
            }
            logger.fine(" => FINISHED, stop");
            return SmartSteppingCallback.StopOrStep.stop();
        }
        logger.fine(" => FINISHED (no Groovy), stop");
        return SmartSteppingCallback.StopOrStep.stop();
    }

    private static boolean isPackageToSkip(String className) {
        for (String pattern : PATTERNS_SKIP_IN_GROOVY) {
            if (!className.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }
}

