/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.JsonPrimitive;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.templates.CreateDescriptor;
import org.netbeans.api.templates.FileBuilder;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.ShowInputBoxParams;
import org.netbeans.modules.java.lsp.server.protocol.ShowQuickPickParams;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;

final class LspTemplateUI {
    private static final RequestProcessor CREATION_RP = new RequestProcessor(LspTemplateUI.class);
    private static final Logger LOG = Logger.getLogger(LspTemplateUI.class.getName());
    private static final String ATTR_SOURCE_GROUP = "new.sourceGroup";
    private static final String ATTR_SOURCE_HINT = "new.sourceHint";

    private LspTemplateUI() {
    }

    static CompletableFuture<Object> createFromTemplate(String templates, NbCodeLanguageClient client, ExecuteCommandParams params) {
        FileObject fo = FileUtil.getConfigFile((String)templates);
        DataFolder folder = DataFolder.findFolder((FileObject)fo);
        return new LspTemplateUI().templateUI(folder, client, params);
    }

    static CompletableFuture<Object> createProject(String templates, NbCodeLanguageClient client, ExecuteCommandParams params) {
        FileObject fo = FileUtil.getConfigFile((String)templates);
        DataFolder folder = DataFolder.findFolder((FileObject)fo);
        return new LspTemplateUI().projectUI(folder, client, params);
    }

    private CompletableFuture<Object> templateUI(DataFolder templates, NbCodeLanguageClient client, ExecuteCommandParams params) {
        CompletionStage<DataObject> findTemplate = LspTemplateUI.findTemplate(templates, client);
        CompletionStage<DataFolder> findTargetFolder = LspTemplateUI.findTargetForTemplate(findTemplate, client, params);
        return findTargetFolder.thenCombine(findTemplate, (target, source) -> {
            FileObject templateFileObject = source.getPrimaryFile();
            return new FileBuilder(templateFileObject, target.getPrimaryFile()).name(templateFileObject.getName());
        }).thenCompose(builder -> LspTemplateUI.configure(builder, client)).thenApplyAsync(builder -> {
            try {
                if (builder != null) {
                    List created = builder.build();
                    if (created == null) {
                        return null;
                    }
                    if (created.isEmpty()) {
                        return Collections.emptyList();
                    }
                    IndexingManager.getDefault().refreshAllIndices(false, true, created.toArray(new FileObject[0]));
                    return created.stream().map(fo -> fo.toURI().toString()).collect(Collectors.toList());
                }
                return null;
            }
            catch (IOException ex) {
                throw LspTemplateUI.raise(RuntimeException.class, ex);
            }
        }, (Executor)CREATION_RP).exceptionally(error -> {
            if (error instanceof UserCancelException || error.getCause() instanceof UserCancelException) {
                return null;
            }
            Exceptions.printStackTrace((Throwable)error);
            return null;
        }).toCompletableFuture();
    }

    private CompletableFuture<Object> projectUI(DataFolder templates, NbCodeLanguageClient client, ExecuteCommandParams params) {
        CompletionStage<DataObject> findTemplate = LspTemplateUI.findTemplate(templates, client);
        CompletionStage<Pair<DataFolder, String>> findTargetFolderAndName = LspTemplateUI.findTargetAndNameForProject(findTemplate, client, params);
        CompletionStage<Pair> findTemplateAndPackage = findTemplate.thenCombine(LspTemplateUI.findPackage(findTargetFolderAndName, client), Pair::of);
        return findTargetFolderAndName.thenCombineAsync(findTemplateAndPackage, (targetAndName, templateAndPackage) -> {
            try {
                DataObject template = (DataObject)templateAndPackage.first();
                String pkg = (String)templateAndPackage.second();
                DataFolder target = (DataFolder)targetAndName.first();
                String name = (String)targetAndName.second();
                HashMap<String, String> prjParams = new HashMap<String, String>();
                prjParams.put("package", pkg);
                prjParams.put("packageBase", pkg);
                DataObject newObject = template.createFromTemplate(target, name, prjParams);
                return newObject.getPrimaryFile().toURI().toString();
            }
            catch (IOException ex) {
                throw LspTemplateUI.raise(RuntimeException.class, ex);
            }
        }, (Executor)CREATION_RP).exceptionally(error -> {
            if (error instanceof UserCancelException || error.getCause() instanceof UserCancelException) {
                return null;
            }
            Exceptions.printStackTrace((Throwable)error);
            return null;
        }).toCompletableFuture();
    }

    private static CompletionStage<String> findPackage(CompletionStage<?> uiBefore, NbCodeLanguageClient client) {
        return uiBefore.thenCompose(__ -> client.showInputBox(new ShowInputBoxParams(Bundle.CTL_TemplateUI_SelectPackageName(), Bundle.CTL_TemplateUI_SelectPackageNameSuggestion())));
    }

    private static CompletionStage<DataFolder> findTargetForTemplate(CompletionStage<DataObject> findTemplate, final NbCodeLanguageClient client, ExecuteCommandParams params) {
        DataObject[] templateObject = new DataObject[1];
        return findTemplate.thenCompose(any -> {
            templateObject[0] = any;
            return client.workspaceFolders();
        }).thenCompose(folders -> {
            boolean[] suggestionIsExact = new boolean[]{true};
            final DataFolder suggestion = LspTemplateUI.findTargetFolder(params, templateObject[0], folders, suggestionIsExact);
            if (suggestionIsExact[0]) {
                return CompletableFuture.completedFuture(suggestion);
            }
            class VerifyPath
            implements Function<String, CompletionStage<DataFolder>> {
                VerifyPath() {
                }

                @Override
                public CompletionStage<DataFolder> apply(String path) {
                    if (path == null) {
                        throw (RuntimeException)LspTemplateUI.raise(RuntimeException.class, (Exception)new UserCancelException(path));
                    }
                    FileObject fo = FileUtil.toFileObject((File)new File(path));
                    if (fo == null || !fo.isFolder()) {
                        client.showMessage(new MessageParams(MessageType.Error, Bundle.ERR_InvalidPath(path)));
                        return client.showInputBox(new ShowInputBoxParams(Bundle.CTL_TemplateUI_SelectTarget(), suggestion.getPrimaryFile().getPath())).thenCompose((Function)this);
                    }
                    return CompletableFuture.completedFuture(DataFolder.findFolder((FileObject)fo));
                }
            }
            return client.showInputBox(new ShowInputBoxParams(Bundle.CTL_TemplateUI_SelectTarget(), suggestion.getPrimaryFile().getPath())).thenCompose((Function)new VerifyPath());
        });
    }

    private static CompletionStage<Pair<DataFolder, String>> findTargetAndNameForProject(CompletionStage<DataObject> findTemplate, final NbCodeLanguageClient client, ExecuteCommandParams params) {
        return findTemplate.thenCompose(__ -> client.workspaceFolders()).thenCompose(folders -> {
            class VerifyNonExistingFolder
            implements Function<String, CompletionStage<Pair<DataFolder, String>>> {
                final /* synthetic */ List val$folders;

                VerifyNonExistingFolder() {
                    this.val$folders = list;
                }

                @Override
                public CompletionStage<Pair<DataFolder, String>> apply(String path) {
                    if (path == null) {
                        throw (RuntimeException)LspTemplateUI.raise(RuntimeException.class, (Exception)new UserCancelException(path));
                    }
                    File targetPath = new File(path);
                    if (targetPath.exists()) {
                        client.showMessage(new MessageParams(MessageType.Error, Bundle.ERR_ExistingPath(path)));
                        return client.showInputBox(new ShowInputBoxParams(Bundle.CTL_TemplateUI_SelectProjectTarget(), LspTemplateUI.suggestWorkspaceRoot(this.val$folders))).thenCompose((Function)this);
                    }
                    targetPath.getParentFile().mkdirs();
                    FileObject fo = FileUtil.toFileObject((File)targetPath.getParentFile());
                    if (fo == null || !fo.isFolder()) {
                        // empty if block
                    }
                    return CompletableFuture.completedFuture(Pair.of((Object)DataFolder.findFolder((FileObject)fo), (Object)targetPath.getName()));
                }
            }
            return client.showInputBox(new ShowInputBoxParams(Bundle.CTL_TemplateUI_SelectProjectTarget(), LspTemplateUI.suggestWorkspaceRoot(folders))).thenCompose((Function)new VerifyNonExistingFolder());
        });
    }

    private static CompletionStage<FileBuilder> configure(FileBuilder builder, NbCodeLanguageClient client) {
        CreateDescriptor desc = builder.createDescriptor(false);
        FileObject template = desc.getTemplate();
        Object handler = template.getAttribute("template.createTemplateHandler");
        if (handler == null) {
            return client.showInputBox(new ShowInputBoxParams(Bundle.CTL_TemplateUI_SelectName(), desc.getProposedName())).thenApply(name -> name != null ? builder.name(name) : null);
        }
        return CompletableFuture.completedFuture(builder);
    }

    private static String suggestWorkspaceRoot(List<WorkspaceFolder> folders) throws IllegalArgumentException {
        String suggestion = System.getProperty("user.home");
        if (folders != null && !folders.isEmpty()) {
            try {
                suggestion = Utilities.toFile((URI)new URI(folders.get(0).getUri())).getParent();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return suggestion;
    }

    private static CompletionStage<DataObject> findTemplate(DataFolder templates, NbCodeLanguageClient client) {
        List<QuickPickItem> categories = LspTemplateUI.quickPickTemplates(templates);
        CompletableFuture<List<QuickPickItem>> pickGroup = client.showQuickPick(new ShowQuickPickParams(Bundle.CTL_TemplateUI_SelectGroup(), false, categories));
        CompletionStage<DataFolder> group = pickGroup.thenApply(selectedGroups -> {
            String chosen = LspTemplateUI.singleSelection(selectedGroups);
            FileObject chosenFo = templates.getPrimaryFile().getFileObject(chosen);
            return DataFolder.findFolder((FileObject)chosenFo);
        });
        CompletionStage<DataFolder> pickProject = group.thenCompose(chosenGroup -> {
            List<QuickPickItem> projectTypes = LspTemplateUI.quickPickTemplates(chosenGroup);
            return client.showQuickPick(new ShowQuickPickParams(Bundle.CTL_TemplateUI_SelectTemplate(), false, projectTypes));
        });
        CompletionStage<DataObject> findTemplate = pickProject.thenCombine(group, (selectedTemplates, chosenGroup) -> {
            try {
                String templateName = LspTemplateUI.singleSelection(selectedTemplates);
                FileObject templateFo = chosenGroup.getPrimaryFile().getFileObject(templateName);
                return DataObject.find((FileObject)templateFo);
            }
            catch (DataObjectNotFoundException ex) {
                throw LspTemplateUI.raise(RuntimeException.class, (Exception)((Object)ex));
            }
        });
        return findTemplate;
    }

    private static DataFolder findWorkspaceRoot(List<WorkspaceFolder> folders) {
        for (WorkspaceFolder f : folders) {
            try {
                FileObject fo = URLMapper.findFileObject((URL)new URL(f.getUri()));
                if (fo == null || !fo.isFolder()) continue;
                return DataFolder.findFolder((FileObject)fo);
            }
            catch (MalformedURLException ex) {
            }
        }
        String root = System.getProperty("user.home");
        return DataFolder.findFolder((FileObject)FileUtil.toFileObject((File)new File(root)));
    }

    private static String singleSelection(List<QuickPickItem> selectedGroups) {
        if (selectedGroups == null || selectedGroups.size() != 1) {
            throw LspTemplateUI.raise(RuntimeException.class, (Exception)new UserCancelException(""));
        }
        return selectedGroups.get(0).getUserData().toString();
    }

    private static DataFolder findTargetFolder(ExecuteCommandParams params, DataObject template, List<WorkspaceFolder> folders, boolean[] defaultTargetExact) {
        String sourceGroup = null;
        String sourceHint = null;
        Project p = null;
        SourceGroup[] groups = null;
        for (FileObject f = template.getPrimaryFile(); f != null && (sourceGroup == null || sourceHint == null); f = f.getParent()) {
            Object o;
            if (sourceGroup == null && (o = f.getAttribute(ATTR_SOURCE_GROUP)) != null) {
                sourceGroup = o.toString();
            }
            if (sourceHint != null || (o = f.getAttribute(ATTR_SOURCE_HINT)) == null) continue;
            sourceHint = o.toString();
        }
        LOG.log(Level.FINER, "Template: {2}, Source group: {0}, hint: {1}", new Object[]{template.getPrimaryFile().getPath(), sourceGroup, sourceHint});
        int index = 0;
        block3: for (Object arg : params.getArguments()) {
            String path;
            ++index;
            if (arg == null) continue;
            if (arg instanceof JsonPrimitive) {
                JsonPrimitive jp = (JsonPrimitive)arg;
                path = jp.getAsString();
            } else {
                path = arg.toString();
            }
            try {
                FileObject fo = URLMapper.findFileObject((URL)new URL(path));
                while (true) {
                    if (fo == null) {
                        LOG.log(Level.FINER, "Got non-file at param #{0}.", index);
                        continue block3;
                    }
                    if (fo.isFolder()) break;
                    fo = fo.getParent();
                    defaultTargetExact[0] = false;
                }
                if (p == null) {
                    p = FileOwnerQuery.getOwner((FileObject)fo);
                }
                if (sourceGroup != null) {
                    if (groups == null && p != null) {
                        SourceGroup sg;
                        LOG.log(Level.FINER, "Target project found: {0}", p);
                        if (sourceHint != null && (sg = SourceGroupModifier.createSourceGroup((Project)p, (String)sourceGroup, (String)sourceHint)) != null) {
                            LOG.log(Level.FINER, "Specific source group found / created: {0}", sg);
                            groups = new SourceGroup[]{sg};
                        }
                        if (groups == null && (groups = ProjectUtils.getSources((Project)p).getSourceGroups(sourceGroup)) != null) {
                            LOG.log(Level.FINER, "Container source groups of type: {0} : {1} ", Arrays.asList(sourceGroup, Arrays.asList(groups)));
                        }
                    }
                    if (groups != null) {
                        for (void var17_19 : groups) {
                            if (!fo.equals(var17_19.getRootFolder()) && !FileUtil.isParentOf((FileObject)var17_19.getRootFolder(), (FileObject)fo)) continue;
                            LOG.log(Level.FINER, "Selected target candidate: {0}", fo);
                            return DataFolder.findFolder((FileObject)fo);
                        }
                    }
                    if (!defaultTargetExact[0] || p != null && fo.equals(p.getProjectDirectory())) continue;
                }
                return DataFolder.findFolder((FileObject)fo);
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        defaultTargetExact[0] = false;
        if (groups != null && groups.length > 0) {
            return DataFolder.findFolder((FileObject)groups[0].getRootFolder());
        }
        return LspTemplateUI.findWorkspaceRoot(folders);
    }

    private static List<QuickPickItem> quickPickTemplates(DataFolder folder) {
        Node[] arr = folder.getNodeDelegate().getChildren().getNodes(true);
        ArrayList<QuickPickItem> categories = new ArrayList<QuickPickItem>();
        for (Node n : arr) {
            Object cathegory;
            Object simple;
            FileObject fo = (FileObject)n.getLookup().lookup(FileObject.class);
            DataObject obj = (DataObject)n.getLookup().lookup(DataObject.class);
            boolean display = obj instanceof DataFolder ? ((simple = fo.getAttribute("simple")) != null ? Boolean.TRUE.equals(simple) : ("invisible".equals(cathegory = fo.getAttribute("templateCategory")) ? false : ("helper-files".equals(cathegory) ? false : fo.getChildren().length > 0))) : obj.isTemplate();
            if (!display) continue;
            String detail = LspTemplateUI.findDetail(obj);
            String displayName = n.getDisplayName();
            categories.add(new QuickPickItem(displayName, null, detail, false, fo.getNameExt()));
        }
        return categories;
    }

    private static String findDetail(DataObject obj) {
        URL description = TemplateWizard.getDescription((DataObject)obj);
        String descriptionText = null;
        if (description != null) {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();
                 InputStream is = description.openStream();){
                FileUtil.copy((InputStream)is, (OutputStream)os);
                String s = os.toString("UTF-8");
                descriptionText = LspTemplateUI.stripHtml(s);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)ex, (Level)Level.FINE));
                return descriptionText;
            }
        }
        return descriptionText;
    }

    static String stripHtml(String s) {
        boolean inTag = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (inTag) {
                if (ch != '>') continue;
                inTag = false;
                continue;
            }
            if (ch == '<') {
                inTag = true;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static <T extends Exception> T raise(Class<T> clazz, Exception ex) throws T {
        throw ex;
    }
}

