/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.lsp.server.explorer.PathFinder;
import org.netbeans.modules.java.lsp.server.explorer.api.ExplorerManagerFactory;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ProjectExplorer
implements ExplorerManagerFactory,
PathFinder {
    static final String ID_PROJECT_LOGICAL_VIEW = "foundProjects";
    private static final RequestProcessor PROJECT_INIT_RP = new RequestProcessor(ProjectExplorer.class.getName());

    @Override
    public CompletionStage<ExplorerManager> createManager(String id, Lookup context) {
        if (!ID_PROJECT_LOGICAL_VIEW.equals(id)) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> OpenProjects.getDefault().createLogicalView(), (Executor)PROJECT_INIT_RP);
    }

    @Override
    public Node findPath(Node root, Object target) {
        FileObject file = null;
        if (target instanceof FileObject) {
            file = (FileObject)target;
        } else {
            URI uri = null;
            if (target instanceof String) {
                uri = URI.create(target.toString());
            } else if (target instanceof URI) {
                uri = (URI)target;
            }
            if (uri == null) {
                return null;
            }
            try {
                file = URLMapper.findFileObject((URL)uri.toURL());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
        if (file == null) {
            return null;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)file);
        if (p == null) {
            return null;
        }
        Node[] projectChildren = root.getChildren().getNodes(true);
        if (projectChildren.length == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            projectChildren = root.getChildren().getNodes(true);
        }
        for (Node n : projectChildren) {
            org.netbeans.spi.project.ui.PathFinder ppf;
            Project nodeProject = (Project)n.getLookup().lookup(Project.class);
            if (nodeProject != p || (ppf = (org.netbeans.spi.project.ui.PathFinder)p.getLookup().lookup(org.netbeans.spi.project.ui.PathFinder.class)) == null) continue;
            return ppf.findPath(n, (Object)file);
        }
        return null;
    }
}

