/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.completion;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.swing.ImageIcon;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.taginfo.AttrValueType;
import org.netbeans.modules.web.common.taginfo.LibraryMetadata;
import org.netbeans.modules.web.common.taginfo.TagAttrMetadata;
import org.netbeans.modules.web.common.taginfo.TagMetadata;
import org.netbeans.modules.web.common.ui.api.FileReferenceCompletion;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.completion.JsfCompletionItem;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryMetadata;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.LibraryInfo;
import org.netbeans.modules.web.jsfapi.api.NamespaceUtils;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfAttributesCompletionHelper {
    private static final FilenameSupport FILENAME_SUPPORT = new FilenameSupport();
    private static final Map<String, Set<String>> HTML_TO_JSF_MAPPING = new HashMap<String, Set<String>>();

    private JsfAttributesCompletionHelper() {
    }

    public static List<CompletionItem> getJsfItemsForHtmlElement(HtmlExtension.CompletionContext context, Library htmlLibrary, String prefix) {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
        OpenTag ot = (OpenTag)context.getCurrentNode();
        Set<String> mapped = HTML_TO_JSF_MAPPING.get(ot.name().toString());
        if (mapped == null) {
            return Collections.emptyList();
        }
        String prefixNs = prefix.substring(0, prefix.indexOf(":"));
        String prefixValue = prefix.substring(prefix.indexOf(":") + 1);
        for (String jsfComponent : mapped) {
            JsfAttributesCompletionHelper.completeAttributes(context, result, prefixNs, htmlLibrary, jsfComponent, prefixValue);
        }
        return result;
    }

    public static void completeAttributes(HtmlExtension.CompletionContext context, List<CompletionItem> items, String attrPrefix, Library lib, String component, String prefix) {
        Tag tag;
        OpenTag ot = (OpenTag)context.getCurrentNode();
        LibraryComponent comp = lib.getComponent(component);
        if (comp != null && (tag = comp.getTag()) != null) {
            Collection attrs = tag.getAttributes();
            ArrayList<String> existingAttrNames = new ArrayList<String>();
            for (Attribute a : ot.attributes()) {
                existingAttrNames.add(a.name().toString());
            }
            int replaceOffset = attrPrefix.isEmpty() ? context.getCCItemStartOffset() : context.getCCItemStartOffset() + attrPrefix.length() + 1;
            for (org.netbeans.modules.web.jsfapi.api.Attribute a : attrs) {
                String attrName = a.getName();
                if (existingAttrNames.contains(attrName) && !existingAttrNames.contains(context.getItemText()) || JsfAttributesCompletionHelper.containsCCEntry(items, attrName)) continue;
                items.add((CompletionItem)JsfCompletionItem.createAttribute(attrName, replaceOffset, lib, tag, a));
            }
        }
        if (!prefix.isEmpty()) {
            Iterator<CompletionItem> itr = items.iterator();
            while (itr.hasNext()) {
                CharSequence insertPrefix = itr.next().getInsertPrefix();
                if (insertPrefix == null || CharSequenceUtilities.startsWith((CharSequence)insertPrefix, (CharSequence)prefix)) continue;
                itr.remove();
            }
        }
    }

    private static boolean containsCCEntry(List<CompletionItem> items, String entry) {
        for (CompletionItem completionItem : items) {
            if (!completionItem.getInsertPrefix().equals(entry)) continue;
            return true;
        }
        return false;
    }

    public static void completeJavaClasses(final HtmlExtension.CompletionContext context, final List<CompletionItem> items, String ns, OpenTag openTag) {
        String tagName = openTag.unqualifiedName().toString();
        String attrName = context.getAttributeName();
        if (NamespaceUtils.containsNsOf(Collections.singleton(ns), (DefaultLibraryInfo)DefaultLibraryInfo.COMPOSITE) && "attribute".equalsIgnoreCase(tagName) && "type".equalsIgnoreCase(attrName)) {
            FileObject fileObject = context.getResult().getSnapshot().getSource().getFileObject();
            JavaSource js = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)fileObject), (FileObject[])new FileObject[0]);
            if (js == null) {
                return;
            }
            try {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        String prefix = context.getPrefix();
                        String packageName = context.getPrefix();
                        int dotIndex = prefix.lastIndexOf(46);
                        if (dotIndex != -1) {
                            packageName = prefix.substring(0, dotIndex);
                        }
                        JsfAttributesCompletionHelper.addPackages(context, cc, items, prefix);
                        JsfAttributesCompletionHelper.addTypesFromPackages(context, cc, items, prefix, packageName);
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static void addPackages(HtmlExtension.CompletionContext context, CompilationController controler, List<CompletionItem> items, String prefix) {
        int dotOffset = prefix.lastIndexOf(46);
        for (String pkgName : controler.getClasspathInfo().getClassIndex().getPackageNames(prefix, true, EnumSet.of(ClassIndex.SearchScope.SOURCE))) {
            items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)pkgName.substring(dotOffset == -1 ? 0 : dotOffset + 1), (int)(context.getCCItemStartOffset() + (dotOffset == -1 ? 0 : dotOffset + 1))));
        }
    }

    private static void addTypesFromPackages(HtmlExtension.CompletionContext context, CompilationController cc, List<CompletionItem> items, String prefix, String packageName) {
        int dotOffset = prefix.lastIndexOf(46);
        PackageElement pkgElem = cc.getElements().getPackageElement(packageName);
        if (pkgElem == null) {
            return;
        }
        List tes = (List)new TypeScanner().scan(pkgElem);
        for (TypeElement te : tes) {
            if (!te.getQualifiedName().toString().startsWith(prefix)) continue;
            items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)te.getSimpleName().toString(), (int)(context.getCCItemStartOffset() + (dotOffset == -1 ? 0 : dotOffset + 1))));
        }
    }

    public static void completeSectionsOfTemplate(final HtmlExtension.CompletionContext context, final List<CompletionItem> items, String ns, OpenTag openTag) {
        String tagName = openTag.unqualifiedName().toString();
        String attrName = context.getAttributeName();
        if (NamespaceUtils.containsNsOf(Collections.singleton(ns), (DefaultLibraryInfo)DefaultLibraryInfo.FACELETS) && "define".equalsIgnoreCase(tagName) && "name".equalsIgnoreCase(attrName)) {
            Node root = JsfUtils.getRoot(context.getResult(), (LibraryInfo)DefaultLibraryInfo.FACELETS);
            final String[] template = new String[1];
            ElementUtils.visitChildren((Element)root, (ElementVisitor)new ElementVisitor(){

                public void visit(Element node) {
                    OpenTag openTag = (OpenTag)node;
                    if ("composition".equalsIgnoreCase(openTag.unqualifiedName().toString())) {
                        for (Attribute attribute : openTag.attributes()) {
                            if (!"template".equalsIgnoreCase(attribute.name().toString())) continue;
                            template[0] = attribute.unquotedValue().toString();
                        }
                    }
                }
            }, (ElementType)ElementType.OPEN_TAG);
            if (template[0] == null) {
                return;
            }
            List<Source> candidates = JsfAttributesCompletionHelper.getTemplateCandidates(context.getResult().getSnapshot().getSource().getFileObject(), template[0]);
            try {
                ParserManager.parse(candidates, (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        HtmlParserResult htmlResult;
                        Node root;
                        Parser.Result result = resultIterator.getParserResult(0);
                        if (result.getSnapshot().getMimeType().equals("text/html") && (root = JsfUtils.getRoot(htmlResult = (HtmlParserResult)result, (LibraryInfo)DefaultLibraryInfo.FACELETS)) != null) {
                            List foundNodes = JsfAttributesCompletionHelper.findValue(root.children(OpenTag.class), JsfAttributesCompletionHelper.getPrefixForFaceletsNs(htmlResult) + ":insert", new ArrayList());
                            for (OpenTag node : foundNodes) {
                                String value;
                                Attribute attr = node.getAttribute("name");
                                if (attr == null || (value = attr.unquotedValue().toString()) == null || "".equals(value)) continue;
                                items.add(HtmlCompletionItem.createAttributeValue((String)value, (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
                            }
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static String getPrefixForFaceletsNs(HtmlParserResult result) {
        String prefix = (String)result.getNamespaces().get(DefaultLibraryInfo.FACELETS.getNamespace());
        if (prefix != null) {
            return prefix;
        }
        return (String)result.getNamespaces().get(DefaultLibraryInfo.FACELETS.getLegacyNamespace());
    }

    private static List<OpenTag> findValue(Collection<OpenTag> nodes, String tagName, List<OpenTag> foundNodes) {
        if (nodes == null) {
            return foundNodes;
        }
        for (OpenTag ot : nodes) {
            if (LexerUtils.equals((CharSequence)tagName, (CharSequence)ot.name(), (boolean)true, (boolean)false)) {
                foundNodes.add(ot);
                continue;
            }
            foundNodes = JsfAttributesCompletionHelper.findValue(ot.children(OpenTag.class), tagName, foundNodes);
        }
        return foundNodes;
    }

    private static List<Source> getTemplateCandidates(FileObject client, String path) {
        Project project;
        WebModule wm;
        ArrayList<Source> result = new ArrayList<Source>();
        FileObject template = client.getParent().getFileObject(path);
        if (template != null) {
            result.add(Source.create((FileObject)template));
        }
        if ((wm = WebModule.getWebModule((FileObject)(project = FileOwnerQuery.getOwner((FileObject)client)).getProjectDirectory())) != null && wm.getDocumentBase() != null) {
            JsfAttributesCompletionHelper.handleContracts(wm.getDocumentBase(), path, result);
        } else {
            SourceGroup[] sourceGroups;
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup sourceGroup : sourceGroups = sources.getSourceGroups("java")) {
                FileObject metaInf = sourceGroup.getRootFolder().getFileObject("META-INF");
                if (metaInf == null) continue;
                JsfAttributesCompletionHelper.handleContracts(metaInf, path, result);
            }
        }
        return result;
    }

    private static void handleContracts(FileObject parent, String path, List<Source> result) {
        FileObject contractsFolder = parent.getFileObject("contracts");
        if (contractsFolder != null) {
            for (FileObject child : contractsFolder.getChildren()) {
                FileObject contract = child.getFileObject(path);
                if (contract == null) continue;
                result.add(Source.create((FileObject)contract));
            }
        }
    }

    public static void completeFacetsInCCImpl(HtmlExtension.CompletionContext context, List<CompletionItem> items, String ns, OpenTag openTag, JsfSupportImpl jsfs) {
        CompositeComponentModel ccModel;
        String tagName;
        if (("http://java.sun.com/jsf/composite".equalsIgnoreCase(ns) || "http://xmlns.jcp.org/jsf/composite".equalsIgnoreCase(ns)) && ("renderFacet".equalsIgnoreCase(tagName = openTag.unqualifiedName().toString()) || "insertFacet".equalsIgnoreCase(tagName)) && "name".equalsIgnoreCase(context.getAttributeName()) && (ccModel = (CompositeComponentModel)JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class).getModel(context.getResult())) != null) {
            Collection<String> facets = ccModel.getDeclaredFacets();
            for (String facet : facets) {
                items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)facet, (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
            }
        }
    }

    public static void completeFacets(HtmlExtension.CompletionContext context, List<CompletionItem> items, String ns, OpenTag openTag, JsfSupportImpl jsfs) {
        String tagName;
        if (("http://java.sun.com/jsf/core".equalsIgnoreCase(ns) || "http://xmlns.jcp.org/jsf/core".equalsIgnoreCase(ns)) && "facet".equalsIgnoreCase(tagName = openTag.unqualifiedName().toString()) && "name".equalsIgnoreCase(context.getAttributeName())) {
            for (String libraryNs : context.getResult().getNamespaces().keySet()) {
                Library library = jsfs.getLibrary(libraryNs);
                if (library == null || !(library instanceof CompositeComponentLibrary)) continue;
                Collection lcs = library.getComponents();
                for (LibraryComponent lc : lcs) {
                    CompositeComponentLibrary.CompositeComponent ccomp = (CompositeComponentLibrary.CompositeComponent)lc;
                    CompositeComponentModel model = ccomp.getComponentModel();
                    for (String facetName : model.getDeclaredFacets()) {
                        items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)facetName, (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
                    }
                }
            }
        }
    }

    public static void completeValueAccordingToType(HtmlExtension.CompletionContext context, List<CompletionItem> items, String ns, OpenTag openTag, JsfSupportImpl jsfs) {
        Library lib = jsfs.getLibrary(ns);
        if (lib == null) {
            return;
        }
        String tagName = openTag.unqualifiedName().toString();
        LibraryComponent comp = lib.getComponent(tagName);
        if (comp == null) {
            return;
        }
        String attrName = context.getAttributeName();
        org.netbeans.modules.web.jsfapi.api.Attribute attr = comp.getTag().getAttribute(attrName);
        if (attr == null) {
            return;
        }
        String aType = attr.getType();
        if ("boolean".equals(aType) || "java.lang.Boolean".equals(aType)) {
            items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)"true", (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
            items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)"false", (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
        }
    }

    public static void completeFaceletsFromProject(HtmlExtension.CompletionContext context, List<CompletionItem> items, String ns, OpenTag openTag) {
        String tagName = openTag.unqualifiedName().toString();
        String attrName = context.getAttributeName();
        if (NamespaceUtils.containsNsOf(Collections.singleton(ns), (DefaultLibraryInfo)DefaultLibraryInfo.FACELETS) && "include".equalsIgnoreCase(tagName) && "src".equalsIgnoreCase(attrName)) {
            items.addAll(FILENAME_SUPPORT.getItems(context.getResult().getSnapshot().getSource().getFileObject(), context.getCCItemStartOffset(), context.getPrefix()));
        }
    }

    public static void completeXMLNSAttribute(HtmlExtension.CompletionContext context, List<CompletionItem> items, JsfSupportImpl jsfs) {
        if (context.getAttributeName().toLowerCase(Locale.ENGLISH).startsWith("xmlns")) {
            Set nss = NamespaceUtils.getAvailableNss(jsfs.getLibraries(), (boolean)jsfs.isJsf22Plus());
            nss.add("http://www.w3.org/1999/xhtml");
            for (String namespace : nss) {
                if (!namespace.startsWith(context.getPrefix())) continue;
                items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)namespace, (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
            }
        }
    }

    public static void completeTagLibraryMetadata(HtmlExtension.CompletionContext context, List<CompletionItem> items, String ns, OpenTag openTag) {
        Collection valueTypes;
        TagAttrMetadata attr;
        TagMetadata tag;
        String attrName = context.getAttributeName();
        String tagName = openTag.unqualifiedName().toString();
        LibraryMetadata lib = FaceletsLibraryMetadata.get(ns);
        if (lib != null && (tag = lib.getTag(tagName)) != null && (attr = tag.getAttribute(attrName)) != null && (valueTypes = attr.getValueTypes()) != null) {
            for (AttrValueType valueType : valueTypes) {
                String[] possibleVals = valueType.getPossibleValues();
                if (possibleVals == null) continue;
                for (String val : possibleVals) {
                    if (!val.startsWith(context.getPrefix())) continue;
                    HtmlCompletionItem itm = HtmlCompletionItem.createAttributeValue((String)val, (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0);
                    items.add((CompletionItem)itm);
                }
            }
        }
    }

    static {
        HTML_TO_JSF_MAPPING.put("a", new HashSet<String>(Arrays.asList("commandLink", "outputLink", "link")));
        HTML_TO_JSF_MAPPING.put("body", new HashSet<String>(Arrays.asList("body")));
        HTML_TO_JSF_MAPPING.put("button", new HashSet<String>(Arrays.asList("commandButton", "button")));
        HTML_TO_JSF_MAPPING.put("form", new HashSet<String>(Arrays.asList("form")));
        HTML_TO_JSF_MAPPING.put("head", new HashSet<String>(Arrays.asList("head")));
        HTML_TO_JSF_MAPPING.put("img", new HashSet<String>(Arrays.asList("graphicImage")));
        HTML_TO_JSF_MAPPING.put("input", new HashSet<String>(Arrays.asList("commandButton", "selectBooleanCheckbox", "inputText", "inputFile", "inputHidden", "inputSecret")));
        HTML_TO_JSF_MAPPING.put("label", new HashSet<String>(Arrays.asList("outputLabel")));
        HTML_TO_JSF_MAPPING.put("link", new HashSet<String>(Arrays.asList("outputStylesheet")));
        HTML_TO_JSF_MAPPING.put("script", new HashSet<String>(Arrays.asList("outputScript")));
        HTML_TO_JSF_MAPPING.put("select", new HashSet<String>(Arrays.asList("selectManyListbox", "selectOneListbox")));
        HTML_TO_JSF_MAPPING.put("textarea", new HashSet<String>(Arrays.asList("inputTextArea")));
    }

    private static final class TypeScanner
    extends ElementScanner6<List<TypeElement>, Void> {
        public TypeScanner() {
            super(new ArrayList());
        }

        private static boolean isAccessibleClass(TypeElement te) {
            NestingKind nestingKind = te.getNestingKind();
            return nestingKind == NestingKind.TOP_LEVEL;
        }

        @Override
        public List<TypeElement> visitType(TypeElement typeElement, Void arg) {
            if (typeElement.getKind() == ElementKind.CLASS && TypeScanner.isAccessibleClass(typeElement)) {
                ((List)this.DEFAULT_VALUE).add(typeElement);
            }
            return (List)super.visitType(typeElement, arg);
        }
    }

    private static class FilenameSupport
    extends FileReferenceCompletion<HtmlCompletionItem> {
        private FilenameSupport() {
        }

        public HtmlCompletionItem createFileItem(FileObject file, int anchor) {
            return HtmlCompletionItem.createFileCompletionItem((FileObject)file, (int)anchor);
        }

        public HtmlCompletionItem createGoUpItem(int anchor, Color color, ImageIcon icon) {
            return HtmlCompletionItem.createGoUpFileCompletionItem((int)anchor, (Color)color, (ImageIcon)icon);
        }
    }
}

