/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.DbSystemSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListDbSystemsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private String backupId;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private DbSystemSummary.LifecycleState lifecycleState;
    private String availabilityDomain;
    private String displayName;

    @ConstructorProperties(value={"compartmentId", "limit", "page", "backupId", "sortBy", "sortOrder", "lifecycleState", "availabilityDomain", "displayName"})
    ListDbSystemsRequest(String compartmentId, Integer limit, String page, String backupId, SortBy sortBy, SortOrder sortOrder, DbSystemSummary.LifecycleState lifecycleState, String availabilityDomain, String displayName) {
        this.compartmentId = compartmentId;
        this.limit = limit;
        this.page = page;
        this.backupId = backupId;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.availabilityDomain = availabilityDomain;
        this.displayName = displayName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).limit(this.limit).page(this.page).backupId(this.backupId).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).availabilityDomain(this.availabilityDomain).displayName(this.displayName);
    }

    public String toString() {
        return "ListDbSystemsRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", backupId=" + this.getBackupId() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", availabilityDomain=" + this.getAvailabilityDomain() + ", displayName=" + this.getDisplayName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListDbSystemsRequest)) {
            return false;
        }
        ListDbSystemsRequest other = (ListDbSystemsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$backupId = this.getBackupId();
        String other$backupId = other.getBackupId();
        if (this$backupId == null ? other$backupId != null : !this$backupId.equals(other$backupId)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        DbSystemSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        DbSystemSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$availabilityDomain = this.getAvailabilityDomain();
        String other$availabilityDomain = other.getAvailabilityDomain();
        if (this$availabilityDomain == null ? other$availabilityDomain != null : !this$availabilityDomain.equals(other$availabilityDomain)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListDbSystemsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $backupId = this.getBackupId();
        result = result * 59 + ($backupId == null ? 43 : $backupId.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        DbSystemSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $availabilityDomain = this.getAvailabilityDomain();
        result = result * 59 + ($availabilityDomain == null ? 43 : $availabilityDomain.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public DbSystemSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static class Builder
    implements BmcRequest.Builder<ListDbSystemsRequest, Void> {
        private String compartmentId;
        private Integer limit;
        private String page;
        private String backupId;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private DbSystemSummary.LifecycleState lifecycleState;
        private String availabilityDomain;
        private String displayName;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListDbSystemsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.backupId(o.getBackupId());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.displayName(o.getDisplayName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListDbSystemsRequest build() {
            ListDbSystemsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(DbSystemSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ListDbSystemsRequest buildWithoutInvocationCallback() {
            return new ListDbSystemsRequest(this.compartmentId, this.limit, this.page, this.backupId, this.sortBy, this.sortOrder, this.lifecycleState, this.availabilityDomain, this.displayName);
        }

        public String toString() {
            return "ListDbSystemsRequest.Builder(compartmentId=" + this.compartmentId + ", limit=" + this.limit + ", page=" + this.page + ", backupId=" + this.backupId + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", availabilityDomain=" + this.availabilityDomain + ", displayName=" + this.displayName + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

