/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDbSystemPatchHistoryEntryRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private String patchHistoryEntryId;

    @ConstructorProperties(value={"dbSystemId", "patchHistoryEntryId"})
    GetDbSystemPatchHistoryEntryRequest(String dbSystemId, String patchHistoryEntryId) {
        this.dbSystemId = dbSystemId;
        this.patchHistoryEntryId = patchHistoryEntryId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).patchHistoryEntryId(this.patchHistoryEntryId);
    }

    public String toString() {
        return "GetDbSystemPatchHistoryEntryRequest(super=" + super.toString() + ", dbSystemId=" + this.getDbSystemId() + ", patchHistoryEntryId=" + this.getPatchHistoryEntryId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetDbSystemPatchHistoryEntryRequest)) {
            return false;
        }
        GetDbSystemPatchHistoryEntryRequest other = (GetDbSystemPatchHistoryEntryRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dbSystemId = this.getDbSystemId();
        String other$dbSystemId = other.getDbSystemId();
        if (this$dbSystemId == null ? other$dbSystemId != null : !this$dbSystemId.equals(other$dbSystemId)) {
            return false;
        }
        String this$patchHistoryEntryId = this.getPatchHistoryEntryId();
        String other$patchHistoryEntryId = other.getPatchHistoryEntryId();
        return !(this$patchHistoryEntryId == null ? other$patchHistoryEntryId != null : !this$patchHistoryEntryId.equals(other$patchHistoryEntryId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetDbSystemPatchHistoryEntryRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dbSystemId = this.getDbSystemId();
        result = result * 59 + ($dbSystemId == null ? 43 : $dbSystemId.hashCode());
        String $patchHistoryEntryId = this.getPatchHistoryEntryId();
        result = result * 59 + ($patchHistoryEntryId == null ? 43 : $patchHistoryEntryId.hashCode());
        return result;
    }

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getPatchHistoryEntryId() {
        return this.patchHistoryEntryId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbSystemPatchHistoryEntryRequest, Void> {
        private String dbSystemId;
        private String patchHistoryEntryId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbSystemPatchHistoryEntryRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.patchHistoryEntryId(o.getPatchHistoryEntryId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbSystemPatchHistoryEntryRequest build() {
            GetDbSystemPatchHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder patchHistoryEntryId(String patchHistoryEntryId) {
            this.patchHistoryEntryId = patchHistoryEntryId;
            return this;
        }

        public GetDbSystemPatchHistoryEntryRequest buildWithoutInvocationCallback() {
            return new GetDbSystemPatchHistoryEntryRequest(this.dbSystemId, this.patchHistoryEntryId);
        }

        public String toString() {
            return "GetDbSystemPatchHistoryEntryRequest.Builder(dbSystemId=" + this.dbSystemId + ", patchHistoryEntryId=" + this.patchHistoryEntryId + ")";
        }
    }
}

