/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.gradle.execute.EscapeProcessor;
import org.openide.util.RequestProcessor;

class EscapeProcessingOutputStream
extends OutputStream {
    private static final RequestProcessor RP = new RequestProcessor(EscapeProcessingOutputStream.class);
    boolean esc;
    boolean csi;
    final AtomicBoolean closed = new AtomicBoolean();
    final ByteBuffer buffer = new ByteBuffer();
    final EscapeProcessor processor;
    private ScheduledFuture<?> autoFlush;
    private final long autoFlushTimeout;

    public EscapeProcessingOutputStream(EscapeProcessor processor) {
        this(processor, 200L);
    }

    public EscapeProcessingOutputStream(EscapeProcessor processor, long autoFlushTimeout) {
        this.processor = processor;
        this.autoFlushTimeout = autoFlushTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        if (this.closed.get()) {
            return;
        }
        if (b == 27) {
            this.esc = true;
            this.processBulk(false);
        } else if (b == 91 && this.esc) {
            this.csi = true;
            this.esc = false;
        } else {
            this.esc = false;
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (this.csi) {
                    if (b >= 64 && b <= 126) {
                        this.processCommand((char)b);
                        this.csi = false;
                    } else {
                        this.buffer.put(b);
                    }
                } else if (b == 10) {
                    this.buffer.put(b);
                    this.processBulk(false);
                } else if (b >= 32 || b == 9 || b < 0) {
                    this.buffer.put(b);
                    if (this.autoFlush != null) {
                        this.autoFlush.cancel(false);
                    }
                    this.autoFlush = RP.schedule(() -> this.processBulk(true), this.autoFlushTimeout, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.csi) {
            this.processBulk(false);
        }
    }

    private void processCommand(char command) {
        String buf = this.buffer.read();
        String[] sargs = buf.split(";");
        int[] args = new int[sargs.length];
        for (int i = 0; i < sargs.length; ++i) {
            try {
                args[i] = Integer.parseInt(sargs[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String sequence = "\u001b[" + buf + command;
        this.processor.processCommand(sequence, command, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBulk(boolean forced) {
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            String out = this.buffer.read();
            if (out.length() > 0 || forced) {
                this.processor.processText(out, forced);
            }
        }
    }

    private static class ByteBuffer {
        private int pos = 0;
        private byte[] buf = new byte[1024];

        private ByteBuffer() {
        }

        public void put(int b) {
            if (this.pos == this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, this.buf.length + 1024);
            }
            this.buf[this.pos++] = (byte)b;
        }

        public String read() {
            String ret = new String(this.buf, 0, this.pos, StandardCharsets.UTF_8);
            this.pos = 0;
            return ret;
        }
    }
}

