/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.compiler;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.editor.compiler.CompilationUnit;
import org.netbeans.modules.groovy.editor.compiler.PerfData;
import org.netbeans.modules.groovy.editor.compiler.ResourceCache;
import org.netbeans.modules.groovy.editor.compiler.TimedSoftReference;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class ClassLoaderFactory {
    private static final Logger LOG = Logger.getLogger(ClassLoaderFactory.class.getName());
    private static final int MAX_LOADER_CACHE = 20;
    private final String name;
    private Map<List<ClassPath>, Reference<CachedClassLoader>> loaderMap = new LinkedHashMap<List<ClassPath>, Reference<CachedClassLoader>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<List<ClassPath>, Reference<CachedClassLoader>> eldest) {
            if (this.size() >= 20) {
                CachedClassLoader l = eldest.getValue().get();
                if (l != null) {
                    l.detach();
                }
                return true;
            }
            return false;
        }
    };
    private static final AtomicInteger loaderSerial = new AtomicInteger(1);

    public ClassLoaderFactory() {
        this("<global>");
    }

    private ClassLoaderFactory(String n) {
        this.name = n;
    }

    public static ClassLoaderFactory forProject(Project p) {
        return new ClassLoaderFactory(p.getProjectDirectory().getPath().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ClassLoader createClassLoader(CompilerConfiguration config, ClassPath ... paths) {
        CachedClassLoader l = null;
        Map<List<ClassPath>, Reference<CachedClassLoader>> map = this.loaderMap;
        synchronized (map) {
            List<ClassPath> p = Arrays.asList(paths);
            Reference<CachedClassLoader> ref = this.loaderMap.get(p);
            if (ref != null && (l = ref.get()) != null && l.validate(paths)) {
                LOG.log(Level.FINER, "{0}: using existing classloader #{1}", new Object[]{this.name, l.id});
                return l;
            }
            ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])paths);
            l = new CachedClassLoader(config, p, cp);
            int id = l.id;
            LOG.log(Level.FINER, "{0}: creating classloader #{2} for paths {1}", new Object[]{this.name, p, id});
            this.loaderMap.put(p, new TimedSoftReference<CachedClassLoader>(l, r -> {
                Map<List<ClassPath>, Reference<CachedClassLoader>> map = this.loaderMap;
                synchronized (map) {
                    LOG.log(Level.FINER, "{0}: Expired reference to classloaedr #{1}", new Object[]{this.name, id});
                    this.loaderMap.remove(p, r);
                }
            }));
        }
        return l;
    }

    @NonNull
    public static ClassLoaderFactory forFile(@NonNull FileObject f) {
        Project p;
        ClassLoaderFactory clf = null;
        Project project = p = f == null ? null : FileOwnerQuery.getOwner((FileObject)f);
        if (p != null) {
            clf = (ClassLoaderFactory)p.getLookup().lookup(ClassLoaderFactory.class);
        }
        if (clf == null && (clf = (ClassLoaderFactory)Lookup.getDefault().lookup(ClassLoaderFactory.class)) == null) {
            throw new IllegalStateException();
        }
        return clf;
    }

    private class CachedClassLoader
    extends ClassLoader
    implements PropertyChangeListener {
        private final List<ClassPath> key;
        private final ResourceCache resCache;
        private final List<FileObject> pathRoots;
        private final List<Long> timestamps;
        private final PropertyChangeListener weakL;
        private final int id;

        public CachedClassLoader(CompilerConfiguration config, List<ClassPath> key, ClassPath p) {
            super(CompilationUnit.class.getClassLoader());
            this.id = loaderSerial.getAndIncrement();
            this.key = key;
            this.pathRoots = Arrays.asList(p.getRoots());
            this.resCache = new ResourceCache(p);
            this.weakL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)p);
            p.addPropertyChangeListener(this.weakL);
            this.timestamps = this.timestamps(this.pathRoots);
        }

        private List<Long> timestamps(List<FileObject> roots) {
            ArrayList<Long> stamps = new ArrayList<Long>(roots.size());
            for (FileObject f : roots) {
                FileObject ar;
                long ts = f.isValid() ? ((ar = FileUtil.getArchiveFile((FileObject)f)) != null ? ar.lastModified().getTime() : f.lastModified().getTime()) : -1L;
                stamps.add(ts);
            }
            return stamps;
        }

        void detach() {
            LOG.log(Level.FINER, "Detaching loader #{0} from classpath", this.id);
            this.resCache.getPath().removePropertyChangeListener(this.weakL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidate() {
            LOG.log(Level.FINER, "Invalidating loader #{0}", this.id);
            this.detach();
            Map map = ClassLoaderFactory.this.loaderMap;
            synchronized (map) {
                Reference ref = (Reference)ClassLoaderFactory.this.loaderMap.get(this.key);
                if (ref != null && ref.get() == this) {
                    ClassLoaderFactory.this.loaderMap.remove(this.key);
                }
            }
        }

        boolean validate(ClassPath ... paths) {
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            for (ClassPath cp : paths) {
                roots.addAll(Arrays.asList(cp.getRoots()));
            }
            if (this.pathRoots.equals(roots) && this.timestamps.equals(this.timestamps(roots))) {
                return true;
            }
            this.invalidate();
            return false;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"roots".equals(evt.getPropertyName())) {
                return;
            }
            LOG.log(Level.FINER, "Loader #{0} got PROP_ROOTS", this.id);
            ClassPath[] paths = this.key.toArray(new ClassPath[this.key.size()]);
            this.validate(paths);
        }

        @Override
        public Enumeration<URL> findResources(String name) throws IOException {
            return this.resCache.getResources(name);
        }

        @Override
        public URL findResource(String name) {
            return this.resCache.getResource(name);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            String path = name.replace('.', '/').concat(".class");
            URL u = this.findResource(path);
            if (u == null) {
                return null;
            }
            PerfData.LOG.log(Level.FINER, "** Found class: {0} ", name);
            try {
                int len;
                URLConnection con = u.openConnection();
                byte[] buf = new byte[len];
                try (InputStream is = u.openStream();){
                    int x;
                    int o = 0;
                    for (int remains = len = con.getContentLength(); remains > 0; remains -= x) {
                        x = is.read(buf, o, remains);
                        o += x;
                    }
                }
                return this.defineClass(name, buf, 0, len);
            }
            catch (IOException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
    }
}

