/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.metrics;

import io.github.resilience4j.core.metrics.Metrics;
import io.github.resilience4j.core.metrics.PartialAggregation;
import io.github.resilience4j.core.metrics.Snapshot;
import io.github.resilience4j.core.metrics.SnapshotImpl;
import io.github.resilience4j.core.metrics.TotalAggregation;
import java.time.Clock;
import java.util.concurrent.TimeUnit;

public class SlidingTimeWindowMetrics
implements Metrics {
    final PartialAggregation[] partialAggregations;
    private final int timeWindowSizeInSeconds;
    private final TotalAggregation totalAggregation;
    private final Clock clock;
    int headIndex;

    public SlidingTimeWindowMetrics(int timeWindowSizeInSeconds) {
        this(timeWindowSizeInSeconds, Clock.systemUTC());
    }

    public SlidingTimeWindowMetrics(int timeWindowSizeInSeconds, Clock clock) {
        this.clock = clock;
        this.timeWindowSizeInSeconds = timeWindowSizeInSeconds;
        this.partialAggregations = new PartialAggregation[timeWindowSizeInSeconds];
        this.headIndex = 0;
        long epochSecond = clock.instant().getEpochSecond();
        for (int i = 0; i < timeWindowSizeInSeconds; ++i) {
            this.partialAggregations[i] = new PartialAggregation(epochSecond);
            ++epochSecond;
        }
        this.totalAggregation = new TotalAggregation();
    }

    @Override
    public synchronized Snapshot record(long duration, TimeUnit durationUnit, Metrics.Outcome outcome) {
        this.totalAggregation.record(duration, durationUnit, outcome);
        this.moveWindowToCurrentEpochSecond(this.getLatestPartialAggregation()).record(duration, durationUnit, outcome);
        return new SnapshotImpl(this.totalAggregation);
    }

    @Override
    public synchronized Snapshot getSnapshot() {
        this.moveWindowToCurrentEpochSecond(this.getLatestPartialAggregation());
        return new SnapshotImpl(this.totalAggregation);
    }

    private PartialAggregation moveWindowToCurrentEpochSecond(PartialAggregation latestPartialAggregation) {
        PartialAggregation currentPartialAggregation;
        long currentEpochSecond = this.clock.instant().getEpochSecond();
        long differenceInSeconds = currentEpochSecond - latestPartialAggregation.getEpochSecond();
        if (differenceInSeconds == 0L) {
            return latestPartialAggregation;
        }
        long secondsToMoveTheWindow = Math.min(differenceInSeconds, (long)this.timeWindowSizeInSeconds);
        do {
            this.moveHeadIndexByOne();
            currentPartialAggregation = this.getLatestPartialAggregation();
            this.totalAggregation.removeBucket(currentPartialAggregation);
            currentPartialAggregation.reset(currentEpochSecond - --secondsToMoveTheWindow);
        } while (secondsToMoveTheWindow > 0L);
        return currentPartialAggregation;
    }

    private PartialAggregation getLatestPartialAggregation() {
        return this.partialAggregations[this.headIndex];
    }

    void moveHeadIndexByOne() {
        this.headIndex = (this.headIndex + 1) % this.timeWindowSizeInSeconds;
    }
}

