/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

class ProviderRegistry {
    static final String PANELS_FOLDER = "Navigator/Panels/";
    private static final Lookup.Template<NavigatorPanel> NAV_PANEL_TEMPLATE = new Lookup.Template(NavigatorPanel.class);
    private static ProviderRegistry instance;
    private Map<String, Collection<? extends NavigatorPanel>> contentTypes2Providers;
    private Map<FileObject, Reference<Collection<? extends NavigatorPanel>>> file2Providers;

    private ProviderRegistry() {
    }

    public static ProviderRegistry getInstance() {
        if (instance == null) {
            instance = new ProviderRegistry();
        }
        return instance;
    }

    public Collection<? extends NavigatorPanel> getProviders(String contentType, FileObject file) {
        Collection<? extends NavigatorPanel> result;
        if (this.contentTypes2Providers == null) {
            this.contentTypes2Providers = new HashMap<String, Collection<? extends NavigatorPanel>>(15);
        }
        if ((result = this.contentTypes2Providers.get(contentType)) == null) {
            result = this.loadProviders(contentType);
            this.contentTypes2Providers.put(contentType, result);
        }
        if (file != null) {
            URI uri;
            Reference fileResultRef;
            Collection fileResult;
            if (this.file2Providers == null) {
                this.file2Providers = new WeakHashMap<FileObject, Reference<Collection<? extends NavigatorPanel>>>();
            }
            Collection collection = fileResult = (fileResultRef = this.file2Providers.computeIfAbsent(file, arg_0 -> ProviderRegistry.lambda$getProviders$1(uri = file.toURI(), arg_0))) != null ? (Collection)fileResultRef.get() : null;
            if (result == null) {
                return fileResult;
            }
            if (fileResult == null) {
                return result;
            }
            ArrayList<? extends NavigatorPanel> panels = new ArrayList<NavigatorPanel>();
            panels.addAll(result);
            panels.addAll(fileResult);
            return panels;
        }
        return result;
    }

    private Collection<? extends NavigatorPanel> loadProviders(String contentType) {
        String path = PANELS_FOLDER + contentType;
        Lookup.Result result = Lookups.forPath((String)path).lookup(NAV_PANEL_TEMPLATE);
        return result.allInstances();
    }

    private static /* synthetic */ Reference lambda$getProviders$1(URI uri, FileObject f) {
        return new SoftReference<Collection>(Lookup.getDefault().lookupAll(NavigatorPanel.DynamicRegistration.class).stream().flatMap(reg -> reg.panelsFor(uri).stream()).collect(Collectors.toList()));
    }
}

