/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.breakpoints;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Breakpoint;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Request;
import org.netbeans.lib.v8debug.V8Response;
import org.netbeans.lib.v8debug.commands.ChangeBreakpoint;
import org.netbeans.lib.v8debug.commands.ClearBreakpoint;
import org.netbeans.lib.v8debug.commands.Flags;
import org.netbeans.lib.v8debug.commands.SetBreakpoint;
import org.netbeans.lib.v8debug.events.BreakEventBody;
import org.netbeans.modules.javascript.v8debug.ScriptsHandler;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.breakpoints.Bundle;
import org.netbeans.modules.javascript.v8debug.breakpoints.SubmittedBreakpoint;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointStatus;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;
import org.openide.util.WeakSet;

public class BreakpointsHandler
implements V8Debugger.Listener {
    private static final Logger LOG = Logger.getLogger(BreakpointsHandler.class.getName());
    private final V8Debugger dbg;
    private final V8Debugger.CommandResponseCallback breakpointsCommandsCallback = new BreakpointsCommandsCallback();
    private final Map<V8Arguments, Pair<JSLineBreakpoint, SourceMapsTranslator.Location>> submittingBreakpoints = new HashMap<V8Arguments, Pair<JSLineBreakpoint, SourceMapsTranslator.Location>>();
    private final Map<JSLineBreakpoint, SubmittedBreakpoint> submittedBreakpoints = new HashMap<JSLineBreakpoint, SubmittedBreakpoint>();
    private final Map<Long, SubmittedBreakpoint> breakpointsById = new HashMap<Long, SubmittedBreakpoint>();
    private final Set<JSLineBreakpoint> removeAfterSubmit = new WeakSet();
    private final List<ActiveBreakpointListener> abListeners = new CopyOnWriteArrayList<ActiveBreakpointListener>();
    private volatile JSLineBreakpoint activeBreakpoint;
    private final List<BreakpointsActiveListener> acListeners = new CopyOnWriteArrayList<BreakpointsActiveListener>();
    private volatile boolean areBreakpointsActive = true;

    public BreakpointsHandler(V8Debugger dbg) {
        this.dbg = dbg;
        dbg.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(JSLineBreakpoint lb) {
        Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location> srargsLoc = this.createSetRequestArguments(lb);
        LOG.log(Level.FINE, "Adding {0}, args = {1}", new Object[]{lb, srargsLoc.first()});
        if (srargsLoc == null) {
            return false;
        }
        Map<V8Arguments, Pair<JSLineBreakpoint, SourceMapsTranslator.Location>> map = this.submittingBreakpoints;
        synchronized (map) {
            this.submittingBreakpoints.put((V8Arguments)srargsLoc.first(), (Pair<JSLineBreakpoint, SourceMapsTranslator.Location>)Pair.of((Object)lb, (Object)((SourceMapsTranslator.Location)srargsLoc.second())));
        }
        JSBreakpointStatus.setInvalid((JSLineBreakpoint)lb, (String)Bundle.MSG_BRKP_Unresolved());
        V8Request request = this.dbg.sendCommandRequest(V8Command.Setbreakpoint, (V8Arguments)srargsLoc.first(), this.breakpointsCommandsCallback);
        LOG.log(Level.FINE, "  request = {0}", request);
        if (request == null) {
            Map<V8Arguments, Pair<JSLineBreakpoint, SourceMapsTranslator.Location>> map2 = this.submittingBreakpoints;
            synchronized (map2) {
                this.submittingBreakpoints.remove(srargsLoc.first());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(JSLineBreakpoint lb) {
        SubmittedBreakpoint sb;
        Map<JSLineBreakpoint, SubmittedBreakpoint> map = this.submittedBreakpoints;
        synchronized (map) {
            sb = this.submittedBreakpoints.get(lb);
            if (sb == null) {
                this.removeAfterSubmit.add(lb);
                return false;
            }
        }
        sb.notifyDestroyed();
        return this.requestRemove(lb, sb.getId());
    }

    private boolean requestRemove(JSLineBreakpoint lb, long id) {
        ClearBreakpoint.Arguments cbargs = new ClearBreakpoint.Arguments(id);
        V8Request request = this.dbg.sendCommandRequest(V8Command.Clearbreakpoint, (V8Arguments)cbargs);
        LOG.log(Level.FINE, "Removing {0}, request = {1}", new Object[]{lb, request});
        return request != null;
    }

    @CheckForNull
    private Pair<SetBreakpoint.Arguments, SourceMapsTranslator.Location> createSetRequestArguments(JSLineBreakpoint b) {
        FileObject fo = b.getFileObject();
        ScriptsHandler scriptsHandler = this.dbg.getScriptsHandler();
        String serverPath = null;
        long lineNumber = (long)b.getLineNumber() - 1L;
        Long columnNumber = null;
        SourceMapsTranslator.Location bpLocation = null;
        if (fo != null) {
            SourceMapsTranslator.Location loc;
            SourceMapsTranslator.Location cl;
            SourceMapsTranslator smt = this.dbg.getScriptsHandler().getSourceMapsTranslator();
            if (smt != null && (cl = smt.getCompiledLocation(loc = new SourceMapsTranslator.Location(fo, (int)lineNumber, 0))) != loc) {
                fo = cl.getFile();
                lineNumber = cl.getLine();
                columnNumber = cl.getColumn();
                if (lineNumber == 0L) {
                    columnNumber = columnNumber + (long)this.dbg.getScriptsHandler().getScriptFirstLineColumnShift(fo);
                }
                bpLocation = cl;
            }
            serverPath = scriptsHandler.getServerPath(fo);
        } else {
            URL url = b.getURL();
            if (scriptsHandler.containsRemoteFile(url)) {
                serverPath = scriptsHandler.getServerPath(url);
            }
        }
        if (serverPath == null) {
            return null;
        }
        String condition = b.isConditional() ? b.getCondition() : null;
        Long groupId = null;
        SetBreakpoint.Arguments args = new SetBreakpoint.Arguments(V8Breakpoint.Type.scriptName, serverPath, Long.valueOf(lineNumber), columnNumber, Boolean.valueOf(b.isEnabled()), condition, null, groupId);
        return Pair.of((Object)args, bpLocation);
    }

    static ChangeBreakpoint.Arguments createChangeRequestArguments(SubmittedBreakpoint sb) {
        JSLineBreakpoint b = sb.getBreakpoint();
        String condition = b.isConditional() ? b.getCondition() : null;
        return new ChangeBreakpoint.Arguments(sb.getId(), Boolean.valueOf(b.isEnabled()), condition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(BreakEventBody beb) {
        long[] ids = beb.getBreakpoints();
        if (ids == null) {
            return;
        }
        for (long id : ids) {
            SubmittedBreakpoint sb;
            Map<JSLineBreakpoint, SubmittedBreakpoint> map = this.submittedBreakpoints;
            synchronized (map) {
                sb = this.breakpointsById.get(id);
            }
            if (sb == null) continue;
            JSLineBreakpoint b = sb.getBreakpoint();
            this.setActiveBreakpoint(b);
        }
    }

    @Override
    public void notifySuspended(boolean suspended) {
        if (!suspended) {
            this.setActiveBreakpoint(null);
        }
    }

    @Override
    public void notifyCurrentFrame(CallFrame cf) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyFinished() {
        ArrayList<SubmittedBreakpoint> sbs;
        Map<V8Arguments, Pair<JSLineBreakpoint, SourceMapsTranslator.Location>> map = this.submittingBreakpoints;
        synchronized (map) {
            this.submittingBreakpoints.clear();
        }
        Map<JSLineBreakpoint, SubmittedBreakpoint> map2 = this.submittedBreakpoints;
        synchronized (map2) {
            sbs = new ArrayList<SubmittedBreakpoint>(this.submittedBreakpoints.values());
            this.submittedBreakpoints.clear();
            this.breakpointsById.clear();
        }
        for (SubmittedBreakpoint sb : sbs) {
            sb.notifyDestroyed();
        }
        this.setActiveBreakpoint(null);
    }

    public JSLineBreakpoint getActiveBreakpoint() {
        return this.activeBreakpoint;
    }

    private void setActiveBreakpoint(JSLineBreakpoint activeBreakpoint) {
        this.activeBreakpoint = activeBreakpoint;
        JSBreakpointStatus.setActive((JSLineBreakpoint)activeBreakpoint);
        for (ActiveBreakpointListener abl : this.abListeners) {
            abl.notifyActiveBreakpoint(activeBreakpoint);
        }
    }

    public void addActiveBreakpointListener(ActiveBreakpointListener abl) {
        this.abListeners.add(abl);
    }

    public void removeActiveBreakpointListener(ActiveBreakpointListener abl) {
        this.abListeners.remove(abl);
    }

    boolean areBreakpointsActive() {
        return this.areBreakpointsActive;
    }

    void setBreakpointsActive(final boolean active) {
        Flags.Arguments args = new Flags.Arguments("breakPointsActive", active);
        V8Request fRequest = this.dbg.sendCommandRequest(V8Command.Flags, (V8Arguments)args, new V8Debugger.CommandResponseCallback(){

            @Override
            public void notifyResponse(V8Request request, V8Response response) {
                if (response != null && response.isSuccess()) {
                    BreakpointsHandler.this.areBreakpointsActive = active;
                    for (BreakpointsActiveListener acl : BreakpointsHandler.this.acListeners) {
                        acl.breakpointsActivated(active);
                    }
                }
            }
        });
    }

    void addBreakpointsActiveListener(BreakpointsActiveListener abl) {
        this.acListeners.add(abl);
    }

    void removeBreakpointsActiveListener(BreakpointsActiveListener abl) {
        this.acListeners.remove(abl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void positionChanged(long bpId, long line, long column) {
        SubmittedBreakpoint sb;
        Map<JSLineBreakpoint, SubmittedBreakpoint> map = this.submittedBreakpoints;
        synchronized (map) {
            sb = this.breakpointsById.get(bpId);
        }
        if (sb != null) {
            sb.updatePosition(line, column);
        }
    }

    private final class BreakpointsCommandsCallback
    implements V8Debugger.CommandResponseCallback {
        private BreakpointsCommandsCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyResponse(V8Request request, V8Response response) {
            Pair lbLoc;
            Map map = BreakpointsHandler.this.submittingBreakpoints;
            synchronized (map) {
                lbLoc = (Pair)BreakpointsHandler.this.submittingBreakpoints.remove(request.getArguments());
            }
            if (lbLoc == null) {
                LOG.log(Level.INFO, "Did not find a submitting breakpoint for response {0}, request was {1}", new Object[]{response, request});
                return;
            }
            JSLineBreakpoint lb = (JSLineBreakpoint)lbLoc.first();
            if (response != null) {
                boolean removed;
                SetBreakpoint.ResponseBody sbrb = (SetBreakpoint.ResponseBody)response.getBody();
                long id = sbrb.getBreakpoint();
                SourceMapsTranslator.Location bpLoc = (SourceMapsTranslator.Location)lbLoc.second();
                SubmittedBreakpoint sb = new SubmittedBreakpoint(lb, id, bpLoc, sbrb.getActualLocations(), BreakpointsHandler.this.dbg);
                Map map2 = BreakpointsHandler.this.submittedBreakpoints;
                synchronized (map2) {
                    BreakpointsHandler.this.submittedBreakpoints.put(lb, sb);
                    BreakpointsHandler.this.breakpointsById.put(id, sb);
                    removed = BreakpointsHandler.this.removeAfterSubmit.remove(lb);
                }
                if (removed) {
                    BreakpointsHandler.this.requestRemove(lb, id);
                    sb.notifyDestroyed();
                } else {
                    JSBreakpointStatus.setValid((JSLineBreakpoint)lb, (String)Bundle.MSG_BRKP_Resolved());
                }
            } else {
                JSBreakpointStatus.setInvalid((JSLineBreakpoint)lb, (String)response.getErrorMessage());
            }
        }
    }

    static interface BreakpointsActiveListener {
        public void breakpointsActivated(boolean var1);
    }

    public static interface ActiveBreakpointListener {
        public void notifyActiveBreakpoint(JSLineBreakpoint var1);
    }
}

